/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.secondCycle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessDocumentUploadBean;
import org.fenixedu.academic.domain.candidacyProcess.FormationBean;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacy;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFileType;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcessWithPrecedentDegreeInformationBean;
import org.fenixedu.academic.domain.candidacyProcess.PrecedentDegreeInformationBeanFactory;
import org.fenixedu.academic.domain.candidacyProcess.secondCycle.SecondCycleCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.secondCycle.SecondCycleIndividualCandidacyProcess;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.joda.time.LocalDate;

public class SecondCycleIndividualCandidacyProcessBean
extends IndividualCandidacyProcessWithPrecedentDegreeInformationBean {
    private Degree selectedDegree;
    private String professionalStatus;
    private String otherEducation;
    private String istStudentNumber;
    private List<CandidacyProcessDocumentUploadBean> habilitationCertificateList;
    private List<CandidacyProcessDocumentUploadBean> reportOrWorkDocumentList;
    private CandidacyProcessDocumentUploadBean handicapProofDocument;
    private CandidacyProcessDocumentUploadBean curriculumVitaeDocument;
    private Set<Degree> selectedDegreeList;
    private SecondCycleCandidacyProcess copyDestinationProcess;

    public SecondCycleIndividualCandidacyProcessBean() {
        this.setCandidacyDate(new LocalDate());
        this.setFormationConcludedBeanList(new ArrayList<FormationBean>());
        this.initializeDocumentUploadBeans();
        this.setObservations("");
        this.setIstStudentNumber("");
        this.setPrecedentDegreeType(IndividualCandidacyProcessWithPrecedentDegreeInformationBean.PrecedentDegreeType.EXTERNAL_DEGREE);
        this.selectedDegreeList = new HashSet<Degree>();
    }

    public SecondCycleIndividualCandidacyProcessBean(SecondCycleIndividualCandidacyProcess process2) {
        this.setIndividualCandidacyProcess((IndividualCandidacyProcess)((Object)process2));
        this.setCandidacyProcess(process2.getCandidacyProcess());
        this.setProfessionalStatus(process2.getCandidacyProfessionalStatus());
        this.setOtherEducation(process2.getCandidacyOtherEducation());
        this.setPrecedentDegreeInformation(PrecedentDegreeInformationBeanFactory.createBean((IndividualCandidacy)((Object)process2.getCandidacy())));
        this.setPrecedentDegreeType(IndividualCandidacyProcessWithPrecedentDegreeInformationBean.PrecedentDegreeType.valueOf(process2.getPrecedentDegreeInformation()));
        this.setCandidacyDate(process2.getCandidacyDate());
        this.initializeFormation(process2.getCandidacy().getFormationsSet());
        this.setObservations(process2.getCandidacy().getObservations());
        this.setIstStudentNumber(process2.getCandidacy().getFormerStudentNumber());
        this.setProcessChecked(process2.getProcessChecked());
        this.setPaymentChecked(process2.getPaymentChecked());
        this.selectedDegreeList = new HashSet<Degree>();
        this.selectedDegreeList.addAll(process2.getSelectedDegrees());
    }

    public SecondCycleCandidacyProcess getCandidacyProcess() {
        return (SecondCycleCandidacyProcess)((Object)super.getCandidacyProcess());
    }

    public Degree getSelectedDegree() {
        return this.selectedDegree;
    }

    public void setSelectedDegree(Degree selectedDegree) {
        this.selectedDegree = selectedDegree;
    }

    public String getProfessionalStatus() {
        return this.professionalStatus;
    }

    public void setProfessionalStatus(String professionalStatus) {
        this.professionalStatus = professionalStatus;
    }

    public String getOtherEducation() {
        return this.otherEducation;
    }

    public void setOtherEducation(String otherEducation) {
        this.otherEducation = otherEducation;
    }

    @Override
    public boolean hasChoosenPerson() {
        return this.getChoosePersonBean().hasPerson();
    }

    @Override
    public void removeChoosePersonBean() {
        this.setChoosePersonBean(null);
    }

    @Override
    protected double getMinimumEcts(CycleType cycleType) {
        if (!cycleType.equals((Object)CycleType.FIRST_CYCLE)) {
            throw new IllegalArgumentException();
        }
        return 150.0;
    }

    @Override
    protected List<CycleType> getValidPrecedentCycleTypes() {
        return Collections.singletonList(CycleType.FIRST_CYCLE);
    }

    @Override
    protected boolean isPreBolonhaPrecedentDegreeAllowed() {
        return true;
    }

    public List<CandidacyProcessDocumentUploadBean> getHabilitationCertificateList() {
        return this.habilitationCertificateList;
    }

    public void setHabilitationCertificateList(List<CandidacyProcessDocumentUploadBean> habilitationCertificateList) {
        this.habilitationCertificateList = habilitationCertificateList;
    }

    public List<CandidacyProcessDocumentUploadBean> getReportOrWorkDocumentList() {
        return this.reportOrWorkDocumentList;
    }

    public void setReportOrWorkDocumentList(List<CandidacyProcessDocumentUploadBean> reportOrWorkDocumentList) {
        this.reportOrWorkDocumentList = reportOrWorkDocumentList;
    }

    public CandidacyProcessDocumentUploadBean getHandicapProofDocument() {
        return this.handicapProofDocument;
    }

    public void setHandicapProofDocument(CandidacyProcessDocumentUploadBean handicapProofDocument) {
        this.handicapProofDocument = handicapProofDocument;
    }

    public CandidacyProcessDocumentUploadBean getCurriculumVitaeDocument() {
        return this.curriculumVitaeDocument;
    }

    public void setCurriculumVitaeDocument(CandidacyProcessDocumentUploadBean curriculumVitaeDocument) {
        this.curriculumVitaeDocument = curriculumVitaeDocument;
    }

    public void addHabilitationCertificateDocument() {
        this.habilitationCertificateList.add(new CandidacyProcessDocumentUploadBean(IndividualCandidacyDocumentFileType.HABILITATION_CERTIFICATE_DOCUMENT));
    }

    public void removeHabilitationCertificateDocument(int index) {
        this.habilitationCertificateList.remove(index);
    }

    public void addReportOrWorkDocument() {
        this.reportOrWorkDocumentList.add(new CandidacyProcessDocumentUploadBean(IndividualCandidacyDocumentFileType.REPORT_OR_WORK_DOCUMENT));
    }

    public void removeReportOrWorkDocument(int index) {
        this.reportOrWorkDocumentList.remove(index);
    }

    public String getIstStudentNumber() {
        return this.istStudentNumber;
    }

    public void setIstStudentNumber(String value) {
        this.istStudentNumber = value;
    }

    @Override
    public void initializeDocumentUploadBeans() {
        this.setDocumentIdentificationDocument(new CandidacyProcessDocumentUploadBean(IndividualCandidacyDocumentFileType.DOCUMENT_IDENTIFICATION));
        this.setPaymentDocument(new CandidacyProcessDocumentUploadBean(IndividualCandidacyDocumentFileType.PAYMENT_DOCUMENT));
        this.setVatCatCopyDocument(new CandidacyProcessDocumentUploadBean(IndividualCandidacyDocumentFileType.VAT_CARD_DOCUMENT));
        this.habilitationCertificateList = new ArrayList<CandidacyProcessDocumentUploadBean>();
        this.addHabilitationCertificateDocument();
        this.reportOrWorkDocumentList = new ArrayList<CandidacyProcessDocumentUploadBean>();
        this.addReportOrWorkDocument();
        this.handicapProofDocument = new CandidacyProcessDocumentUploadBean(IndividualCandidacyDocumentFileType.HANDICAP_PROOF_DOCUMENT);
        this.curriculumVitaeDocument = new CandidacyProcessDocumentUploadBean(IndividualCandidacyDocumentFileType.CV_DOCUMENT);
        this.setPhotoDocument(new CandidacyProcessDocumentUploadBean(IndividualCandidacyDocumentFileType.PHOTO));
    }

    public Set<Degree> getSelectedDegreeList() {
        return this.selectedDegreeList;
    }

    public void setSelectedDegreeList(Set<Degree> selectedDegreeList) {
        this.selectedDegreeList = selectedDegreeList;
    }

    public void addSelectedDegree(Degree degree) {
        this.selectedDegreeList.add(degree);
    }

    public void removeSelectedDegree(Degree degree) {
        this.selectedDegreeList.remove(degree);
    }

    @Override
    public boolean isSecondCycle() {
        return true;
    }

    public List<Degree> getAvailableDegrees() {
        SecondCycleCandidacyProcess candidacyProcess = this.getCandidacyProcess();
        return candidacyProcess.getAvailableDegrees();
    }

    public SecondCycleCandidacyProcess getCopyDestinationProcess() {
        return this.copyDestinationProcess;
    }

    public void setCopyDestinationProcess(SecondCycleCandidacyProcess copyDestinationProcess) {
        this.copyDestinationProcess = copyDestinationProcess;
    }
}

