/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.mobility;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.candidacyProcess.DegreeOfficePublicCandidacyHashCode;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFileType;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityEmailTemplate;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcess;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.domain.util.email.ReplyTo;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.domain.util.email.SystemSender;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;

public enum MobilityEmailTemplateType {
    PREREGISTRATION{
        private static final String APPLICATION_SUBMISSION_LINK = "MobilityIndividualApplicationProcess.const.public.application.submission.link";

        @Override
        public void sendEmailFor(MobilityEmailTemplate mobilityEmailTemplate, DegreeOfficePublicCandidacyHashCode hashCode) {
            String subject = mobilityEmailTemplate.getSubject();
            String body = mobilityEmailTemplate.getBody();
            String link = BundleUtil.getString((String)"resources.CandidateResources", (String)APPLICATION_SUBMISSION_LINK, (String[])new String[0]);
            link = String.format(link, hashCode.getValue(), I18N.getLocale());
            if (body.contains("[submission_link]")) {
                body = body.replace("[submission_link]", link);
            }
            this.sendEmail(subject, body, hashCode.getEmail());
        }

        @Override
        public void sendMultiEmailFor(MobilityEmailTemplate mobilityEmailTemplate, Collection<MobilityIndividualApplicationProcess> processes) {
            throw new DomainException("template.meant.for.single.recipient.only", new String[0]);
        }
    }
    ,
    APPLICATION_SUBMISSION{
        private static final String APPLICATION_ACCESS_LINK = "MobilityIndividualApplicationProcess.const.public.application.access.link";

        @Override
        public void sendEmailFor(MobilityEmailTemplate mobilityEmailTemplate, DegreeOfficePublicCandidacyHashCode hashCode) {
            IndividualCandidacyProcess individualCandidacyProcess = hashCode.getIndividualCandidacyProcess();
            String subject = mobilityEmailTemplate.getSubject();
            String body = mobilityEmailTemplate.getBody();
            String link = String.format(BundleUtil.getString((String)"resources.CandidateResources", (String)APPLICATION_ACCESS_LINK, (String[])new String[0]), hashCode.getValue(), I18N.getLocale().getLanguage());
            String processCode = individualCandidacyProcess.getProcessCode();
            String endDate = individualCandidacyProcess.getCandidacyProcess().getCandidacyEnd().toString("dd/MM/yyyy");
            if (body.contains("[process_number]")) {
                body = body.replace("[process_number]", processCode);
            }
            if (body.contains("[process_access_link]")) {
                body = body.replace("[process_access_link]", link);
            }
            if (body.contains("[application_submission_end_date]")) {
                body = body.replace("[application_submission_end_date]", endDate);
            }
            this.sendEmail(subject, body, hashCode.getEmail());
        }

        @Override
        public void sendMultiEmailFor(MobilityEmailTemplate mobilityEmailTemplate, Collection<MobilityIndividualApplicationProcess> processes) {
            throw new DomainException("template.meant.for.single.recipient.only", new String[0]);
        }
    }
    ,
    MISSING_DOCUMENTS{

        @Override
        public void sendEmailFor(MobilityEmailTemplate mobilityEmailTemplate, DegreeOfficePublicCandidacyHashCode hashCode) {
            String body;
            MobilityIndividualApplicationProcess miap = (MobilityIndividualApplicationProcess)((Object)hashCode.getIndividualCandidacyProcess());
            StringBuilder missingDocs = new StringBuilder();
            for (IndividualCandidacyDocumentFileType missingDocumentType : miap.getMissingRequiredDocumentFiles()) {
                missingDocs.append("- ").append(missingDocumentType.localizedName(Locale.ENGLISH)).append("\n");
            }
            String subject = StringUtils.isEmpty((String)mobilityEmailTemplate.getSubject()) ? MessageFormat.format(BundleUtil.getString((String)"resources.CandidateResources", (String)"message.erasmus.missing.required.documents.email.subject", (String[])new String[0]), Unit.getInstitutionAcronym()) : mobilityEmailTemplate.getSubject();
            String string = body = StringUtils.isEmpty((String)mobilityEmailTemplate.getBody()) ? BundleUtil.getString((String)"resources.CandidateResources", (String)"message.erasmus.missing.required.documents.email.body", (String[])new String[0]) : mobilityEmailTemplate.getBody();
            if (body.contains("[missing_documents]")) {
                body = body.replace("[missing_documents]", missingDocs.toString());
            }
            if (body.contains("[application_submission_end_date]")) {
                body = body.replace("[application_submission_end_date]", miap.getCandidacyEnd().toString("dd/MM/yyyy"));
            }
            this.sendEmail(subject, body, hashCode.getEmail());
        }

        @Override
        public void sendMultiEmailFor(MobilityEmailTemplate mobilityEmailTemplate, Collection<MobilityIndividualApplicationProcess> processes) {
            for (MobilityIndividualApplicationProcess process2 : processes) {
                this.sendEmailFor(mobilityEmailTemplate, process2.getCandidacyHashCode());
            }
        }
    }
    ,
    MISSING_SHIFTS{

        @Override
        public void sendEmailFor(MobilityEmailTemplate mobilityEmailTemplate, DegreeOfficePublicCandidacyHashCode hashCode) {
            String body;
            MobilityIndividualApplicationProcess miap = (MobilityIndividualApplicationProcess)((Object)hashCode.getIndividualCandidacyProcess());
            StringBuilder missingShifts = new StringBuilder();
            for (ExecutionCourse course : miap.getMissingShifts()) {
                missingShifts.append("- ").append(course.getName()).append("\n");
            }
            String subject = StringUtils.isEmpty((String)mobilityEmailTemplate.getSubject()) ? MessageFormat.format(BundleUtil.getString((String)"resources.CandidateResources", (String)"message.erasmus.missing.shifts.email.subject", (String[])new String[0]), Unit.getInstitutionAcronym()) : mobilityEmailTemplate.getSubject();
            String string = body = StringUtils.isEmpty((String)mobilityEmailTemplate.getBody()) ? BundleUtil.getString((String)"resources.CandidateResources", (String)"message.erasmus.missing.shifts.email.body", (String[])new String[0]) : mobilityEmailTemplate.getBody();
            if (body.contains("[missing_shifts]")) {
                body = body.replace("[missing_shifts]", missingShifts.toString());
            }
            this.sendEmail(subject, body, hashCode.getEmail());
        }

        @Override
        public void sendMultiEmailFor(MobilityEmailTemplate mobilityEmailTemplate, Collection<MobilityIndividualApplicationProcess> processes) {
            for (MobilityIndividualApplicationProcess process2 : processes) {
                this.sendEmailFor(mobilityEmailTemplate, process2.getCandidacyHashCode());
            }
        }
    }
    ,
    CANDIDATE_ACCEPTED{
        private static final String APPLICATION_ACCESS_LINK = "MobilityIndividualApplicationProcess.const.public.application.access.link";

        @Override
        public void sendEmailFor(MobilityEmailTemplate mobilityEmailTemplate, DegreeOfficePublicCandidacyHashCode hashCode) {
            String subject = mobilityEmailTemplate.getSubject();
            String body = mobilityEmailTemplate.getBody();
            String link = BundleUtil.getString((String)"resources.CandidateResources", (String)APPLICATION_ACCESS_LINK, (String[])new String[0]);
            link = String.format(link, hashCode.getValue(), I18N.getLocale());
            if (body.contains("[access_link]")) {
                body = body.replace("[access_link]", link);
            }
            this.sendEmail(subject, body, hashCode.getEmail());
        }

        @Override
        public void sendMultiEmailFor(MobilityEmailTemplate mobilityEmailTemplate, Collection<MobilityIndividualApplicationProcess> processes) {
            throw new DomainException("template.meant.for.single.recipient.only", new String[0]);
        }
    }
    ,
    IST_RECEPTION{
        private static final String REGISTRATION_ACCESS_LINK = "MobilityIndividualApplicationProcess.const.public.registration.access.link";

        @Override
        public void sendEmailFor(MobilityEmailTemplate mobilityEmailTemplate, DegreeOfficePublicCandidacyHashCode hashCode) {
            Registration registration;
            String subject = mobilityEmailTemplate.getSubject();
            String body = mobilityEmailTemplate.getBody();
            String link = BundleUtil.getString((String)"resources.CandidateResources", (String)REGISTRATION_ACCESS_LINK, (String[])new String[]{hashCode.getValue()});
            if (body.contains("[registration_link]")) {
                body = body.replace("[registration_link]", link);
            }
            if ((registration = hashCode.getIndividualCandidacyProcess().getCandidacy().getRegistration()) == null) {
                throw new NullPointerException("Students have not yet been registered.");
            }
            if (body.contains("[username]")) {
                body = body.replace("[username]", registration.getPerson().getUsername());
            }
            this.sendEmail(subject, body, hashCode.getEmail());
        }

        @Override
        public void sendMultiEmailFor(MobilityEmailTemplate mobilityEmailTemplate, Collection<MobilityIndividualApplicationProcess> processes) {
            for (MobilityIndividualApplicationProcess process2 : processes) {
                this.sendEmailFor(mobilityEmailTemplate, process2.getCandidacyHashCode());
            }
        }
    };


    public String getName() {
        return this.name();
    }

    public String getLocalizedName() {
        return this.getLocalizedName(I18N.getLocale());
    }

    public String getLocalizedName(Locale locale) {
        return BundleUtil.getString((String)"resources.EnumerationResources", (Locale)locale, (String)this.getQualifiedName(), (String[])new String[0]);
    }

    public String getQualifiedName() {
        return MobilityEmailTemplateType.class.getSimpleName() + "." + this.name();
    }

    public String getFullQualifiedName() {
        return MobilityEmailTemplateType.class.getName() + "." + this.name();
    }

    protected void sendEmail(String fromSubject, String body, String email) {
        SystemSender systemSender = Bennu.getInstance().getSystemSender();
        new Message((Sender)((Object)systemSender), (Collection<? extends ReplyTo>)systemSender.getConcreteReplyTos(), (Collection<Recipient>)Collections.EMPTY_LIST, fromSubject, body, email);
    }

    public abstract void sendEmailFor(MobilityEmailTemplate var1, DegreeOfficePublicCandidacyHashCode var2);

    public abstract void sendMultiEmailFor(MobilityEmailTemplate var1, Collection<MobilityIndividualApplicationProcess> var2);
}

