/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.serviceRequests;

import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.PhotocopyRequestEvent_Base;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.serviceRequests.RegistrationAcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.PhotocopyRequest;
import org.fenixedu.academic.util.LabelFormatter;

public class PhotocopyRequestEvent
extends PhotocopyRequestEvent_Base {
    protected PhotocopyRequestEvent() {
    }

    public PhotocopyRequestEvent(AdministrativeOffice administrativeOffice, Person person, PhotocopyRequest request) {
        this();
        super.init(administrativeOffice, request.getEventType(), person, (RegistrationAcademicServiceRequest)((Object)request));
    }

    public PhotocopyRequest getAcademicServiceRequest() {
        return (PhotocopyRequest)((Object)super.getAcademicServiceRequest());
    }

    public Integer getNumberOfPages() {
        return this.getAcademicServiceRequest().getNumberOfPages();
    }

    public LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel(entryType.name(), "resources.EnumerationResources");
        if (!StringUtils.isEmpty((String)this.getAcademicServiceRequest().getPurpose())) {
            labelFormatter.appendLabel(" (").appendLabel(this.getAcademicServiceRequest().getPurpose()).appendLabel(")");
        }
        if (this.getAcademicServiceRequest().getExecutionYear() != null) {
            labelFormatter.appendLabel(" - " + this.getExecutionYear().getYear());
        }
        return labelFormatter;
    }
}

