/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.serviceRequests;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.IPastRequestEvent;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.PastEquivalencePlanRevisionRequestEvent_Base;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.EquivalencePlanRevisionRequest;
import org.fenixedu.academic.domain.serviceRequests.RegistrationAcademicServiceRequest;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.academic.util.Money;

public class PastEquivalencePlanRevisionRequestEvent
extends PastEquivalencePlanRevisionRequestEvent_Base
implements IPastRequestEvent {
    protected PastEquivalencePlanRevisionRequestEvent() {
    }

    public PastEquivalencePlanRevisionRequestEvent(AdministrativeOffice administrativeOffice, Person person, EquivalencePlanRevisionRequest request) {
        this();
        super.init(administrativeOffice, EventType.PAST_REVISION_EQUIVALENCE_PLAN_REQUEST, person, (RegistrationAcademicServiceRequest)((Object)request));
    }

    @Override
    public void setPastAmount(Money pastAmount) {
        throw new DomainException("error.accounting.events.cannot.modify.pastAmount", new String[0]);
    }

    public LabelFormatter getDescription() {
        LabelFormatter result = super.getDescription();
        this.fillDescription(result);
        return result;
    }

    public final LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel(entryType.name(), "resources.EnumerationResources");
        this.fillDescription(labelFormatter);
        if (this.getAcademicServiceRequest().getExecutionYear() != null) {
            labelFormatter.appendLabel(" - " + this.getExecutionYear().getYear());
        }
        return labelFormatter;
    }

    private void fillDescription(LabelFormatter labelFormatter) {
        labelFormatter.appendLabel(" (");
        labelFormatter.appendLabel(this.getDegree().getDegreeType().getName().getContent());
        labelFormatter.appendLabel(" ");
        labelFormatter.appendLabel("label.in", "resources.ApplicationResources");
        labelFormatter.appendLabel(" ");
        labelFormatter.appendLabel(this.getDegree().getNameFor(this.getExecutionYear()).getContent());
        labelFormatter.appendLabel(")");
    }
}

