/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.gratuity;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.Entry;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.events.gratuity.StandaloneEnrolmentGratuityEvent_Base;
import org.fenixedu.academic.domain.accounting.paymentCodes.AccountingEventPaymentCode;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.dto.accounting.SibsTransactionDetailDTO;
import org.fenixedu.academic.util.LabelFormatter;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.YearMonthDay;

public class StandaloneEnrolmentGratuityEvent
extends StandaloneEnrolmentGratuityEvent_Base {
    protected StandaloneEnrolmentGratuityEvent() {
    }

    public StandaloneEnrolmentGratuityEvent(AdministrativeOffice administrativeOffice, Person person, StudentCurricularPlan studentCurricularPlan, ExecutionYear executionYear) {
        this();
        this.init(administrativeOffice, EventType.STANDALONE_ENROLMENT_GRATUITY, person, studentCurricularPlan, executionYear);
    }

    public Account getToAccount() {
        return this.getAdministrativeOffice().getUnit().getInternalAccount();
    }

    public boolean isOpen() {
        if (this.isCancelled()) {
            return false;
        }
        return this.calculateAmountToPay(new DateTime()).greaterThan(Money.ZERO);
    }

    public boolean isClosed() {
        if (this.isCancelled()) {
            return false;
        }
        return this.calculateAmountToPay(new DateTime()).lessOrEqualThan(Money.ZERO);
    }

    public LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel(entryType.name(), "resources.EnumerationResources").appendLabel(" - ").appendLabel(this.getExecutionYear().getYear());
        return labelFormatter;
    }

    public boolean isDepositSupported() {
        return true;
    }

    public Set<EntryType> getPossibleEntryTypesForDeposit() {
        return Collections.singleton(EntryType.STANDALONE_ENROLMENT_GRATUITY_FEE);
    }

    public LabelFormatter getDescription() {
        LabelFormatter result = new LabelFormatter();
        result.appendLabel(this.getEventType().getQualifiedName(), "resources.EnumerationResources").appendLabel(" - ").appendLabel(this.getExecutionYear().getYear());
        return result;
    }

    protected List<AccountingEventPaymentCode> createPaymentCodes() {
        EntryDTO entryDTO = (EntryDTO)this.calculateEntries(new DateTime()).iterator().next();
        return Collections.singletonList(this.createPaymentCode(entryDTO));
    }

    private AccountingEventPaymentCode createPaymentCode(EntryDTO entryDTO) {
        return AccountingEventPaymentCode.create(PaymentCodeType.TOTAL_GRATUITY, new YearMonthDay(), this.calculatePaymentCodeEndDate(), (Event)((Object)this), entryDTO.getAmountToPay(), entryDTO.getAmountToPay(), this.getPerson());
    }

    protected List<AccountingEventPaymentCode> updatePaymentCodes() {
        EntryDTO entryDTO = (EntryDTO)this.calculateEntries(new DateTime()).iterator().next();
        if (!this.getNonProcessedPaymentCodes().isEmpty()) {
            ((AccountingEventPaymentCode)((Object)this.getNonProcessedPaymentCodes().iterator().next())).update(new YearMonthDay(), this.calculatePaymentCodeEndDate(), entryDTO.getAmountToPay(), entryDTO.getAmountToPay());
        } else {
            this.createPaymentCode(entryDTO);
        }
        return this.getNonProcessedPaymentCodes();
    }

    private YearMonthDay calculatePaymentCodeEndDate() {
        LocalDate nextMonth = new LocalDate().plusMonths(1);
        return new YearMonthDay(nextMonth.getYear(), nextMonth.getMonthOfYear(), 1).minusDays(1);
    }

    protected Set<Entry> internalProcess(User responsibleUser, AccountingEventPaymentCode paymentCode, Money amountToPay, SibsTransactionDetailDTO transactionDetail) {
        AccountingTransaction transaction = this.depositAmount(responsibleUser, amountToPay, EntryType.STANDALONE_ENROLMENT_GRATUITY_FEE, transactionDetail);
        return Collections.singleton(transaction.getToAccountEntry());
    }

    public boolean isExemptionAppliable() {
        return true;
    }
}

