/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.accessControl.FenixGroupStrategy;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.space.SpaceUtils;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.spaces.domain.Space;
import org.joda.time.DateTime;

@GroupOperator(value="specificSpaceOccupationManagersGroup")
public class SpecificSpaceOccupationManagersGroup
extends FenixGroupStrategy {
    private static final long serialVersionUID = 1L;

    public Set<User> getMembers() {
        return SpaceUtils.allocatableSpaces().map(s -> s.getOccupationsGroupWithChainOfResponsability()).filter(g -> g != null).flatMap(g -> g.getMembers().stream()).collect(Collectors.toSet());
    }

    public boolean isMember(User user) {
        if (user != null && RoleType.RESOURCE_ALLOCATION_MANAGER.isMember(user)) {
            return true;
        }
        return Space.getSpaces().filter(Space::isActive).anyMatch(space -> space.isOccupationMember(user));
    }

    public Set<User> getMembers(DateTime when) {
        return this.getMembers();
    }

    public boolean isMember(User user, DateTime when) {
        return this.isMember(user);
    }
}

