/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.EvaluationManagementLog;
import org.fenixedu.academic.domain.Evaluation_Base;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.Mark;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.dto.InfoEvaluation;
import org.fenixedu.academic.util.EvaluationType;
import org.fenixedu.bennu.core.domain.Bennu;

public abstract class Evaluation
extends Evaluation_Base {
    public Evaluation() {
        this.setGradeScale(GradeScale.TYPE20);
        this.setRootDomainObject(Bennu.getInstance());
    }

    public List<ExecutionCourse> getAttendingExecutionCoursesFor(Registration registration) {
        ArrayList<ExecutionCourse> result = new ArrayList<ExecutionCourse>();
        for (ExecutionCourse executionCourse : this.getAssociatedExecutionCoursesSet()) {
            if (!registration.attends(executionCourse)) continue;
            result.add(executionCourse);
        }
        if (result.isEmpty()) {
            result.addAll(this.getAssociatedExecutionCoursesSet());
        }
        return result;
    }

    public void delete() {
        this.getAssociatedExecutionCoursesSet().clear();
        while (!this.getMarksSet().isEmpty()) {
            ((Mark)((Object)this.getMarksSet().iterator().next())).delete();
        }
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public Mark addNewMark(Attends attends, String markValue) {
        if (attends.getMarkByEvaluation(this) != null) {
            throw new DomainException("error.Evaluation.attend.already.has.mark.for.evaluation", new String[0]);
        }
        return new Mark(attends, this, markValue);
    }

    public abstract EvaluationType getEvaluationType();

    public Mark getMarkByAttend(Attends attends) {
        for (Mark mark : this.getMarksSet()) {
            if (!mark.getAttend().equals((Object)attends)) continue;
            return mark;
        }
        return null;
    }

    public boolean isFinal() {
        return false;
    }

    public String getPresentationName() {
        return null;
    }

    protected void logCreate() {
        this.logAuxBasic("log.executionCourse.evaluation.generic.created");
    }

    protected void logEdit() {
        this.logAuxBasic("log.executionCourse.evaluation.generic.edited");
    }

    protected void logRemove() {
        this.logAuxBasic("log.executionCourse.evaluation.generic.removed");
    }

    private void logAuxBasic(String key) {
        for (ExecutionCourse ec : this.getAssociatedExecutionCoursesSet()) {
            EvaluationManagementLog.createLog(ec, "resources.MessagingResources", key, this.getPresentationName(), ec.getName(), ec.getDegreePresentationString());
        }
    }

    public abstract Date getEvaluationDate();

    public InfoEvaluation newInfoFromDomain() {
        InfoEvaluation infoEvaluation = new InfoEvaluation();
        infoEvaluation.copyFromDomain(this);
        return infoEvaluation;
    }
}

