/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Date;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.Curriculum_Base;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.commons.i18n.LocalizedString;
import org.joda.time.DateTime;

public class Curriculum
extends Curriculum_Base {
    public Curriculum() {
        this.setRootDomainObject(Bennu.getInstance());
        User userView = Authenticate.getUser();
        if (userView != null) {
            this.setPersonWhoAltered(userView.getPerson());
        }
    }

    public void edit(String generalObjectives, String operacionalObjectives, String program, String generalObjectivesEn, String operacionalObjectivesEn, String programEn) {
        this.setGeneralObjectives(generalObjectives);
        this.setOperacionalObjectives(operacionalObjectives);
        this.setProgram(program);
        this.setGeneralObjectivesEn(generalObjectivesEn);
        this.setOperacionalObjectivesEn(operacionalObjectivesEn);
        this.setProgramEn(programEn);
        User userView = Authenticate.getUser();
        this.setPersonWhoAltered(userView.getPerson());
        this.setLastModificationDateDateTime(new DateTime());
    }

    public void delete() {
        this.setCurricularCourse(null);
        this.setPersonWhoAltered(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public String getFullObjectives() {
        return Stream.of(this.getGeneralObjectives(), this.getOperacionalObjectives()).filter(Objects::nonNull).collect(Collectors.joining(" "));
    }

    public String getFullObjectivesEn() {
        return Stream.of(this.getGeneralObjectivesEn(), this.getOperacionalObjectivesEn()).filter(Objects::nonNull).collect(Collectors.joining(" "));
    }

    public MultiLanguageString getFullObjectivesI18N() {
        return MultiLanguageString.fromLocalizedString(new LocalizedString.Builder().with(MultiLanguageString.pt, this.getFullObjectives()).with(MultiLanguageString.en, this.getFullObjectivesEn()).build());
    }

    public MultiLanguageString getGeneralObjectivesI18N() {
        MultiLanguageString multiLanguageString = new MultiLanguageString();
        if (this.getGeneralObjectives() != null && this.getGeneralObjectives().length() > 0) {
            multiLanguageString = multiLanguageString.with(MultiLanguageString.pt, this.getGeneralObjectives());
        }
        if (this.getGeneralObjectivesEn() != null && this.getGeneralObjectivesEn().length() > 0) {
            multiLanguageString = multiLanguageString.with(MultiLanguageString.en, this.getGeneralObjectivesEn());
        }
        return multiLanguageString;
    }

    public MultiLanguageString getOperacionalObjectivesI18N() {
        MultiLanguageString multiLanguageString = new MultiLanguageString();
        if (this.getOperacionalObjectives() != null && this.getOperacionalObjectives().length() > 0) {
            multiLanguageString = multiLanguageString.with(MultiLanguageString.pt, this.getOperacionalObjectives());
        }
        if (this.getOperacionalObjectivesEn() != null && this.getOperacionalObjectivesEn().length() > 0) {
            multiLanguageString = multiLanguageString.with(MultiLanguageString.en, this.getOperacionalObjectivesEn());
        }
        return multiLanguageString;
    }

    public MultiLanguageString getProgramI18N() {
        MultiLanguageString multiLanguageString = new MultiLanguageString();
        if (this.getProgram() != null && this.getProgram().length() > 0) {
            multiLanguageString = multiLanguageString.with(MultiLanguageString.pt, this.getProgram());
        }
        if (this.getProgramEn() != null && this.getProgramEn().length() > 0) {
            multiLanguageString = multiLanguageString.with(MultiLanguageString.en, this.getProgramEn());
        }
        return multiLanguageString;
    }

    @Deprecated
    public Date getLastModificationDate() {
        DateTime dt = this.getLastModificationDateDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setLastModificationDate(Date date) {
        if (date == null) {
            this.setLastModificationDateDateTime(null);
        } else {
            this.setLastModificationDateDateTime(new DateTime(date.getTime()));
        }
    }
}

