/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util.report;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.fenixedu.academic.util.report.ReportPrinter;

public class ReportsUtils {
    private static ReportPrinter printer = reports -> {
        throw new UnsupportedOperationException("Cannot print reports: " + Arrays.toString(reports));
    };

    public static void setPrinter(ReportPrinter printer) {
        ReportsUtils.printer = Objects.requireNonNull(printer);
    }

    public static ReportPrinter.ReportResult generateReport(String key, Map<String, Object> parameters, Collection<?> dataSource) {
        try {
            return printer.printReport(key, parameters, dataSource);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while generating report '" + key + "'", e);
        }
    }

    public static ReportPrinter.ReportResult generateReport(ReportPrinter.ReportDescription ... reports) {
        try {
            return printer.printReports(reports);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while generating reports '" + Arrays.toString(reports) + "'", e);
        }
    }
}

