/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.manager.payments;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.PaymentCode;
import org.fenixedu.academic.domain.accounting.PaymentCodeMapping;
import org.fenixedu.academic.domain.accounting.PaymentCodeState;
import org.fenixedu.academic.domain.accounting.SibsPaymentFileProcessReport;
import org.fenixedu.academic.dto.accounting.sibsPaymentFileProcessReport.SibsPaymentFileProcessReportDTO;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.manager.ManagerApplications;
import org.fenixedu.academic.util.FileUtils;
import org.fenixedu.academic.util.sibs.incomming.SibsIncommingPaymentFile;
import org.fenixedu.academic.util.sibs.incomming.SibsIncommingPaymentFileDetailLine;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.StringNormalizer;
import org.joda.time.ReadableInstant;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=ManagerApplications.ManagerPaymentsApp.class, path="sibs-payments", titleKey="label.payments.uploadPaymentsFile")
@Mapping(path="/SIBSPayments", module="manager")
@Forwards(value={@Forward(name="prepareUploadSIBSPaymentFiles", path="/manager/payments/prepareUploadSIBSPaymentFiles.jsp")})
public class SIBSPaymentsDA
extends FenixDispatchAction {
    private static final String PAYMENT_FILE_EXTENSION = "INP";
    private static final String ZIP_FILE_EXTENSION = "ZIP";

    @EntryPoint
    public ActionForward prepareUploadSIBSPaymentFiles(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        UploadBean bean = (UploadBean)this.getRenderedObject("uploadBean");
        RenderUtils.invalidateViewState((String)"uploadBean");
        if (bean == null) {
            bean = new UploadBean();
        }
        request.setAttribute("uploadBean", (Object)bean);
        return mapping.findForward("prepareUploadSIBSPaymentFiles");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward uploadSIBSPaymentFiles(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        UploadBean bean = (UploadBean)this.getRenderedObject("uploadBean");
        RenderUtils.invalidateViewState((String)"uploadBean");
        if (bean == null) {
            return this.prepareUploadSIBSPaymentFiles(mapping, form, request, response);
        }
        if (StringUtils.endsWithIgnoreCase((String)bean.getFilename(), (String)ZIP_FILE_EXTENSION)) {
            File zipFile = FileUtils.copyToTemporaryFile(bean.getInputStream());
            File unzipDir = null;
            try {
                unzipDir = FileUtils.unzipFile(zipFile);
                if (!unzipDir.isDirectory()) {
                    this.addActionMessage("error", request, "error.manager.SIBS.zipException", bean.getFilename());
                    ActionForward actionForward = this.prepareUploadSIBSPaymentFiles(mapping, form, request, response);
                    return actionForward;
                }
            }
            catch (Exception e) {
                this.addActionMessage("error", request, "error.manager.SIBS.zipException", SIBSPaymentsDA.getMessage(e));
                ActionForward actionForward = this.prepareUploadSIBSPaymentFiles(mapping, form, request, response);
                return actionForward;
            }
            finally {
                zipFile.delete();
            }
            this.recursiveZipProcess(unzipDir, request);
        } else if (StringUtils.endsWithIgnoreCase((String)bean.getFilename(), (String)PAYMENT_FILE_EXTENSION)) {
            InputStream inputStream = bean.getInputStream();
            File dir = Files.createTempDir();
            File tmp = new File(dir, bean.getFilename());
            tmp.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(tmp);){
                ByteStreams.copy((InputStream)inputStream, (OutputStream)out);
            }
            finally {
                inputStream.close();
            }
            File file = tmp;
            ProcessResult result = new ProcessResult(request);
            result.addMessage("label.manager.SIBS.processingFile", file.getName());
            try {
                this.processFile(file, request);
            }
            catch (FileNotFoundException e) {
                this.addActionMessage("error", request, "error.manager.SIBS.zipException", SIBSPaymentsDA.getMessage(e));
            }
            catch (IOException e) {
                this.addActionMessage("error", request, "error.manager.SIBS.IOException", SIBSPaymentsDA.getMessage(e));
            }
            catch (Exception e) {
                this.addActionMessage("error", request, "error.manager.SIBS.fileException", SIBSPaymentsDA.getMessage(e));
            }
            finally {
                file.delete();
            }
        } else {
            this.addActionMessage("error", request, "error.manager.SIBS.notSupportedExtension", bean.getFilename());
        }
        return this.prepareUploadSIBSPaymentFiles(mapping, form, request, response);
    }

    private static String getMessage(Exception ex) {
        String message = ex.getMessage() == null ? ex.getClass().getSimpleName() : ex.getMessage();
        return BundleUtil.getString((String)"resources.ManagerResources", (String)message, (String[])new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recursiveZipProcess(File unzipDir, HttpServletRequest request) {
        Object[] filesInZip = unzipDir.listFiles();
        Arrays.sort(filesInZip);
        for (Object file : filesInZip) {
            if (((File)file).isDirectory()) {
                this.recursiveZipProcess((File)file, request);
                continue;
            }
            if (!StringUtils.endsWithIgnoreCase((String)((File)file).getName(), (String)PAYMENT_FILE_EXTENSION)) {
                ((File)file).delete();
                continue;
            }
            try {
                this.processFile((File)file, request);
            }
            catch (FileNotFoundException e) {
                this.addActionMessage("message", request, "error.manager.SIBS.zipException", SIBSPaymentsDA.getMessage(e));
            }
            catch (IOException e) {
                this.addActionMessage("message", request, "error.manager.SIBS.IOException", SIBSPaymentsDA.getMessage(e));
            }
            catch (Exception e) {
                this.addActionMessage("message", request, "error.manager.SIBS.fileException", SIBSPaymentsDA.getMessage(e));
            }
            finally {
                ((File)file).delete();
            }
        }
        unzipDir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(File file, HttpServletRequest request) throws IOException {
        ProcessResult result = new ProcessResult(request);
        result.addMessage("label.manager.SIBS.processingFile", file.getName());
        try (FileInputStream fileInputStream = null;){
            fileInputStream = new FileInputStream(file);
            Person person = AccessControl.getPerson();
            SibsIncommingPaymentFile sibsFile = SibsIncommingPaymentFile.parse(file.getName(), fileInputStream);
            result.addMessage("label.manager.SIBS.linesFound", String.valueOf(sibsFile.getDetailLines().size()));
            result.addMessage("label.manager.SIBS.startingProcess", new String[0]);
            for (SibsIncommingPaymentFileDetailLine detailLine : sibsFile.getDetailLines()) {
                try {
                    this.processCode(detailLine, person, result);
                }
                catch (Exception e) {
                    result.addError("error.manager.SIBS.processException", detailLine.getCode(), SIBSPaymentsDA.getMessage(e));
                }
            }
            result.addMessage("label.manager.SIBS.creatingReport", new String[0]);
            if (!result.hasFailed()) {
                if (SibsPaymentFileProcessReport.hasAny(sibsFile.getWhenProcessedBySibs(), sibsFile.getVersion())) {
                    result.addMessage("warning.manager.SIBS.reportAlreadyProcessed", new String[0]);
                } else {
                    try {
                        this.createSibsFileReport(sibsFile, result);
                    }
                    catch (Exception ex) {
                        result.addError("error.manager.SIBS.reportException", SIBSPaymentsDA.getMessage(ex));
                    }
                }
            } else {
                result.addError("error.manager.SIBS.nonProcessedCodes", new String[0]);
            }
            result.addMessage("label.manager.SIBS.done", new String[0]);
        }
    }

    private void processCode(SibsIncommingPaymentFileDetailLine detailLine, Person person, ProcessResult result) throws Exception {
        PaymentCode paymentCode = this.getPaymentCode(detailLine, result);
        if (paymentCode == null) {
            result.addMessage("error.manager.SIBS.codeNotFound", detailLine.getCode());
            throw new Exception();
        }
        PaymentCode codeToProcess = this.getPaymentCodeToProcess(paymentCode, ExecutionYear.readByDateTime(detailLine.getWhenOccuredTransaction()), result);
        if (codeToProcess.getState() == PaymentCodeState.INVALID) {
            result.addMessage("warning.manager.SIBS.invalidCode", codeToProcess.getCode());
        }
        if (codeToProcess.isProcessed() && codeToProcess.getWhenUpdated().isBefore((ReadableInstant)detailLine.getWhenOccuredTransaction())) {
            result.addMessage("warning.manager.SIBS.codeAlreadyProcessed", codeToProcess.getCode());
        }
        codeToProcess.process(person, detailLine.getAmount(), detailLine.getWhenOccuredTransaction(), detailLine.getSibsTransactionId(), "");
    }

    private void createSibsFileReport(SibsIncommingPaymentFile sibsIncomingPaymentFile, ProcessResult result) throws Exception {
        SibsPaymentFileProcessReportDTO reportDTO = new SibsPaymentFileProcessReportDTO(sibsIncomingPaymentFile);
        for (SibsIncommingPaymentFileDetailLine detailLine : sibsIncomingPaymentFile.getDetailLines()) {
            reportDTO.addAmount(detailLine, this.getPaymentCode(detailLine, result));
        }
        SibsPaymentFileProcessReport.create(reportDTO);
        result.addMessage("label.manager.SIBS.reportCreated", new String[0]);
    }

    private PaymentCode getPaymentCodeToProcess(PaymentCode paymentCode, ExecutionYear executionYear, ProcessResult result) {
        PaymentCode codeToProcess;
        PaymentCodeMapping mapping = paymentCode.getOldPaymentCodeMapping(executionYear);
        if (mapping != null) {
            result.addMessage("warning.manager.SIBS.foundMapping", paymentCode.getCode(), mapping.getNewPaymentCode().getCode());
            result.addMessage("warning.manager.SIBS.invalidating", paymentCode.getCode());
            codeToProcess = mapping.getNewPaymentCode();
            paymentCode.setState(PaymentCodeState.INVALID);
        } else {
            codeToProcess = paymentCode;
        }
        return codeToProcess;
    }

    private PaymentCode getPaymentCode(SibsIncommingPaymentFileDetailLine detailLine, ProcessResult result) {
        return this.getPaymentCode(detailLine.getCode(), result);
    }

    private PaymentCode getPaymentCode(String code, ProcessResult result) {
        return PaymentCode.readByCode(code);
    }

    private class ProcessResult {
        private final HttpServletRequest request;
        private boolean processFailed = false;

        public ProcessResult(HttpServletRequest request) {
            this.request = request;
        }

        public void addMessage(String message, String ... args) {
            SIBSPaymentsDA.this.addActionMessage("message", this.request, message, args);
        }

        public void addError(String message, String ... args) {
            SIBSPaymentsDA.this.addActionMessage("message", this.request, message, args);
            this.reportFailure();
        }

        protected void reportFailure() {
            this.processFailed = true;
        }

        public boolean hasFailed() {
            return this.processFailed;
        }
    }

    public static class UploadBean
    implements Serializable {
        private static final long serialVersionUID = 3625314688141697558L;
        private transient InputStream inputStream;
        private String filename;

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public void setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.filename = StringNormalizer.normalize((String)filename);
        }
    }
}

