/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.spring.controller.teacher;

import java.util.Optional;
import javax.ws.rs.core.Response;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.ui.spring.StrutsFunctionalityController;
import org.fenixedu.academic.ui.spring.controller.teacher.ProjectGroupBean;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;

public abstract class ExecutionCourseController
extends StrutsFunctionalityController {
    ExecutionCourse executionCourse;

    private Professorship findProfessorship(ExecutionCourse executionCourse) {
        Optional<Professorship> professorshipOpt;
        Person person = AccessControl.getPerson();
        if (person != null && (professorshipOpt = person.getProfessorshipsSet().stream().filter(professorship -> professorship.getExecutionCourse().equals((Object)executionCourse)).findFirst()).isPresent()) {
            Professorship prof = professorshipOpt.get();
            if (!this.getPermission(prof).booleanValue()) {
                throw new DomainException(Response.Status.FORBIDDEN, "message.error.notAuthorized", new String[0]);
            }
            return prof;
        }
        throw new DomainException(Response.Status.FORBIDDEN, "message.error.notAuthorized", new String[0]);
    }

    @ModelAttribute(value="projectGroup")
    public ProjectGroupBean setProjectGroup() {
        return new ProjectGroupBean();
    }

    @ModelAttribute(value="professorship")
    public Professorship setProfessorship(@PathVariable ExecutionCourse executionCourse) {
        return this.findProfessorship(executionCourse);
    }

    abstract Boolean getPermission(Professorship var1);

    @ModelAttribute(value="executionCourse")
    public ExecutionCourse getExecutionCourse(@PathVariable ExecutionCourse executionCourse) {
        this.executionCourse = executionCourse;
        return executionCourse;
    }
}

