/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.providers.student;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.curriculumLine.CurriculumLineLocationBean;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class CurriculumGroupsProviderForMoveCurriculumLines
implements DataProvider {
    public Object provide(Object source, Object currentValue) {
        CurriculumLineLocationBean bean = (CurriculumLineLocationBean)source;
        Set<CurriculumGroup> result = bean.isWithContextInPlan() ? CurriculumGroupsProviderForMoveCurriculumLines.provideWithContextInPlan(bean) : CurriculumGroupsProviderForMoveCurriculumLines.provideAllFromRegistrations(bean);
        return CurriculumGroupsProviderForMoveCurriculumLines.filterResults(result);
    }

    private static Set<CurriculumGroup> provideAllFromRegistrations(CurriculumLineLocationBean bean) {
        HashSet result = Sets.newHashSet();
        Student student = bean.getStudent();
        for (Registration registration : student.getRegistrationsSet()) {
            StudentCurricularPlan studentCurricularPlan = registration.getLastStudentCurricularPlan();
            if (studentCurricularPlan.getCycleCurriculumGroups().isEmpty()) {
                result.addAll(studentCurricularPlan.getAllCurriculumGroups());
                continue;
            }
            result.addAll(studentCurricularPlan.getNoCourseGroupCurriculumGroups());
            for (CycleCurriculumGroup cycle : studentCurricularPlan.getCycleCurriculumGroups()) {
                if (bean.isWithRules() && CurriculumGroupsProviderForMoveCurriculumLines.isConcluded(student, cycle)) continue;
                result.addAll(cycle.getAllCurriculumGroups());
            }
        }
        return result;
    }

    protected static Set<CurriculumGroup> filterResults(Set<CurriculumGroup> result) {
        Set programs = AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.STUDENT_ENROLMENTS, Authenticate.getUser()).collect(Collectors.toSet());
        return result.stream().filter(i -> programs.contains(i.getDegreeCurricularPlanOfStudent().getDegree())).collect(Collectors.toSet());
    }

    private static boolean isConcluded(Student student, CycleCurriculumGroup cycle) {
        return cycle.getConclusionProcess() != null || cycle.isExternal() && student.hasRegistrationFor(cycle.getDegreeCurricularPlanOfDegreeModule());
    }

    public Converter getConverter() {
        return new DomainObjectKeyConverter();
    }

    private static Set<CurriculumGroup> provideWithContextInPlan(CurriculumLineLocationBean bean) {
        HashSet result = Sets.newHashSet();
        StudentCurricularPlan studentCurricularPlan = bean.getCurriculumLine().getStudentCurricularPlan();
        for (CurriculumGroup curriculumGroup : studentCurricularPlan.getAllCurriculumGroups()) {
            if (curriculumGroup == bean.getCurriculumLine().getCurriculumGroup() || curriculumGroup.isInternalCreditsSourceGroup() || !curriculumGroup.canAdd(bean.getCurriculumLine())) continue;
            result.add(curriculumGroup);
        }
        return result;
    }
}

