/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.commons;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degree.degreeCurricularPlan.DegreeCurricularPlanState;
import org.fenixedu.academic.dto.InfoDegreeCurricularPlan;
import org.fenixedu.academic.predicate.AcademicPredicates;
import org.fenixedu.academic.predicate.AccessControlPredicate;
import org.fenixedu.academic.service.services.commons.ReadActiveDegreeCurricularPlansByDegreeType$callable$run;
import org.fenixedu.academic.service.services.commons.ReadActiveDegreeCurricularPlansByDegreeType$callable$runForAcademicAdmin;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ReadActiveDegreeCurricularPlansByDegreeType {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$runForAcademicAdmin = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static Collection<InfoDegreeCurricularPlan> run(Predicate<DegreeType> predicate) {
        return (Collection)advice$run.perform((Callable)new ReadActiveDegreeCurricularPlansByDegreeType$callable$run(predicate));
    }

    static /* synthetic */ Collection<InfoDegreeCurricularPlan> advised$run(Predicate<DegreeType> degreeType) {
        return ReadActiveDegreeCurricularPlansByDegreeType.getActiveDegreeCurricularPlansByDegreeType(degreeType, null);
    }

    public static Collection<InfoDegreeCurricularPlan> runForAcademicAdmin(Predicate<DegreeType> predicate) {
        return (Collection)advice$runForAcademicAdmin.perform((Callable)new ReadActiveDegreeCurricularPlansByDegreeType$callable$runForAcademicAdmin(predicate));
    }

    static /* synthetic */ Collection<InfoDegreeCurricularPlan> advised$runForAcademicAdmin(Predicate<DegreeType> degreeType) {
        return ReadActiveDegreeCurricularPlansByDegreeType.getActiveDegreeCurricularPlansByDegreeType(degreeType, AcademicPredicates.MANAGE_EXECUTION_COURSES);
    }

    private static Collection<InfoDegreeCurricularPlan> getActiveDegreeCurricularPlansByDegreeType(Predicate<DegreeType> degreeType, AccessControlPredicate<Object> permission) {
        ArrayList<DegreeCurricularPlan> degreeCurricularPlans = new ArrayList<DegreeCurricularPlan>();
        for (DegreeCurricularPlan dcp : DegreeCurricularPlan.readByDegreeTypeAndState(degreeType, DegreeCurricularPlanState.ACTIVE)) {
            if (permission != null && !permission.evaluate(dcp.getDegree())) continue;
            degreeCurricularPlans.add(dcp);
        }
        return CollectionUtils.collect(degreeCurricularPlans, (Transformer)new Transformer(){

            public Object transform(Object arg0) {
                DegreeCurricularPlan degreeCurricularPlan = (DegreeCurricularPlan)((Object)arg0);
                return InfoDegreeCurricularPlan.newInfoFromDomain(degreeCurricularPlan);
            }
        });
    }
}

