/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.coordinator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeLog;
import org.fenixedu.academic.util.predicates.AndPredicate;
import org.fenixedu.academic.util.predicates.InlinePredicate;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class SearchDegreeLogBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Degree degree;
    private Boolean viewPhoto;
    private Collection<DegreeLog.DegreeLogTypes> degreeLogsTypes;
    private Collection<DegreeLog> degreeLogs;

    public String getEnumerationResourcesString(String name) {
        return BundleUtil.getString((String)"resources.EnumerationResources", (String)name, (String[])new String[0]);
    }

    public String getApplicationResourcesString(String name) {
        return BundleUtil.getString((String)"resources.ApplicationResources", (String)name, (String[])new String[0]);
    }

    public SearchDegreeLogBean(Degree degree) {
        this.setDegree(degree);
        this.setViewPhoto(true);
        this.setDegreeLogTypes(DegreeLog.DegreeLogTypes.valuesAsList());
        this.degreeLogs = new ArrayList<DegreeLog>();
    }

    public Degree getDegree() {
        return this.degree;
    }

    public void setDegree(Degree degree) {
        this.degree = degree;
    }

    public Boolean getViewPhoto() {
        return this.viewPhoto;
    }

    public void setViewPhoto(Boolean viewPhoto) {
        this.viewPhoto = viewPhoto;
    }

    public Collection<DegreeLog.DegreeLogTypes> getDegreeLogTypes() {
        return this.degreeLogsTypes;
    }

    public Collection<DegreeLog.DegreeLogTypes> getDegreeLogTypesAll() {
        return DegreeLog.DegreeLogTypes.valuesAsList();
    }

    public void setDegreeLogTypes(Collection<DegreeLog.DegreeLogTypes> degreeLogsTypes) {
        this.degreeLogsTypes = degreeLogsTypes;
    }

    public Collection<DegreeLog> getDegreeLogs() {
        ArrayList<DegreeLog> dlogs = new ArrayList<DegreeLog>();
        for (DegreeLog degreeLog : this.degreeLogs) {
            dlogs.add(degreeLog);
        }
        return dlogs;
    }

    public void setDegreeLogs(Collection<DegreeLog> degreeLogs) {
        ArrayList<DegreeLog> dlogs = new ArrayList<DegreeLog>();
        for (DegreeLog dlog : degreeLogs) {
            dlogs.add(dlog);
        }
        this.degreeLogs = dlogs;
    }

    public Predicate<DegreeLog> getFilters() {
        ArrayList filters = new ArrayList();
        if (this.getDegreeLogTypes().size() < DegreeLog.DegreeLogTypes.values().length) {
            filters.add(new InlinePredicate<DegreeLog, Collection<DegreeLog.DegreeLogTypes>>(this.getDegreeLogTypes()){

                @Override
                public boolean test(DegreeLog degreeLog) {
                    return ((Collection)this.getValue()).contains((Object)degreeLog.getDegreeLogType());
                }
            });
        }
        return new AndPredicate<DegreeLog>(filters);
    }

    public String getLabel() {
        String logTypeValues = "";
        for (DegreeLog.DegreeLogTypes logType : DegreeLog.DegreeLogTypes.values()) {
            if (!logTypeValues.isEmpty()) {
                logTypeValues = logTypeValues + ", ";
            }
            logTypeValues = logTypeValues + this.getEnumerationResourcesString(logType.getQualifiedName());
        }
        return String.format("%s : %s", this.getApplicationResourcesString("log.label.selectLogType"), logTypeValues);
    }

    public String getSearchElementsAsParameters() {
        String parameters = "";
        parameters = parameters + "&amp;degree=" + this.getDegree().getExternalId();
        if (this.viewPhoto.booleanValue()) {
            parameters = parameters + "&amp;viewPhoto=true";
        }
        if (this.getDegreeLogTypes() != null && !this.getDegreeLogTypes().isEmpty()) {
            parameters = parameters + "&amp;degreeLogTypes=";
            for (DegreeLog.DegreeLogTypes logType : this.getDegreeLogTypes()) {
                parameters = parameters + logType.toString() + ":";
            }
        }
        return parameters;
    }
}

