/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.thesis;

import java.util.Comparator;
import java.util.Objects;
import org.apache.commons.beanutils.BeanComparator;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.domain.thesis.ThesisEvaluationExternalParticipant;
import org.fenixedu.academic.domain.thesis.ThesisEvaluationParticipant_Base;
import org.fenixedu.academic.domain.thesis.ThesisParticipationType;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.signals.DomainObjectEvent;
import org.fenixedu.bennu.signals.Signal;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class ThesisEvaluationParticipant
extends ThesisEvaluationParticipant_Base {
    private static KeepParticipationNumberAdapter KEEP_PARTICIPATION_NUMBER_ADAPTER = new KeepParticipationNumberAdapter();
    public static final Comparator<ThesisEvaluationParticipant> COMPARATOR_BY_PERSON_NAME;
    public static final Comparator<ThesisEvaluationParticipant> COMPARATOR_BY_STUDENT_NUMBER;

    public ThesisEvaluationParticipant(Thesis thesis, Person person, ThesisParticipationType type) {
        Objects.requireNonNull(person);
        this.setRootDomainObject(Bennu.getInstance());
        this.setType(type);
        this.setThesis(thesis);
        this.setPerson(person);
        this.setPercentageDistribution(0);
        Signal.emit((String)"academic.thesis.participant.created", (Object)new DomainObjectEvent((DomainObject)this));
    }

    public ThesisEvaluationParticipant(Thesis thesis, String name, String email, ThesisParticipationType type) {
        this.setRootDomainObject(Bennu.getInstance());
        this.setType(type);
        this.setThesis(thesis);
        this.setExternalPerson(new ThesisEvaluationExternalParticipant(name, email));
        this.setPercentageDistribution(0);
        Signal.emit((String)"academic.thesis.participant.created", (Object)new DomainObjectEvent((DomainObject)this));
    }

    public Person getPerson() {
        return super.getPerson();
    }

    public void delete() {
        this.setRootDomainObject(null);
        this.setPerson(null);
        this.setThesis(null);
        this.setExternalPerson(null);
        this.deleteDomainObject();
    }

    public void setType(ThesisParticipationType type) {
        super.setType(type);
        KEEP_PARTICIPATION_NUMBER_ADAPTER.changedType(this);
    }

    public boolean isExternal() {
        return this.getPerson() == null;
    }

    public String getName() {
        if (this.getPerson() != null) {
            return this.getPerson().getName();
        }
        return this.getExternalPerson() != null ? this.getExternalPerson().getName() : null;
    }

    public String getEmail() {
        if (this.getPerson() != null) {
            return this.getPerson().getProfile().getEmail();
        }
        return this.getExternalPerson() != null ? this.getExternalPerson().getEmail() : null;
    }

    static {
        ThesisEvaluationParticipant.getRelationThesisHasParticipations().addListener((RelationListener)KEEP_PARTICIPATION_NUMBER_ADAPTER);
        COMPARATOR_BY_PERSON_NAME = Comparator.comparing(ThesisEvaluationParticipant::getName).thenComparing(DomainObjectUtil.COMPARATOR_BY_ID);
        COMPARATOR_BY_STUDENT_NUMBER = new BeanComparator("thesis.student.number");
    }

    public static class KeepParticipationNumberAdapter
    extends RelationAdapter<Thesis, ThesisEvaluationParticipant> {
        public void beforeAdd(Thesis o2, ThesisEvaluationParticipant o1) {
            super.beforeAdd((DomainObject)o2, (DomainObject)o1);
            if (o1 != null && o2 != null) {
                this.keepTypeCount(o1, o2);
            }
        }

        public void changedType(ThesisEvaluationParticipant participant) {
            this.keepTypeCount(participant, participant.getThesis());
        }

        private void keepTypeCount(ThesisEvaluationParticipant participant, Thesis thesis) {
            ThesisEvaluationParticipant existing;
            if (thesis == null) {
                return;
            }
            ThesisParticipationType type = participant.getType();
            if (type == null) {
                return;
            }
            if (type.isSingle() && (existing = thesis.getParticipant(type)) != null && existing != participant) {
                existing.delete();
            }
        }
    }
}

