/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.conclusion;

import java.io.Serializable;
import java.math.BigDecimal;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisFinalGrade;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.joda.time.LocalDate;

public class PhdConclusionProcessBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private PhdIndividualProgramProcess phdIndividualProgramProcess;
    private LocalDate conclusionDate;
    private PhdThesisFinalGrade grade;
    private BigDecimal thesisEctsCredits;
    private BigDecimal studyPlanEctsCredits;
    private Integer numberOfCurricularYears;
    private Integer numberOfCurricularSemesters;

    public PhdConclusionProcessBean(PhdIndividualProgramProcess process2) {
        this.setPhdIndividualProgramProcess(process2);
        this.setConclusionDate(process2.getThesisProcess().getConclusionDate());
        this.setGrade(process2.getThesisProcess().getFinalGrade());
        if (!process2.getCandidacyProcess().isStudyPlanExempted()) {
            StudentCurricularPlan lastStudentCurricularPlan = process2.getRegistration().getLastStudentCurricularPlan();
            CycleCurriculumGroup cycleCurriculumGroup = lastStudentCurricularPlan.getRoot().getCycleCurriculumGroup(CycleType.THIRD_CYCLE);
            this.setStudyPlanEctsCredits(cycleCurriculumGroup.getConclusionProcess().getCredits());
        }
    }

    public PhdIndividualProgramProcess getPhdIndividualProgramProcess() {
        return this.phdIndividualProgramProcess;
    }

    public void setPhdIndividualProgramProcess(PhdIndividualProgramProcess phdIndividualProgramProcess) {
        this.phdIndividualProgramProcess = phdIndividualProgramProcess;
    }

    public LocalDate getConclusionDate() {
        return this.conclusionDate;
    }

    public void setConclusionDate(LocalDate conclusionDate) {
        this.conclusionDate = conclusionDate;
    }

    public PhdThesisFinalGrade getGrade() {
        return this.grade;
    }

    public void setGrade(PhdThesisFinalGrade grade) {
        this.grade = grade;
    }

    public BigDecimal getThesisEctsCredits() {
        return this.thesisEctsCredits;
    }

    public void setThesisEctsCredits(BigDecimal thesisEctsCredits) {
        this.thesisEctsCredits = thesisEctsCredits;
    }

    public BigDecimal getStudyPlanEctsCredits() {
        return this.studyPlanEctsCredits;
    }

    public void setStudyPlanEctsCredits(BigDecimal studyPlanEctsCredits) {
        this.studyPlanEctsCredits = studyPlanEctsCredits;
    }

    public Integer getNumberOfCurricularYears() {
        return this.numberOfCurricularYears;
    }

    public void setNumberOfCurricularYears(Integer numberOfCurricularYears) {
        this.numberOfCurricularYears = numberOfCurricularYears;
    }

    public Integer getNumberOfCurricularSemesters() {
        return this.numberOfCurricularSemesters;
    }

    public void setNumberOfCurricularSemesters(Integer numberOfCurricularSemesters) {
        this.numberOfCurricularSemesters = numberOfCurricularSemesters;
    }
}

