/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.degree;

import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.degree.DegreeType_Base;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.CycleTypes;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.commons.i18n.LocalizedString;

public class DegreeType
extends DegreeType_Base
implements Comparable<DegreeType> {
    private static final Predicate<DegreeType> nonNull = type -> type != null;

    public DegreeType(LocalizedString name) {
        this.setBennu(Bennu.getInstance());
        this.setName(name);
        this.setCycles(new CycleTypes());
        this.setCyclesToEnrol(new CycleTypes());
    }

    public final Collection<CycleType> getCycleTypes() {
        return this.getCycles().getTypes();
    }

    public final void setCycleTypes(Collection<CycleType> types) {
        this.setCycles(new CycleTypes(types));
    }

    public Collection<CycleType> getSupportedCyclesToEnrol() {
        return this.getCyclesToEnrol().getTypes();
    }

    public final void setCycleTypesToEnrol(Collection<CycleType> types) {
        this.setCyclesToEnrol(new CycleTypes(types));
    }

    public boolean isEmpty() {
        return this.getEmpty();
    }

    public boolean isSpecializationDegree() {
        return this.getCycleTypes().contains((Object)CycleType.SPECIALIZATION_CYCLE);
    }

    public boolean isAdvancedSpecializationDiploma() {
        return this.getDea();
    }

    public boolean isAdvancedFormationDiploma() {
        return this.getDfa();
    }

    public boolean isPreBolonhaDegree() {
        return !this.isBolonhaType() && this.isDegree();
    }

    public boolean isBolonhaDegree() {
        return this.isBolonhaType() && this.isDegree();
    }

    public boolean isPreBolonhaMasterDegree() {
        return !this.isBolonhaType() && this.isMasterDegree();
    }

    public boolean isBolonhaMasterDegree() {
        return this.isBolonhaType() && this.isMasterDegree();
    }

    public boolean isBolonhaType() {
        return this.getBolonha();
    }

    public boolean isDegree() {
        return this.getDegreeType();
    }

    public boolean isMasterDegree() {
        return this.getMasterDegree();
    }

    public boolean isIntegratedMasterDegree() {
        return this.getCycleTypes().contains((Object)CycleType.FIRST_CYCLE) && this.getCycleTypes().contains((Object)CycleType.SECOND_CYCLE);
    }

    public boolean isDegreeOrBolonhaDegreeOrBolonhaIntegratedMasterDegree() {
        return this.isDegree() || this.isIntegratedMasterDegree();
    }

    public final String getCreditsDescription() {
        return this.isPreBolonhaMasterDegree() ? " Cr\u00e9d." : " ECTS";
    }

    public String getPrefix() {
        return this.getPrefix(I18N.getLocale());
    }

    public String getPrefix(Locale locale) {
        StringBuilder result = new StringBuilder();
        if (this.isAdvancedSpecializationDiploma()) {
            return result.toString();
        }
        if (this.isAdvancedFormationDiploma()) {
            result.append(BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)locale, (String)"degree.DegreeType.prefix.one", (String[])new String[0])).append(" ");
            return result.toString();
        }
        String string = BundleUtil.getString((String)"resources.AcademicAdminOffice", (Locale)locale, (String)"degree.DegreeType.prefix.two", (String[])new String[0]);
        result.append(string).append(string.isEmpty() ? "" : " ");
        return result.toString();
    }

    public boolean isFirstCycle() {
        return this.getCycleTypes().contains((Object)CycleType.FIRST_CYCLE);
    }

    public boolean isSecondCycle() {
        return this.getCycleTypes().contains((Object)CycleType.SECOND_CYCLE);
    }

    public boolean isThirdCycle() {
        return this.getCycleTypes().contains((Object)CycleType.THIRD_CYCLE);
    }

    public boolean isSpecializationCycle() {
        return this.getCycleTypes().contains((Object)CycleType.SPECIALIZATION_CYCLE);
    }

    public final boolean hasAnyCycleTypes() {
        return !this.getCycleTypes().isEmpty();
    }

    public final boolean hasCycleTypes(CycleType cycleType) {
        return this.getCycleTypes().contains((Object)cycleType);
    }

    public final boolean isComposite() {
        return this.getCycleTypes().size() > 1;
    }

    public final boolean hasExactlyOneCycleType() {
        return this.getCycleTypes().size() == 1;
    }

    public final CycleType getCycleType() {
        if (this.hasExactlyOneCycleType()) {
            return this.getCycleTypes().iterator().next();
        }
        throw new DomainException("DegreeType.has.more.than.one.cycle.type", new String[0]);
    }

    public final boolean isStrictlyFirstCycle() {
        return this.hasExactlyOneCycleType() && this.getCycleTypes().contains((Object)CycleType.FIRST_CYCLE);
    }

    public CycleType getFirstOrderedCycleType() {
        TreeSet<CycleType> ordered = this.getOrderedCycleTypes();
        return ordered.isEmpty() ? null : ordered.first();
    }

    public CycleType getLastOrderedCycleType() {
        TreeSet<CycleType> ordered = this.getOrderedCycleTypes();
        return ordered.isEmpty() ? null : ordered.last();
    }

    public TreeSet<CycleType> getOrderedCycleTypes() {
        TreeSet<CycleType> result = new TreeSet<CycleType>(CycleType.COMPARATOR_BY_LESS_WEIGHT);
        result.addAll(this.getCycleTypes());
        return result;
    }

    public static Stream<DegreeType> all() {
        return Bennu.getInstance().getDegreeTypeSet().stream();
    }

    public static Optional<DegreeType> matching(Predicate<DegreeType> predicate) {
        return DegreeType.all().filter(predicate).findAny();
    }

    @Override
    public int compareTo(DegreeType o) {
        return this.getName().compareTo(o.getName());
    }

    @SafeVarargs
    public static Predicate<DegreeType> oneOf(Predicate<DegreeType> one, Predicate<DegreeType> ... others) {
        for (Predicate<DegreeType> pred : others) {
            one = one.or(pred);
        }
        return nonNull.and(one);
    }
}

