/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curriculum;

import org.fenixedu.academic.domain.curriculum.Grade;
import org.fenixedu.academic.domain.curriculum.IGrade;

public class GradeFactory {
    private static GradeFactory instance = new GradeFactory();
    private IGrade[] flyWeight = new IGrade[24];

    private GradeFactory() {
        this.flyWeight[21] = new Grade("RE");
        this.flyWeight[22] = new Grade("NA");
        this.flyWeight[23] = new Grade("AP");
        for (int i = 0; i < 21; ++i) {
            this.flyWeight[i] = new Grade(i);
        }
    }

    public IGrade getGrade(String key) {
        return this.flyWeight[this.getGradePosition(key)];
    }

    public IGrade getGrade(int key) {
        return this.flyWeight[key];
    }

    private int getGradePosition(String key) {
        if (key == null || key.equals("") || key.equals("NA")) {
            return 22;
        }
        if (key.equals("RE")) {
            return 21;
        }
        if (key.equals("AP")) {
            return 23;
        }
        return Integer.parseInt(key);
    }

    public static GradeFactory getInstance() {
        return instance;
    }
}

