/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.candidacy;

import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.Exemption;
import org.fenixedu.academic.domain.accounting.events.candidacy.SecondCycleIndividualCandidacyEvent_Base;
import org.fenixedu.academic.domain.accounting.events.candidacy.SecondCycleIndividualCandidacyExemption;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOfficeType;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacy;
import org.fenixedu.academic.domain.candidacyProcess.secondCycle.SecondCycleIndividualCandidacy;
import org.fenixedu.academic.util.LabelFormatter;

public class SecondCycleIndividualCandidacyEvent
extends SecondCycleIndividualCandidacyEvent_Base {
    private SecondCycleIndividualCandidacyEvent() {
    }

    public SecondCycleIndividualCandidacyEvent(SecondCycleIndividualCandidacy candidacy, Person person) {
        this();
        super.init((IndividualCandidacy)((Object)candidacy), EventType.SECOND_CYCLE_INDIVIDUAL_CANDIDACY, person);
        this.attachAvailablePaymentCode(person);
    }

    protected AdministrativeOffice readAdministrativeOffice() {
        return AdministrativeOffice.readByAdministrativeOfficeType(AdministrativeOfficeType.DEGREE);
    }

    public boolean isExemptionAppliable() {
        return true;
    }

    public boolean hasSecondCycleIndividualCandidacyExemption() {
        return this.getSecondCycleIndividualCandidacyExemption() != null;
    }

    public SecondCycleIndividualCandidacyExemption getSecondCycleIndividualCandidacyExemption() {
        for (Exemption exemption : this.getExemptionsSet()) {
            if (!(exemption instanceof SecondCycleIndividualCandidacyExemption)) continue;
            return (SecondCycleIndividualCandidacyExemption)((Object)exemption);
        }
        return null;
    }

    protected EntryType getEntryType() {
        return EntryType.SECOND_CYCLE_INDIVIDUAL_CANDIDACY_FEE;
    }

    public LabelFormatter getDescription() {
        LabelFormatter labelFormatter = super.getDescription();
        labelFormatter.appendLabel(" - ");
        for (Degree s : this.getIndividualCandidacy().getAllDegrees()) {
            labelFormatter.appendLabel(s.getSigla()).appendLabel(" ");
        }
        labelFormatter.appendLabel(" - ").appendLabel(this.getIndividualCandidacy().getCandidacyDate().toString());
        return labelFormatter;
    }
}

