/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import org.fenixedu.academic.domain.ExternalUser_Base;
import org.fenixedu.bennu.core.domain.Bennu;

public class ExternalUser
extends ExternalUser_Base {
    public ExternalUser() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public ExternalUser(String username, String password) {
        this();
        this.setUsername(username);
        String hash = this.hash(password);
        this.setPasswordHash(hash);
    }

    private String hash(String password) {
        return Hashing.sha1().hashString((CharSequence)password, Charsets.UTF_8).toString();
    }

    public boolean verify(String username, String password) {
        return username.equals(this.getUsername()) && this.hash(password).equals(this.getPasswordHash());
    }

    public static final boolean isExternalUser(String username) {
        for (ExternalUser externalUser : Bennu.getInstance().getExternalUserSet()) {
            if (!externalUser.getUsername().equals(username)) continue;
            return true;
        }
        return false;
    }
}

