/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.fenixedu.academic.util.FenixUtil;

public class MarkType
extends FenixUtil {
    public static final int TYPE20 = 20;
    public static final int TYPE5 = 5;
    public static final MarkType TYPE20_OBJ = new MarkType(20);
    public static final MarkType TYPE5_OBJ = new MarkType(5);
    public static final Object[] REP_MARKS = new Object[]{"RE"};
    public static final Object[] NA_MARKS = new Object[]{"NA"};
    public static final Object[] OTHER_MARKS = new Object[]{"RE", "NA", "AP"};
    public static final Object[] TYPE20_MARKS = new Object[]{"10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"};
    public static final Object[] TYPE20EVALUATION_MARKS = new Object[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
    public static final Object[] TYPE5_MARKS = new Object[]{"3", "4", "5"};
    public static final Object[] AP_MARKS = new Object[]{"AP"};
    private final Integer type;

    public MarkType(int type) {
        this.type = new Integer(type);
    }

    public MarkType(Integer state) {
        this.type = state;
    }

    public Integer getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o instanceof MarkType) {
            MarkType aux = (MarkType)o;
            return this.type.equals(aux.getType());
        }
        return false;
    }

    public static Collection getMarks(MarkType markType) {
        if (markType.equals(TYPE20_OBJ)) {
            return MarkType.getType20Marks();
        }
        if (markType.equals(TYPE5_OBJ)) {
            return MarkType.getType5Marks();
        }
        return null;
    }

    public static Collection getMarksEvaluation(MarkType markType) {
        if (markType.equals(TYPE20_OBJ)) {
            return MarkType.getType20EvaluationMarks();
        }
        if (markType.equals(TYPE5_OBJ)) {
            return MarkType.getType5Marks();
        }
        return null;
    }

    public static Collection getRepMarks() {
        ArrayList<Object> repMarks = new ArrayList<Object>();
        repMarks.addAll(Arrays.asList(REP_MARKS));
        return repMarks;
    }

    public static Collection getNaMarks() {
        ArrayList<Object> naMarks = new ArrayList<Object>();
        naMarks.addAll(Arrays.asList(NA_MARKS));
        return naMarks;
    }

    private static Collection getType20Marks() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(Arrays.asList(OTHER_MARKS));
        result.addAll(Arrays.asList(TYPE20_MARKS));
        return result;
    }

    private static Collection getType5Marks() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(Arrays.asList(OTHER_MARKS));
        result.addAll(Arrays.asList(TYPE5_MARKS));
        return result;
    }

    private static Collection getType20EvaluationMarks() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(Arrays.asList(REP_MARKS));
        result.addAll(Arrays.asList(NA_MARKS));
        result.addAll(Arrays.asList(TYPE20EVALUATION_MARKS));
        result.addAll(Arrays.asList(TYPE20_MARKS));
        return result;
    }
}

