/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.teacher;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Curriculum;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.LessonPlanning;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.dto.teacher.CreateLessonPlanningBean;
import org.fenixedu.academic.dto.teacher.ImportLessonPlanningsBean;
import org.fenixedu.academic.dto.teacher.executionCourse.ImportContentBean;
import org.fenixedu.academic.service.services.enrollment.shift.EnrollStudentInShifts;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.teacher.CreateLessonPlanning;
import org.fenixedu.academic.service.services.teacher.DeleteLessonPlanning;
import org.fenixedu.academic.service.services.teacher.ImportBibliographicReferences;
import org.fenixedu.academic.service.services.teacher.ImportEvaluationMethod;
import org.fenixedu.academic.service.services.teacher.ImportLessonPlannings;
import org.fenixedu.academic.service.services.teacher.MoveLessonPlanning;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.ui.struts.action.teacher.ManageExecutionCourseDA$callable$insertStudentInShift;
import org.fenixedu.academic.ui.struts.action.teacher.TeacherApplication;
import org.fenixedu.academic.ui.struts.action.teacher.executionCourse.ExecutionCourseBaseAction;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@StrutsFunctionality(app=TeacherApplication.TeacherTeachingApp.class, path="execution-course-management", titleKey="label.executionCourseManagement.menu.management")
@Mapping(path="/manageExecutionCourse", module="teacher")
@Forwards(value={@Forward(name="instructions", path="/teacher/executionCourse/instructions.jsp"), @Forward(name="importLessonPlannings", path="/teacher/executionCourse/importLessonPlannings.jsp"), @Forward(name="createLessonPlanning", path="/teacher/executionCourse/createLessonPlanning.jsp"), @Forward(name="importSections", path="/teacher/executionCourse/site/importSections.jsp"), @Forward(name="manageShifts", path="/teacher/executionCourse/manageShifts.jsp"), @Forward(name="editShift", path="/teacher/executionCourse/editShift.jsp"), @Forward(name="removeAttendsFromShift", path="/teacher/executionCourse/removeAttendsFromShift.jsp"), @Forward(name="lessonPlannings", path="/teacher/executionCourse/lessonPlannings.jsp")})
public class ManageExecutionCourseDA
extends ExecutionCourseBaseAction {
    public static final Advice advice$insertStudentInShift = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @EntryPoint
    public ActionForward instructions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("instructions");
    }

    protected void prepareImportContentPostBack(HttpServletRequest request) {
        IViewState viewState = RenderUtils.getViewState((String)"importContentBean");
        ImportContentBean bean = (ImportContentBean)viewState.getMetaObject().getObject();
        RenderUtils.invalidateViewState();
        request.setAttribute("importContentBean", (Object)bean);
    }

    protected void prepareImportContentInvalid(HttpServletRequest request) {
        IViewState viewState = RenderUtils.getViewState((String)"importContentBeanWithExecutionCourse");
        viewState = viewState == null ? RenderUtils.getViewState((String)"importContentBean") : viewState;
        ImportContentBean bean = (ImportContentBean)viewState.getMetaObject().getObject();
        request.setAttribute("importContentBean", (Object)bean);
    }

    protected void listExecutionCoursesToImportContent(HttpServletRequest request) {
        IViewState viewState = RenderUtils.getViewState((String)"importContentBean");
        ImportContentBean bean = (ImportContentBean)viewState.getMetaObject().getObject();
        request.setAttribute("importContentBean", (Object)bean);
    }

    protected void importContent(HttpServletRequest request, String importContentService) throws FenixServiceException {
        block4: {
            ExecutionCourse executionCourseTo = (ExecutionCourse)((Object)request.getAttribute("executionCourse"));
            IViewState viewState = RenderUtils.getViewState((String)"importContentBeanWithExecutionCourse");
            ImportContentBean bean = (ImportContentBean)viewState.getMetaObject().getObject();
            request.setAttribute("importContentBean", (Object)bean);
            ExecutionCourse executionCourseFrom = bean.getExecutionCourse();
            try {
                if (importContentService.equals("ImportBibliographicReferences")) {
                    ImportBibliographicReferences.runImportBibliographicReferences(executionCourseTo.getExternalId(), executionCourseTo, executionCourseFrom, null);
                    break block4;
                }
                if (importContentService.equals("ImportEvaluationMethod")) {
                    ImportEvaluationMethod.runImportEvaluationMethod(executionCourseTo.getExternalId(), executionCourseTo, executionCourseFrom, null);
                    break block4;
                }
                throw new UnsupportedOperationException("Sorry, cannot import using " + importContentService);
            }
            catch (DomainException e) {
                this.addActionMessage(request, e.getKey(), e.getArgs());
            }
        }
    }

    public void prepareCurricularCourse(HttpServletRequest request) {
        ExecutionCourse executionCourse = (ExecutionCourse)((Object)request.getAttribute("executionCourse"));
        String curricularCourseIDString = request.getParameter("curricularCourseID");
        if (executionCourse != null && curricularCourseIDString != null && curricularCourseIDString.length() > 0) {
            CurricularCourse curricularCourse = this.findCurricularCourse(executionCourse, curricularCourseIDString);
            request.setAttribute("curricularCourse", (Object)curricularCourse);
        }
    }

    private CurricularCourse findCurricularCourse(ExecutionCourse executionCourse, String curricularCourseID) {
        for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
            if (!curricularCourse.getExternalId().equals(curricularCourseID)) continue;
            return curricularCourse;
        }
        return null;
    }

    public ActionForward submitDataToImportLessonPlannings(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        IViewState viewState = RenderUtils.getViewState();
        ImportLessonPlanningsBean bean = (ImportLessonPlanningsBean)viewState.getMetaObject().getObject();
        request.setAttribute("importLessonPlanningBean", (Object)bean);
        return mapping.findForward("importLessonPlannings");
    }

    public ActionForward submitDataToImportLessonPlanningsPostBack(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        IViewState viewState = RenderUtils.getViewState();
        ImportLessonPlanningsBean bean = (ImportLessonPlanningsBean)viewState.getMetaObject().getObject();
        if (bean.getCurricularYear() == null || bean.getExecutionPeriod() == null || bean.getExecutionDegree() == null) {
            bean.setExecutionCourse(null);
            bean.setImportType(null);
            bean.setShift(null);
        }
        RenderUtils.invalidateViewState();
        request.setAttribute("importLessonPlanningBean", (Object)bean);
        return mapping.findForward("importLessonPlannings");
    }

    public ActionForward prepareImportLessonPlannings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExecutionCourse executionCourseTo = (ExecutionCourse)((Object)request.getAttribute("executionCourse"));
        request.setAttribute("importLessonPlanningBean", (Object)new ImportLessonPlanningsBean(executionCourseTo));
        return mapping.findForward("importLessonPlannings");
    }

    public ActionForward importLessonPlannings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        IViewState viewState = RenderUtils.getViewState();
        ImportLessonPlanningsBean bean = (ImportLessonPlanningsBean)viewState.getMetaObject().getObject();
        request.setAttribute("importLessonPlanningBean", (Object)bean);
        ExecutionCourse executionCourseFrom = bean.getExecutionCourse();
        ExecutionCourse executionCourseTo = bean.getExecutionCourseTo();
        ImportLessonPlanningsBean.ImportType importType = bean.getImportType();
        if (importType != null && importType.equals((Object)ImportLessonPlanningsBean.ImportType.PLANNING)) {
            try {
                ImportLessonPlannings.runImportLessonPlannings(executionCourseTo.getExternalId(), executionCourseTo, executionCourseFrom, null);
            }
            catch (DomainException e) {
                this.addActionMessage(request, e.getKey(), e.getArgs());
            }
        } else if (importType != null && importType.equals((Object)ImportLessonPlanningsBean.ImportType.SUMMARIES)) {
            return mapping.findForward("importLessonPlannings");
        }
        return this.lessonPlannings(mapping, form, request, response);
    }

    public ActionForward importLessonPlanningsBySummaries(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        IViewState viewState = RenderUtils.getViewState();
        ImportLessonPlanningsBean bean = (ImportLessonPlanningsBean)viewState.getMetaObject().getObject();
        ExecutionCourse executionCourseTo = bean.getExecutionCourseTo();
        Shift shiftFrom = bean.getShift();
        try {
            ImportLessonPlannings.runImportLessonPlannings(executionCourseTo.getExternalId(), executionCourseTo, shiftFrom.getExecutionCourse(), shiftFrom);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
        }
        request.setAttribute("importLessonPlanningBean", (Object)bean);
        return this.lessonPlannings(mapping, form, request, response);
    }

    public ActionForward lessonPlannings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExecutionCourse executionCourse = (ExecutionCourse)((Object)request.getAttribute("executionCourse"));
        TreeMap<ShiftType, List<LessonPlanning>> lessonPlanningsMap = new TreeMap<ShiftType, List<LessonPlanning>>();
        for (ShiftType shiftType : executionCourse.getShiftTypes()) {
            List<LessonPlanning> lessonPlanningsOrderedByOrder = executionCourse.getLessonPlanningsOrderedByOrder(shiftType);
            if (lessonPlanningsOrderedByOrder.isEmpty()) continue;
            lessonPlanningsMap.put(shiftType, lessonPlanningsOrderedByOrder);
        }
        request.setAttribute("lessonPlanningsMap", lessonPlanningsMap);
        return mapping.findForward("lessonPlannings");
    }

    public ActionForward moveUpLessonPlanning(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        LessonPlanning lessonPlanning = (LessonPlanning)FenixFramework.getDomainObject((String)request.getParameter("lessonPlanningID"));
        try {
            MoveLessonPlanning.runMoveLessonPlanning(lessonPlanning.getExecutionCourse().getExternalId(), lessonPlanning, lessonPlanning.getOrderOfPlanning() - 1);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
        }
        return this.lessonPlannings(mapping, form, request, response);
    }

    public ActionForward moveDownLessonPlanning(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        LessonPlanning lessonPlanning = (LessonPlanning)FenixFramework.getDomainObject((String)request.getParameter("lessonPlanningID"));
        try {
            MoveLessonPlanning.runMoveLessonPlanning(lessonPlanning.getExecutionCourse().getExternalId(), lessonPlanning, lessonPlanning.getOrderOfPlanning() + 1);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
        }
        return this.lessonPlannings(mapping, form, request, response);
    }

    public ActionForward prepareCreateLessonPlanning(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExecutionCourse executionCourse = (ExecutionCourse)((Object)request.getAttribute("executionCourse"));
        request.setAttribute("lessonPlanningBean", (Object)new CreateLessonPlanningBean(executionCourse));
        return mapping.findForward("createLessonPlanning");
    }

    public ActionForward prepareEditLessonPlanning(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        LessonPlanning lessonPlanning = (LessonPlanning)FenixFramework.getDomainObject((String)request.getParameter("lessonPlanningID"));
        request.setAttribute("lessonPlanning", (Object)lessonPlanning);
        return mapping.findForward("createLessonPlanning");
    }

    public ActionForward createLessonPlanning(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        IViewState viewState = RenderUtils.getViewState();
        CreateLessonPlanningBean lessonPlanningBean = (CreateLessonPlanningBean)viewState.getMetaObject().getObject();
        try {
            CreateLessonPlanning.runCreateLessonPlanning(lessonPlanningBean.getExecutionCourse().getExternalId(), lessonPlanningBean.getTitle(), lessonPlanningBean.getPlanning(), lessonPlanningBean.getLessonType(), lessonPlanningBean.getExecutionCourse());
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("lessonPlanningBean", (Object)lessonPlanningBean);
            return mapping.findForward("createLessonPlanning");
        }
        return this.lessonPlannings(mapping, form, request, response);
    }

    public ActionForward deleteLessonPlanning(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        LessonPlanning lessonPlanning = (LessonPlanning)FenixFramework.getDomainObject((String)request.getParameter("lessonPlanningID"));
        if (lessonPlanning != null) {
            try {
                DeleteLessonPlanning.runDeleteLessonPlanning(lessonPlanning.getExecutionCourse().getExternalId(), lessonPlanning, null, null);
            }
            catch (DomainException e) {
                this.addActionMessage(request, e.getKey(), e.getArgs());
            }
        }
        return this.lessonPlannings(mapping, form, request, response);
    }

    public ActionForward deleteLessonPlannings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        ShiftType lessonType = ShiftType.valueOf(request.getParameter("shiftType"));
        ExecutionCourse executionCourse = (ExecutionCourse)((Object)request.getAttribute("executionCourse"));
        if (lessonType != null && executionCourse != null) {
            try {
                DeleteLessonPlanning.runDeleteLessonPlanning(executionCourse.getExternalId(), null, executionCourse, lessonType);
            }
            catch (DomainException e) {
                this.addActionMessage(request, e.getKey(), e.getArgs());
            }
        }
        return this.lessonPlannings(mapping, form, request, response);
    }

    protected Curriculum findCurriculum(ExecutionCourse executionCourse, String curriculumID) {
        for (CurricularCourse curricularCourse : executionCourse.getAssociatedCurricularCoursesSet()) {
            for (Curriculum curriculum : curricularCourse.getAssociatedCurriculumsSet()) {
                if (!curriculum.getExternalId().equals(curriculumID)) continue;
                return curriculum;
            }
        }
        return null;
    }

    public ActionForward prepareImportSectionsPostBack(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.prepareImportContentPostBack(request);
        return mapping.findForward("importSections");
    }

    public ActionForward prepareImportSectionsInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.prepareImportContentInvalid(request);
        return mapping.findForward("importSections");
    }

    public ActionForward listExecutionCoursesToImportSections(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.listExecutionCoursesToImportContent(request);
        return mapping.findForward("importSections");
    }

    public ActionForward importSections(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        this.importContent(request, "ImportSections");
        return new ActionForward("/manageExecutionCourseSite.do?method=sections");
    }

    public ActionForward prepareImportSections(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("importContentBean", (Object)new ImportContentBean());
        return mapping.findForward("importSections");
    }

    @Override
    public ExecutionCourse getExecutionCourse(HttpServletRequest request) {
        return (ExecutionCourse)((Object)request.getAttribute("executionCourse"));
    }

    public ActionForward manageShifts(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        String executionCourseID = request.getParameter("executionCourseID");
        ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseID);
        SortedSet<Shift> shifts = executionCourse.getShiftsOrderedByLessons();
        request.setAttribute("shifts", shifts);
        request.setAttribute("executionCourseID", (Object)executionCourseID);
        return mapping.findForward("manageShifts");
    }

    public ActionForward editShift(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        String shiftID = request.getParameter("shiftID");
        String executionCourseID = request.getParameter("executionCourseID");
        String registrationID = request.getParameter("registrationID");
        if (request.getParameter("showPhotos") == null) {
            request.setAttribute("showPhotos", (Object)"false");
        }
        Shift shift = (Shift)FenixFramework.getDomainObject((String)shiftID);
        ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseID);
        if (registrationID != null) {
            Registration registration = (Registration)FenixFramework.getDomainObject((String)registrationID);
            shift.removeAttendFromShift(registration, executionCourse);
            request.setAttribute("registration", (Object)registration);
        }
        ArrayList registrations = new ArrayList();
        registrations.addAll(shift.getStudentsSet());
        Collections.sort(registrations, Registration.NUMBER_COMPARATOR);
        request.setAttribute("registrations", registrations);
        request.setAttribute("shift", (Object)shift);
        request.setAttribute("executionCourseID", (Object)executionCourseID);
        request.setAttribute("personBean", (Object)new PersonBean());
        return mapping.findForward("editShift");
    }

    public ActionForward insertStudentInShift(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws FenixActionException {
        return (ActionForward)advice$insertStudentInShift.perform((Callable)new ManageExecutionCourseDA$callable$insertStudentInShift(this, actionMapping, actionForm, httpServletRequest, httpServletResponse));
    }

    static /* synthetic */ ActionForward advised$insertStudentInShift(ManageExecutionCourseDA this_, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException {
        PersonBean bean = (PersonBean)this_.getRenderedObject("personBean");
        String id = bean.getUsername();
        Person person = null;
        User user = User.findByUsername((String)id);
        if (user != null) {
            person = user.getPerson();
        } else {
            try {
                Student student = Student.readStudentByNumber(Integer.valueOf(id));
                if (student != null) {
                    person = student.getPerson();
                }
            }
            catch (NumberFormatException student) {
                // empty catch block
            }
        }
        ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)request.getParameter("executionCourseID"));
        if (person != null) {
            try {
                new EnrollStudentInShifts().run(executionCourse.getRegistration(person), request.getParameter("shiftID"));
            }
            catch (FenixServiceException e) {
                ActionErrors actionErrors = new ActionErrors();
                if (e.getMessage() != null) {
                    actionErrors.add("error", new ActionMessage(e.getMessage()));
                } else {
                    actionErrors.add("error", new ActionMessage("label.invalid.student.number"));
                }
                this_.saveErrors(request, actionErrors);
            }
        } else {
            ActionErrors actionErrors = new ActionErrors();
            actionErrors.add("error", new ActionMessage("label.invalid.student.number"));
            this_.saveErrors(request, actionErrors);
        }
        return this_.editShift(mapping, form, request, response);
    }

    public ActionForward removeAttendsFromShift(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        String shiftID = request.getParameter("shiftID");
        String registrationID = request.getParameter("registrationID");
        String executionCourseID = request.getParameter("executionCourseID");
        String removeAll = request.getParameter("removeAll");
        Shift shift = (Shift)FenixFramework.getDomainObject((String)shiftID);
        if (removeAll != null) {
            request.setAttribute("removeAll", (Object)removeAll);
        } else {
            Registration registration = (Registration)FenixFramework.getDomainObject((String)registrationID);
            request.setAttribute("registration", (Object)registration);
        }
        request.setAttribute("shift", (Object)shift);
        request.setAttribute("executionCourseID", (Object)executionCourseID);
        return mapping.findForward("removeAttendsFromShift");
    }

    public ActionForward removeAllAttendsFromShift(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        String executionCourseID = request.getParameter("executionCourseID");
        String shiftID = request.getParameter("shiftID");
        Shift shift = (Shift)FenixFramework.getDomainObject((String)shiftID);
        ExecutionCourse executionCourse = (ExecutionCourse)FenixFramework.getDomainObject((String)executionCourseID);
        for (Registration registration : shift.getStudentsSet()) {
            shift.removeAttendFromShift(registration, executionCourse);
        }
        request.setAttribute("shift", (Object)shift);
        request.setAttribute("executionCourseID", (Object)executionCourseID);
        request.setAttribute("registrations", (Object)shift.getStudentsSet());
        request.setAttribute("personBean", (Object)new PersonBean());
        return mapping.findForward("editShift");
    }
}

