/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.scientificCouncil.curricularPlans;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.DegreeOfficialPublication;
import org.fenixedu.academic.domain.DegreeSpecializationArea;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.exceptions.InvalidArgumentsServiceException;
import org.fenixedu.academic.service.services.scientificCouncil.curricularPlans.ChangeDegreeOfficialPublicationReference;
import org.fenixedu.academic.service.services.scientificCouncil.curricularPlans.CreateDegreeSpecializationArea;
import org.fenixedu.academic.service.services.scientificCouncil.curricularPlans.DeleteDegreeSpecializationArea;
import org.fenixedu.academic.ui.struts.action.scientificCouncil.curricularPlans.OfficialPublicationBean$callable$update;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class OfficialPublicationBean
implements Serializable {
    private static final Logger logger;
    private static final long serialVersionUID = 1L;
    private String newReference;
    private String newNamePt;
    private String newNameEn;
    private final DegreeOfficialPublication degreeOfficialPublication;
    private final List<SpecializationName> specializationNames = new ArrayList<SpecializationName>();
    private LocalDate publication;
    public static final Advice advice$update;

    public OfficialPublicationBean(DegreeOfficialPublication degreeOfficialPublication) {
        this.degreeOfficialPublication = degreeOfficialPublication;
        this.newReference = degreeOfficialPublication.getOfficialReference();
        this.newNamePt = "";
        this.newNameEn = "";
        this.initSpecializationNames();
        this.publication = degreeOfficialPublication.getPublication();
    }

    private void initSpecializationNames() {
        for (DegreeSpecializationArea area : this.degreeOfficialPublication.getSpecializationAreaSet()) {
            SpecializationName name = new SpecializationName(area);
            this.specializationNames.add(name);
        }
    }

    public String getNewReference() {
        return this.newReference;
    }

    public void setNewReference(String newReference) {
        this.newReference = newReference;
    }

    public List<SpecializationName> getSpecializationNames() {
        return this.specializationNames;
    }

    public DegreeOfficialPublication getDegreeOfficialPublication() {
        return this.degreeOfficialPublication;
    }

    public String getNewNamePt() {
        return this.newNamePt;
    }

    public void setNewNamePt(String newNamePt) {
        this.newNamePt = newNamePt;
    }

    public String getNewNameEn() {
        return this.newNameEn;
    }

    public void setNewNameEn(String newNameEn) {
        this.newNameEn = newNameEn;
    }

    public LocalDate getPublication() {
        return this.publication;
    }

    public void setPublication(LocalDate publication) {
        this.publication = publication;
    }

    public void removeSpecializationArea(DegreeSpecializationArea area) {
        try {
            DeleteDegreeSpecializationArea.run(area.getOfficialPublication(), area);
        }
        catch (FenixServiceException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void addSpecializationArea(DegreeOfficialPublication degreeOfficialPublication, String namePt, String nameEn) throws InvalidArgumentsServiceException {
        try {
            CreateDegreeSpecializationArea.run(degreeOfficialPublication, nameEn, namePt);
        }
        catch (FenixServiceException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void update(List<SpecializationName> list) {
        Object object = advice$update.perform((Callable)new OfficialPublicationBean$callable$update(this, list));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$update(OfficialPublicationBean this_, List names) {
        DegreeOfficialPublication degreeOfficialPublication = this_.getDegreeOfficialPublication();
        if (this_.getNewReference().compareTo(degreeOfficialPublication.getOfficialReference()) != 0) {
            degreeOfficialPublication.setOfficialReference(this_.getNewReference());
        }
        for (SpecializationName name : names) {
            String ptNameInEspArea;
            String enNameInEspArea = name.getSpecializationArea().getNameEn() == null ? "" : name.getSpecializationArea().getNameEn();
            String string = ptNameInEspArea = name.getSpecializationArea().getNamePt() == null ? "" : name.getSpecializationArea().getNamePt();
            if (name.getEnName().compareTo(enNameInEspArea) != 0) {
                name.getSpecializationArea().setNameEn(name.getEnName());
            }
            if (name.getPtName().compareTo(ptNameInEspArea) == 0) continue;
            name.getSpecializationArea().setNamePt(name.getPtName());
        }
    }

    public void updateReference() {
        if (this.getNewReference() == null) {
            throw new RuntimeException("this should NOTTTTT HAPPEN!!!!");
        }
        this.getDegreeOfficialPublication().setOfficialReference(this.newReference);
        try {
            ChangeDegreeOfficialPublicationReference.run(this.getDegreeOfficialPublication(), this.getNewReference());
        }
        catch (FenixServiceException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    static {
        advice$update = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        logger = LoggerFactory.getLogger(OfficialPublicationBean.class);
    }

    public class SpecializationName
    implements Serializable {
        private static final long serialVersionUID = 2L;
        private String enName;
        private String ptName;
        private final DegreeSpecializationArea specializationArea;

        public SpecializationName(DegreeSpecializationArea specializationArea) {
            this.specializationArea = specializationArea;
            this.enName = specializationArea.getNameEn() == null ? "" : specializationArea.getNameEn();
            this.ptName = specializationArea.getNamePt() == null ? "" : specializationArea.getNamePt();
        }

        public String getEnName() {
            return this.enName;
        }

        public void setEnName(String enName) {
            this.enName = enName;
        }

        public String getPtName() {
            return this.ptName;
        }

        public void setPtName(String ptName) {
            this.ptName = ptName;
        }

        public DegreeSpecializationArea getSpecializationArea() {
            return this.specializationArea;
        }

        public void update() {
            this.specializationArea.setNameEn(this.enName);
            this.specializationArea.setNamePt(this.ptName);
        }
    }

    public class ReferenceName
    implements Serializable {
        private static final long serialVersionUID = 3L;
        private String newReference;
        private final DegreeOfficialPublication degreeOfficialPublication;

        public ReferenceName(DegreeOfficialPublication degreeOfficialPublication) {
            this.degreeOfficialPublication = degreeOfficialPublication;
            this.newReference = this.degreeOfficialPublication.getOfficialReference();
        }

        public String getNewReference() {
            return this.newReference;
        }

        public void setNewReference(String newReference) {
            this.newReference = newReference;
        }

        public DegreeOfficialPublication getDegreeOfficialPublication() {
            return this.degreeOfficialPublication;
        }

        public void update() throws FenixServiceException {
            ChangeDegreeOfficialPublicationReference.run(this.degreeOfficialPublication, this.newReference);
        }
    }
}

