/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd.externalAccess;

import java.io.IOException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.PhdProgramDocumentUploadBean;
import org.fenixedu.academic.domain.phd.PhdProgramProcessDocument;
import org.fenixedu.academic.domain.phd.access.PhdExternalOperationBean;
import org.fenixedu.academic.domain.phd.access.PhdProcessAccessType;
import org.fenixedu.academic.domain.phd.candidacy.feedbackRequest.PhdCandidacyFeedbackRequestElement;
import org.fenixedu.academic.domain.phd.candidacy.feedbackRequest.PhdCandidacyFeedbackRequestProcess;
import org.fenixedu.academic.domain.phd.thesis.ThesisJuryElement;
import org.fenixedu.academic.domain.phd.thesis.activities.JuryDocumentsDownload;
import org.fenixedu.academic.domain.phd.thesis.activities.JuryReporterFeedbackExternalUpload;
import org.fenixedu.academic.domain.phd.thesis.activities.JuryReviewDocumentsDownload;
import org.fenixedu.academic.service.services.caseHandling.ExecuteProcessActivity;
import org.fenixedu.academic.ui.struts.action.phd.PhdDocumentsZip;
import org.fenixedu.academic.ui.struts.action.phd.PhdProcessDA;
import org.fenixedu.academic.ui.struts.action.publico.PublicApplication;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=PublicApplication.PublicPhdApp.class, path="external-access", titleKey="label.php.program")
@Mapping(path="/phdExternalAccess", module="publico")
@Forwards(value={@Forward(name="showOperations", path="/phd/externalAccess/showOperations.jsp"), @Forward(name="juryDocumentsDownload", path="/phd/externalAccess/downloadDocuments.jsp"), @Forward(name="juryReporterFeedbackUpload", path="/phd/externalAccess/thesis/juryReporterFeedbackUpload.jsp"), @Forward(name="candidacyFeedbackDocumentsDownload", path="/phd/externalAccess/downloadDocuments.jsp"), @Forward(name="candidacyFeedbackUpload", path="/phd/externalAccess/candidacy/candidacyFeedbackUpload.jsp"), @Forward(name="juryReviewDocumentsDownload", path="/phd/externalAccess/thesis/juryReviewDocumentsDownload.jsp")})
public class PhdExternalAccessDA
extends PhdProcessDA {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("dont-cache-pages-in-search-engines", (Object)Boolean.TRUE);
        request.setAttribute("participant", (Object)this.getPhdParticipant(request));
        return super.execute(mapping, actionForm, request, response);
    }

    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("showOperations");
    }

    private PhdParticipant getPhdParticipant(HttpServletRequest request) {
        PhdExternalOperationBean bean = this.getOperationBean();
        return bean != null ? bean.getParticipant() : PhdParticipant.readByAccessHashCode(this.getHash(request));
    }

    private PhdExternalOperationBean getOperationBean() {
        return (PhdExternalOperationBean)this.getRenderedObject("operationBean");
    }

    private String getHash(HttpServletRequest request) {
        return (String)this.getFromRequest(request, "hash");
    }

    public ActionForward prepareJuryDocumentsDownload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("operationBean", (Object)new PhdExternalOperationBean(this.getPhdParticipant(request), PhdProcessAccessType.JURY_DOCUMENTS_DOWNLOAD));
        return mapping.findForward("juryDocumentsDownload");
    }

    public ActionForward prepareJuryDocumentsDownloadInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("operationBean", (Object)this.getOperationBean());
        return mapping.findForward("juryDocumentsDownload");
    }

    protected PhdIndividualProgramProcess getProcess(HttpServletRequest request) {
        return this.getPhdParticipant(request).getIndividualProcess();
    }

    public ActionForward juryDocumentsDownload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            PhdIndividualProgramProcess process2 = this.getProcess(request);
            ExecuteProcessActivity.run((Process)((Object)process2.getThesisProcess()), JuryDocumentsDownload.class, (Object)this.getOperationBean());
            this.writeFile(response, this.getZipDocumentsFilename(process2), PhdDocumentsZip.ZIP_MIME_TYPE, this.createZip(process2.getThesisProcess().getThesisDocumentsToFeedback()));
            return null;
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.prepareJuryDocumentsDownloadInvalid(mapping, form, request, response);
        }
    }

    public ActionForward prepareJuryReporterFeedbackUpload(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdExternalOperationBean bean = new PhdExternalOperationBean(this.getPhdParticipant(request), PhdProcessAccessType.JURY_REPORTER_FEEDBACK_UPLOAD);
        bean.setDocumentBean(new PhdProgramDocumentUploadBean(PhdIndividualProgramDocumentType.JURY_REPORT_FEEDBACK));
        request.setAttribute("operationBean", (Object)bean);
        request.setAttribute("lastReportFeedbackDocument", (Object)this.getThesisJuryElement(request, bean).getLastFeedbackDocument());
        request.setAttribute("waitingForJuryReporterFeedback", (Object)this.getProcess(request).getThesisProcess().isWaitingForJuryReporterFeedback());
        return mapping.findForward("juryReporterFeedbackUpload");
    }

    public ActionForward prepareJuryReporterFeedbackUploadInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdExternalOperationBean bean = this.getOperationBean();
        request.setAttribute("operationBean", (Object)bean);
        request.setAttribute("lastReportFeedbackDocument", (Object)this.getThesisJuryElement(request, bean).getLastFeedbackDocument());
        request.setAttribute("waitingForJuryReporterFeedback", (Object)this.getProcess(request).getThesisProcess().isWaitingForJuryReporterFeedback());
        return mapping.findForward("juryReporterFeedbackUpload");
    }

    private ThesisJuryElement getThesisJuryElement(HttpServletRequest request, PhdExternalOperationBean bean) {
        return bean.getParticipant().getThesisJuryElement(this.getProcess(request).getThesisProcess());
    }

    public ActionForward juryReporterFeedbackUpload(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            if (!RenderUtils.getViewState((String)"operationBean").isValid()) {
                return this.prepareJuryReporterFeedbackUploadInvalid(mapping, actionForm, request, response);
            }
            ExecuteProcessActivity.run((Process)((Object)this.getProcess(request).getThesisProcess()), JuryReporterFeedbackExternalUpload.class, (Object)this.getOperationBean());
            this.addSuccessMessage(request, "message.jury.report.feedback.upload.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.prepareJuryReporterFeedbackUploadInvalid(mapping, actionForm, request, response);
        }
        return this.prepare(mapping, actionForm, request, response);
    }

    public ActionForward prepareCandidacyFeedbackDocumentsDownload(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("operationBean", (Object)new PhdExternalOperationBean(this.getPhdParticipant(request), PhdProcessAccessType.CANDIDACY_FEEDBACK_DOCUMENTS_DOWNLOAD));
        return mapping.findForward("candidacyFeedbackDocumentsDownload");
    }

    public ActionForward prepareCandidacyFeedbackDocumentsDownloadInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("operationBean", (Object)this.getOperationBean());
        return mapping.findForward("candidacyFeedbackDocumentsDownload");
    }

    public ActionForward candidacyFeedbackDocumentsDownload(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            PhdCandidacyFeedbackRequestProcess process2 = this.getFeedBackRequest(request);
            ExecuteProcessActivity.run((Process)((Object)process2), PhdCandidacyFeedbackRequestProcess.DownloadCandidacyFeedbackDocuments.class, (Object)this.getOperationBean());
            Set<PhdProgramProcessDocument> documents = process2.getSharedDocumentsContent();
            if (!documents.isEmpty()) {
                this.writeFile(response, this.getZipDocumentsFilename(process2.getCandidacyProcess().getIndividualProgramProcess()), PhdDocumentsZip.ZIP_MIME_TYPE, this.createZip(documents));
                return null;
            }
            this.addErrorMessage(request, "error.phd.candidacy.feedback.request.no.documents.to.download", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
        }
        return this.prepareJuryDocumentsDownloadInvalid(mapping, actionForm, request, response);
    }

    private PhdCandidacyFeedbackRequestProcess getFeedBackRequest(HttpServletRequest request) {
        return this.getProcess(request).getCandidacyProcess().getFeedbackRequest();
    }

    public ActionForward prepareCandidacyFeedbackUpload(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdExternalOperationBean bean = new PhdExternalOperationBean(this.getPhdParticipant(request), PhdProcessAccessType.CANDIDACY_FEEDBACK_UPLOAD);
        bean.setDocumentBean(new PhdProgramDocumentUploadBean(PhdIndividualProgramDocumentType.CANDIDACY_FEEDBACK_DOCUMENT));
        request.setAttribute("operationBean", (Object)bean);
        request.setAttribute("canUploadDocuments", (Object)this.getFeedBackRequest(request).canUploadDocuments());
        request.setAttribute("lastFeedbackDocument", (Object)this.getCandidacyFeedbackRequestElement(request, bean).getLastFeedbackDocument());
        return mapping.findForward("candidacyFeedbackUpload");
    }

    private PhdCandidacyFeedbackRequestElement getCandidacyFeedbackRequestElement(HttpServletRequest request, PhdExternalOperationBean bean) {
        return bean.getParticipant().getPhdCandidacyFeedbackRequestElement(this.getFeedBackRequest(request));
    }

    public ActionForward prepareCandidacyFeedbackUploadInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdExternalOperationBean bean = this.getOperationBean();
        request.setAttribute("operationBean", (Object)bean);
        request.setAttribute("canUploadDocuments", (Object)this.getFeedBackRequest(request).canUploadDocuments());
        request.setAttribute("lastFeedbackDocument", (Object)this.getCandidacyFeedbackRequestElement(request, bean).getLastFeedbackDocument());
        return mapping.findForward("candidacyFeedbackUpload");
    }

    public ActionForward candidacyFeedbackUpload(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            if (!RenderUtils.getViewState((String)"operationBean").isValid()) {
                return this.prepareCandidacyFeedbackUploadInvalid(mapping, actionForm, request, response);
            }
            ExecuteProcessActivity.run((Process)((Object)this.getFeedBackRequest(request)), PhdCandidacyFeedbackRequestProcess.ExternalUploadCandidacyFeedback.class, (Object)this.getOperationBean());
            this.addSuccessMessage(request, "message.phd.candidacy.feedback.document.uploaded.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.prepareCandidacyFeedbackUploadInvalid(mapping, actionForm, request, response);
        }
        return this.prepare(mapping, actionForm, request, response);
    }

    public ActionForward prepareJuryReviewDocumentsDownload(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("operationBean", (Object)new PhdExternalOperationBean(this.getPhdParticipant(request), PhdProcessAccessType.JURY_REVIEW_DOCUMENTS_DOWNLOAD));
        return mapping.findForward("juryReviewDocumentsDownload");
    }

    public ActionForward prepareJuryReviewDocumentsDownloadInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("operationBean", (Object)this.getOperationBean());
        return mapping.findForward("juryReviewDocumentsDownload");
    }

    public ActionForward juryReviewDocumentsDownload(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            PhdIndividualProgramProcess process2 = this.getProcess(request);
            ExecuteProcessActivity.run((Process)((Object)process2.getThesisProcess()), JuryReviewDocumentsDownload.class, (Object)this.getOperationBean());
            this.writeFile(response, this.getZipDocumentsFilename(process2), PhdDocumentsZip.ZIP_MIME_TYPE, this.createZip(process2.getThesisProcess().getReportThesisJuryElementDocuments()));
            return null;
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.prepareJuryReviewDocumentsDownloadInvalid(mapping, actionForm, request, response);
        }
    }
}

