/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd.candidacy.publicProgram.epfl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.PublicCandidacyHashCode;
import org.fenixedu.academic.domain.Qualification;
import org.fenixedu.academic.domain.QualificationBean;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramCollaborationType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramDocumentType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessBean;
import org.fenixedu.academic.domain.phd.PhdParticipant;
import org.fenixedu.academic.domain.phd.PhdParticipantBean;
import org.fenixedu.academic.domain.phd.PhdProgramCandidacyProcessState;
import org.fenixedu.academic.domain.phd.PhdProgramDocumentUploadBean;
import org.fenixedu.academic.domain.phd.PhdProgramProcessDocument;
import org.fenixedu.academic.domain.phd.candidacy.EPFLPhdCandidacyPeriod;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyPeriod;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyReferee;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeBean;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetter;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyRefereeLetterBean;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcess;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramCandidacyProcessBean;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramPublicCandidacyHashCode;
import org.fenixedu.academic.domain.phd.candidacy.PhdThesisSubjectOrderBean;
import org.fenixedu.academic.domain.phd.candidacy.activities.RemoveCandidacyDocument;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddCandidacyReferees;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddGuidingsInformation;
import org.fenixedu.academic.domain.phd.individualProcess.activities.AddQualification;
import org.fenixedu.academic.domain.phd.individualProcess.activities.DeleteGuiding;
import org.fenixedu.academic.domain.phd.individualProcess.activities.DeleteQualification;
import org.fenixedu.academic.domain.phd.individualProcess.activities.EditIndividualProcessInformation;
import org.fenixedu.academic.domain.phd.individualProcess.activities.EditPersonalInformation;
import org.fenixedu.academic.domain.phd.individualProcess.activities.UploadDocuments;
import org.fenixedu.academic.domain.phd.individualProcess.activities.ValidatedByCandidate;
import org.fenixedu.academic.dto.contacts.PendingPartyContactBean;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.dto.person.PhotographUploadBean;
import org.fenixedu.academic.service.services.caseHandling.CreateNewProcess;
import org.fenixedu.academic.service.services.caseHandling.ExecuteProcessActivity;
import org.fenixedu.academic.service.services.fileManager.UploadOwnPhoto;
import org.fenixedu.academic.ui.struts.action.commons.FenixActionForward;
import org.fenixedu.academic.ui.struts.action.phd.candidacy.publicProgram.PublicPhdProgramCandidacyProcessDA;
import org.fenixedu.academic.ui.struts.action.publico.PublicApplication;
import org.fenixedu.academic.util.ContentType;
import org.fenixedu.academic.util.phd.EPFLPhdCandidacyProcessProperties;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.i18n.I18N;
import org.joda.time.DateTime;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=PublicApplication.PublicPhdApp.class, path="epfl-candidacy", titleKey="label.phd.ist.epfl.collaboration.type")
@Mapping(path="/applications/epfl/phdProgramCandidacyProcess", module="publico")
@Forwards(value={@Forward(name="createCandidacyIdentification", path="/phd/candidacy/publicProgram/epfl/createCandidacyIdentification.jsp"), @Forward(name="createCandidacyIdentificationSuccess", path="/phd/candidacy/publicProgram/epfl/createCandidacyIdentificationSuccess.jsp"), @Forward(name="candidacyIdentificationRecovery", path="/phd/candidacy/publicProgram/epfl/candidacyIdentificationRecovery.jsp"), @Forward(name="createCandidacyStepOne", path="/phd/candidacy/publicProgram/epfl/createCandidacyStepOne.jsp"), @Forward(name="createCandidacyStepTwo", path="/phd/candidacy/publicProgram/epfl/createCandidacyStepTwo.jsp"), @Forward(name="createCandidacyStepThree", path="/phd/candidacy/publicProgram/epfl/createCandidacyStepThree.jsp"), @Forward(name="showCandidacySuccess", path="/phd/candidacy/publicProgram/epfl/candidacySubmited.jsp"), @Forward(name="viewCandidacy", path="/phd/candidacy/publicProgram/epfl/viewCandidacy.jsp"), @Forward(name="editPersonalInformation", path="/phd/candidacy/publicProgram/epfl/editPersonalInformation.jsp"), @Forward(name="uploadCandidacyDocuments", path="/phd/candidacy/publicProgram/epfl/uploadCandidacyDocuments.jsp"), @Forward(name="editPhdIndividualProgramProcessInformation", path="/phd/candidacy/publicProgram/epfl/editPhdIndividualProgramProcessInformation.jsp"), @Forward(name="editCandidacyGuidings", path="/phd/candidacy/publicProgram/epfl/editCandidacyGuidings.jsp"), @Forward(name="editQualifications", path="/phd/candidacy/publicProgram/epfl/editQualifications.jsp"), @Forward(name="createRefereeLetter", path="/phd/candidacy/publicProgram/epfl/createRefereeLetter.jsp"), @Forward(name="createRefereeLetterSuccess", path="/phd/candidacy/publicProgram/epfl/createRefereeLetterSuccess.jsp"), @Forward(name="editCandidacyReferees", path="/phd/candidacy/publicProgram/epfl/editCandidacyReferees.jsp"), @Forward(name="uploadPhoto", path="/phd/candidacy/publicProgram/epfl/uploadPhoto.jsp"), @Forward(name="out.of.candidacy.period", path="/phd/candidacy/publicProgram/epfl/outOfCandidacyPeriod.jsp"), @Forward(name="validateCandidacy", path="/phd/candidacy/publicProgram/epfl/validateCandidacy.jsp"), @Forward(name="emailSentForIdentificationRecovery", path="/phd/candidacy/publicProgram/epfl/emailSentForIdentificationRecovery.jsp")})
public class PublicEPFLPhdProgramsCandidacyProcessDA
extends PublicPhdProgramCandidacyProcessDA {
    private static final List<String> DO_NOT_VALIDATE_CANDIDACY_PERIOD_IN_METHODS = Arrays.asList("showCandidacySuccess", "viewCandidacy", "backToViewCandidacy", "prepareCreateRefereeLetter", "createRefereeLetterInvalid", "createRefereeLetter");
    private static final int MINIMUM_HABILITATIONS_AND_CERTIFICATES = 2;
    private static final int MINIMUM_CANDIDACY_REFEREES = 3;

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setLocale(request, Locale.ENGLISH);
        I18N.setLocale((HttpSession)request.getSession(), (Locale)Locale.ENGLISH);
        return super.execute(mapping, actionForm, request, response);
    }

    @Override
    protected ActionForward filterDispatchMethod(PhdProgramCandidacyProcessBean bean, ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PhdProgramPublicCandidacyHashCode hashCode = bean != null ? bean.getCandidacyHashCode() : null;
        String methodName = this.getMethodName(mapping, actionForm, request, response, mapping.getParameter());
        if ((methodName == null || !DO_NOT_VALIDATE_CANDIDACY_PERIOD_IN_METHODS.contains(methodName)) && this.isOutOfCandidacyPeriod(hashCode)) {
            request.setAttribute("candidacyPeriod", (Object)this.getPhdCandidacyPeriod(hashCode));
            return mapping.findForward("out.of.candidacy.period");
        }
        return null;
    }

    private boolean isOutOfCandidacyPeriod(PhdProgramPublicCandidacyHashCode hashCode) {
        PhdCandidacyPeriod period = this.getPhdCandidacyPeriod(hashCode);
        return period == null || !period.contains(new DateTime());
    }

    private PhdCandidacyPeriod getPhdCandidacyPeriod(PhdProgramPublicCandidacyHashCode hashCode) {
        if (hashCode == null) {
            return EPFLPhdCandidacyPeriod.readEPFLPhdCandidacyPeriodForDateTime(new DateTime());
        }
        if (!hashCode.hasCandidacyProcess()) {
            return EPFLPhdCandidacyPeriod.readEPFLPhdCandidacyPeriodForDateTime(new DateTime());
        }
        if (!hashCode.getPhdProgramCandidacyProcess().isPublicCandidacy()) {
            return EPFLPhdCandidacyPeriod.readEPFLPhdCandidacyPeriodForDateTime(new DateTime());
        }
        if (!hashCode.getPhdProgramCandidacyProcess().getPublicPhdCandidacyPeriod().isEpflCandidacyPeriod()) {
            return EPFLPhdCandidacyPeriod.readEPFLPhdCandidacyPeriodForDateTime(new DateTime());
        }
        return hashCode.getPhdProgramCandidacyProcess().getPublicPhdCandidacyPeriod();
    }

    @EntryPoint
    public ActionForward prepareCreateCandidacyIdentification(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        String hash = request.getParameter("hash");
        PhdProgramPublicCandidacyHashCode hashCode = (PhdProgramPublicCandidacyHashCode)((Object)PublicCandidacyHashCode.getPublicCandidacyCodeByHash(hash));
        if (hashCode != null) {
            return this.viewCandidacy(mapping, request, hashCode);
        }
        request.setAttribute("candidacyBean", (Object)new PhdProgramCandidacyProcessBean());
        return mapping.findForward("createCandidacyIdentification");
    }

    public ActionForward createCandidacyIdentificationInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyBean", this.getRenderedObject("candidacyBean"));
        return mapping.findForward("createCandidacyIdentification");
    }

    public ActionForward createCandidacyIdentification(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        PhdProgramPublicCandidacyHashCode hashCode = PhdProgramPublicCandidacyHashCode.getOrCreatePhdProgramCandidacyHashCode(bean.getEmail());
        if (hashCode.hasCandidacyProcess()) {
            this.addErrorMessage(request, "error.PhdProgramPublicCandidacyHashCode.already.has.candidacy", new String[0]);
            return this.prepareCreateCandidacyIdentification(mapping, actionForm, request, response);
        }
        this.sendSubmissionEmailForCandidacy((PublicCandidacyHashCode)((Object)hashCode), request);
        String url = String.format("%s?hash=%s", EPFLPhdCandidacyProcessProperties.getConfiguration().getPublicCandidacySubmissionLink(), hashCode.getValue());
        request.setAttribute("processLink", (Object)url);
        return mapping.findForward("createCandidacyIdentificationSuccess");
    }

    private void sendSubmissionEmailForCandidacy(PublicCandidacyHashCode hashCode, HttpServletRequest request) {
        String subject = BundleUtil.getString((String)"resources.PhdResources", (String)"message.phd.epfl.application.email.subject.send.link.to.submission", (String[])new String[0]);
        String body = BundleUtil.getString((String)"resources.PhdResources", (String)"message.phd.epfl.email.body.send.link.to.submission", (String[])new String[0]);
        hashCode.sendEmail(subject, String.format(body, EPFLPhdCandidacyProcessProperties.getConfiguration().getPublicCandidacySubmissionLink(), hashCode.getValue()));
    }

    public ActionForward prepareCandidacyIdentificationRecovery(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyBean", (Object)new PhdProgramCandidacyProcessBean());
        return mapping.findForward("candidacyIdentificationRecovery");
    }

    public ActionForward candidacyIdentificationRecoveryInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyBean", this.getRenderedObject("candidacyBean"));
        return mapping.findForward("candidacyIdentificationRecovery");
    }

    public ActionForward candidacyIdentificationRecovery(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        PhdProgramPublicCandidacyHashCode hashCode = PhdProgramPublicCandidacyHashCode.getPhdProgramCandidacyHashCode(bean.getEmail());
        if (hashCode != null) {
            if (hashCode.hasCandidacyProcess()) {
                this.sendRecoveryEmailForCandidate(hashCode, request);
            } else {
                this.sendSubmissionEmailForCandidacy((PublicCandidacyHashCode)((Object)hashCode), request);
            }
        }
        return mapping.findForward("emailSentForIdentificationRecovery");
    }

    private void sendRecoveryEmailForCandidate(PhdProgramPublicCandidacyHashCode candidacyHashCode, HttpServletRequest request) {
        String subject = BundleUtil.getString((String)"resources.PhdResources", (String)"message.phd.email.subject.recovery.access", (String[])new String[]{Unit.getInstitutionAcronym()});
        String body = BundleUtil.getString((String)"resources.ApplicationResources", (String)"message.phd.epfl.email.body.recovery.access", (String[])new String[0]);
        candidacyHashCode.sendEmail(subject, String.format(body, EPFLPhdCandidacyProcessProperties.getConfiguration().getPublicCandidacyAccessLink(), candidacyHashCode.getValue()));
    }

    public ActionForward prepareCreateCandidacy(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return this.createCandidacyStepOne(mapping, actionForm, request, response);
    }

    public ActionForward createCandidacyStepOne(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramPublicCandidacyHashCode hashCode = (PhdProgramPublicCandidacyHashCode)((Object)PublicCandidacyHashCode.getPublicCandidacyCodeByHash(request.getParameter("hash")));
        if (hashCode == null) {
            return mapping.findForward("createCandidacyStepOne");
        }
        if (hashCode.hasCandidacyProcess()) {
            return this.viewCandidacy(mapping, request, hashCode);
        }
        PhdProgramCandidacyProcessBean bean = new PhdProgramCandidacyProcessBean();
        bean.setPersonBean(new PersonBean());
        bean.getPersonBean().setEmail(hashCode.getEmail());
        bean.setCandidacyHashCode(hashCode);
        bean.setExecutionYear(ExecutionYear.readCurrentExecutionYear());
        bean.setCollaborationType(PhdIndividualProgramCollaborationType.EPFL);
        bean.setState(PhdProgramCandidacyProcessState.PRE_CANDIDATE);
        bean.setMigratedProcess(Boolean.FALSE);
        bean.setPhdCandidacyPeriod(this.getPhdCandidacyPeriod(hashCode));
        request.setAttribute("candidacyBean", (Object)bean);
        return mapping.findForward("createCandidacyStepOne");
    }

    public ActionForward createCandidacyStepOneInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyBean", this.getRenderedObject("candidacyBean"));
        return mapping.findForward("createCandidacyStepOne");
    }

    public ActionForward returnCreateCandidacyStepOne(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyBean", (Object)this.getCandidacyBean());
        RenderUtils.invalidateViewState();
        return mapping.findForward("createCandidacyStepOne");
    }

    @Override
    public ActionForward fillPersonalDataInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.createCandidacyStepOneInvalid(mapping, form, request, response);
    }

    public ActionForward createCandidacyStepTwo(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        ActionForward checkPersonalDataForward = this.checkPersonalData(mapping, actionForm, request, response);
        if (checkPersonalDataForward != null) {
            return checkPersonalDataForward;
        }
        PersonBean personBean = this.getCandidacyBean().getPersonBean();
        String familyName = personBean.getFamilyNames();
        String composedName = familyName == null || familyName.isEmpty() ? personBean.getGivenNames() : personBean.getGivenNames() + " " + familyName;
        personBean.setName(composedName);
        request.setAttribute("candidacyBean", (Object)this.getCandidacyBean());
        RenderUtils.invalidateViewState();
        return this.prepareCreateCandidacyStepTwo(mapping, actionForm, request, response);
    }

    public ActionForward prepareCreateCandidacyStepTwo(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("createCandidacyStepTwo");
    }

    public ActionForward moveUpThesisSubjectForEditPhdInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        int order = this.getIntegerFromRequest(request, "order");
        PhdIndividualProgramProcessBean phdBean = (PhdIndividualProgramProcessBean)this.getRenderedObject("individualProcessBean");
        PhdThesisSubjectOrderBean beanToMoveUp = phdBean.getThesisSubjectBean(order);
        PhdThesisSubjectOrderBean beanToMoveDown = phdBean.getThesisSubjectBean(order - 1);
        if (beanToMoveDown != null) {
            beanToMoveUp.decreaseOrder();
            beanToMoveDown.increaseOrder();
            phdBean.sortThesisSubjectBeans();
        }
        request.setAttribute("candidacyBean", (Object)this.getCandidacyBean());
        request.setAttribute("individualProcessBean", (Object)phdBean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("editPhdIndividualProgramProcessInformation");
    }

    public ActionForward moveDownThesisSubjectForEditPhdInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        int order = this.getIntegerFromRequest(request, "order");
        PhdIndividualProgramProcessBean phdBean = (PhdIndividualProgramProcessBean)this.getRenderedObject("individualProcessBean");
        PhdThesisSubjectOrderBean beanToMoveDown = phdBean.getThesisSubjectBean(order);
        PhdThesisSubjectOrderBean beanToMoveUp = phdBean.getThesisSubjectBean(order + 1);
        if (beanToMoveUp != null) {
            beanToMoveDown.increaseOrder();
            beanToMoveUp.decreaseOrder();
            phdBean.sortThesisSubjectBeans();
        }
        request.setAttribute("candidacyBean", (Object)this.getCandidacyBean());
        request.setAttribute("individualProcessBean", (Object)phdBean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("editPhdIndividualProgramProcessInformation");
    }

    public ActionForward moveUpThesisSubjectForCandidacyStepTwo(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        int order = this.getIntegerFromRequest(request, "order");
        PhdProgramCandidacyProcessBean candidacyBean = this.getCandidacyBean();
        PhdThesisSubjectOrderBean beanToMoveUp = candidacyBean.getThesisSubjectBean(order);
        PhdThesisSubjectOrderBean beanToMoveDown = candidacyBean.getThesisSubjectBean(order - 1);
        if (beanToMoveDown != null) {
            beanToMoveUp.decreaseOrder();
            beanToMoveDown.increaseOrder();
            candidacyBean.sortThesisSubjectBeans();
        }
        request.setAttribute("candidacyBean", (Object)candidacyBean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("createCandidacyStepTwo");
    }

    public ActionForward moveDownThesisSubjectForCandidacyStepTwo(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        int order = this.getIntegerFromRequest(request, "order");
        PhdProgramCandidacyProcessBean candidacyBean = this.getCandidacyBean();
        PhdThesisSubjectOrderBean beanToMoveDown = candidacyBean.getThesisSubjectBean(order);
        PhdThesisSubjectOrderBean beanToMoveUp = candidacyBean.getThesisSubjectBean(order + 1);
        if (beanToMoveUp != null) {
            beanToMoveDown.increaseOrder();
            beanToMoveUp.decreaseOrder();
            candidacyBean.sortThesisSubjectBeans();
        }
        request.setAttribute("candidacyBean", (Object)candidacyBean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("createCandidacyStepTwo");
    }

    public ActionForward prepareCreateCandidacyStepTwoFocusAreaPostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean candidacyBean = this.getCandidacyBean();
        candidacyBean.updateThesisSubjectBeans();
        request.setAttribute("candidacyBean", (Object)candidacyBean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("createCandidacyStepTwo");
    }

    public ActionForward createCandidacyStepThree(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return this.createCandidacy(mapping, actionForm, request, response);
    }

    private List<PhdParticipantBean> createGuidingsMinimumList(PhdIndividualProgramProcess process2) {
        ArrayList<PhdParticipantBean> result = new ArrayList<PhdParticipantBean>();
        PhdParticipantBean g1 = new PhdParticipantBean(process2);
        g1.setParticipantType(PhdParticipantBean.PhdParticipantType.EXTERNAL);
        g1.setWorkLocation(Unit.getInstitutionAcronym());
        PhdParticipantBean g2 = new PhdParticipantBean(process2);
        g2.setParticipantType(PhdParticipantBean.PhdParticipantType.EXTERNAL);
        g2.setWorkLocation("EPFL");
        result.add(g1);
        result.add(g2);
        return result;
    }

    public ActionForward createCandidacyStepTwoInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyBean", this.getRenderedObject("candidacyBean"));
        RenderUtils.invalidateViewState();
        this.addErrorMessage(request, "error.required.fields", new String[0]);
        return mapping.findForward("createCandidacyStepTwo");
    }

    public ActionForward returnCreateCandidacyStepTwo(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        request.setAttribute("candidacyBean", (Object)bean);
        this.clearDocumentsInformation(bean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("createCandidacyStepTwo");
    }

    public ActionForward addGuiding(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        PhdParticipantBean guiding = new PhdParticipantBean(bean.getIndividualProgramProcess());
        guiding.setParticipantType(PhdParticipantBean.PhdParticipantType.EXTERNAL);
        bean.addGuiding(guiding);
        request.setAttribute("candidacyBean", (Object)bean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("createCandidacyStepTwo");
    }

    public ActionForward removeGuiding(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        bean.removeGuiding(this.getIntegerFromRequest(request, "removeIndex"));
        request.setAttribute("candidacyBean", (Object)bean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("createCandidacyStepTwo");
    }

    public ActionForward addQualification(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        bean.addQualification(new QualificationBean());
        request.setAttribute("candidacyBean", (Object)bean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("createCandidacyStepTwo");
    }

    public ActionForward removeQualification(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        bean.removeQualification(this.getIntegerFromRequest(request, "removeIndex"));
        request.setAttribute("candidacyBean", (Object)bean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("createCandidacyStepTwo");
    }

    public ActionForward addCandidacyReferee(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        bean.addCandidacyReferee(new PhdCandidacyRefereeBean());
        request.setAttribute("candidacyBean", (Object)bean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("createCandidacyStepTwo");
    }

    public ActionForward removeCandidacyReferee(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        if (bean.getCandidacyReferees().size() > 3) {
            bean.removeCandidacyReferee(this.getIntegerFromRequest(request, "removeIndex"));
        }
        request.setAttribute("candidacyBean", (Object)bean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("createCandidacyStepTwo");
    }

    private PhdProgramDocumentUploadBean createDocumentBean(PhdIndividualProgramDocumentType type) {
        PhdProgramDocumentUploadBean bean = new PhdProgramDocumentUploadBean();
        bean.setType(type);
        return bean;
    }

    private List<PhdProgramDocumentUploadBean> createHabilitationCertificateDocuments(PhdProgramCandidacyProcessBean bean) {
        ArrayList<PhdProgramDocumentUploadBean> result = new ArrayList<PhdProgramDocumentUploadBean>(bean.getQualifications().size());
        if (bean.hasAnyQualification()) {
            bean.sortQualificationsByAttendedEnd();
            for (QualificationBean qualification : bean.getQualifications()) {
                PhdProgramDocumentUploadBean uploadBean = this.createDocumentBean(PhdIndividualProgramDocumentType.HABILITATION_CERTIFICATE_DOCUMENT);
                uploadBean.setRemarks(qualification.getType().getLocalizedName());
                result.add(uploadBean);
            }
        }
        return result;
    }

    private List<PhdProgramDocumentUploadBean> createPhdGuidingLetters(PhdProgramCandidacyProcessBean bean) {
        ArrayList<PhdProgramDocumentUploadBean> result = new ArrayList<PhdProgramDocumentUploadBean>(bean.getGuidings().size());
        if (bean.hasAnyGuiding()) {
            for (int i = 0; i < bean.getGuidings().size(); ++i) {
                result.add(this.createDocumentBean(PhdIndividualProgramDocumentType.GUIDER_ACCEPTANCE_LETTER));
            }
        }
        return result;
    }

    public ActionForward createCandidacyStepThreeInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyBean", this.getRenderedObject("candidacyBean"));
        return mapping.findForward("createCandidacyStepThree");
    }

    @Override
    public ActionForward createCandidacy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        try {
            CreateNewProcess.run(PhdIndividualProgramProcess.PublicPhdIndividualProgramProcess.class, (Object)bean);
            this.sendApplicationSuccessfullySubmitedEmail(bean.getCandidacyHashCode(), request);
        }
        catch (DomainException e) {
            if ("error.person.existent.docIdAndType".equals(e.getKey())) {
                this.addErrorMessage(request, "error.phd.public.candidacy.fill.personal.information.and.institution.id", e.getArgs());
            } else {
                this.addErrorMessage(request, e.getKey(), e.getArgs());
            }
            bean.clearPerson();
            return this.createCandidacyStepOneInvalid(mapping, form, request, response);
        }
        String url = EPFLPhdCandidacyProcessProperties.getPublicCandidacyAccessLink(bean.getCandidacyHashCode());
        return new FenixActionForward(request, new ActionForward(url, true));
    }

    public ActionForward showCandidacySuccess(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("showCandidacySuccess");
    }

    private void sendApplicationSuccessfullySubmitedEmail(PhdProgramPublicCandidacyHashCode hashCode, HttpServletRequest request) {
        String subject = BundleUtil.getString((String)"resources.PhdResources", (String)"message.phd.epfl.email.subject.application.submited", (String[])new String[0]);
        String body = BundleUtil.getString((String)"resources.PhdResources", (String)"message.phd.epfl.email.body.application.submited", (String[])new String[0]);
        hashCode.sendEmail(subject, String.format(body, hashCode.getPhdProgramCandidacyProcess().getProcessNumber(), EPFLPhdCandidacyProcessProperties.getConfiguration().getPublicCandidacyAccessLink(), hashCode.getValue()));
    }

    private void clearDocumentsInformation(PhdProgramCandidacyProcessBean bean) {
        bean.getCurriculumVitae().setFile(null);
        RenderUtils.invalidateViewState((String)"candidacyBean.curriculumVitae");
        bean.getIdentificationDocument().setFile(null);
        RenderUtils.invalidateViewState((String)"candidacyBean.identificationDocument");
        bean.getMotivationLetter().setFile(null);
        RenderUtils.invalidateViewState((String)"candidacyBean.motivationLetter");
        bean.getSocialSecurityDocument().setFile(null);
        RenderUtils.invalidateViewState((String)"candidacyBean.socialSecurityDocument");
        bean.getResearchPlan().setFile(null);
        RenderUtils.invalidateViewState((String)"candidacyBean.researchPlan");
        bean.getDissertationOrFinalWorkDocument().setFile(null);
        RenderUtils.invalidateViewState((String)"candidacyBean.dissertationOrFinalWorkDocument");
        bean.removeHabilitationCertificateDocumentFiles();
        this.invalidateHabilitationCertificateDocumentViewStates();
        bean.setPhdGuidingLetters(null);
        this.invalidatePhdGuidingLetterViewStates();
    }

    private void invalidateHabilitationCertificateDocumentViewStates() {
        this.invalidViewStatesWith("candidacyBean.habilitationCertificateDocument");
    }

    private void invalidatePhdGuidingLetterViewStates() {
        this.invalidViewStatesWith("candidacyBean.phdGuidingLetter");
    }

    private void invalidViewStatesWith(String prefixId) {
        for (IViewState viewState : this.getViewStatesWithPrefixId(prefixId)) {
            RenderUtils.invalidateViewState((String)viewState.getId());
        }
    }

    public ActionForward addHabilitationCertificateDocument(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        PhdProgramDocumentUploadBean document = this.createDocumentBean(PhdIndividualProgramDocumentType.HABILITATION_CERTIFICATE_DOCUMENT);
        bean.addHabilitationCertificateDocument(document);
        request.setAttribute("candidacyBean", (Object)bean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("createCandidacyStepThree");
    }

    public ActionForward removeHabilitationCertificateDocument(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        if (bean.getHabilitationCertificateDocuments().size() > 2) {
            bean.removeHabilitationCertificateDocument(this.getIntegerFromRequest(request, "removeIndex"));
        }
        request.setAttribute("candidacyBean", (Object)bean);
        this.clearDocumentsInformation(bean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("createCandidacyStepThree");
    }

    public ActionForward viewCandidacy(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return this.viewCandidacy(mapping, request, (PhdProgramPublicCandidacyHashCode)((Object)PublicCandidacyHashCode.getPublicCandidacyCodeByHash(request.getParameter("hash"))));
    }

    private ActionForward viewCandidacy(ActionMapping mapping, HttpServletRequest request, PhdProgramPublicCandidacyHashCode hashCode) {
        if (hashCode == null || !hashCode.hasCandidacyProcess()) {
            return mapping.findForward("createCandidacyStepOne");
        }
        PhdIndividualProgramProcess phdProcess = hashCode.getIndividualProgramProcess();
        PhdProgramCandidacyProcessBean bean = new PhdProgramCandidacyProcessBean();
        bean.setCandidacyHashCode(hashCode);
        request.setAttribute("candidacyBean", (Object)bean);
        request.setAttribute("individualProgramProcess", (Object)phdProcess);
        this.canEditCandidacy(request, bean.getCandidacyHashCode());
        this.canEditPersonalInformation(request, hashCode.getPerson());
        PersonBean personBean = new PersonBean(phdProcess.getPerson());
        this.initPersonBean(personBean, phdProcess.getPerson());
        request.setAttribute("personBean", (Object)personBean);
        request.setAttribute("candidacyPeriod", (Object)this.getPhdCandidacyPeriod(hashCode));
        this.validateProcess(request, hashCode.getIndividualProgramProcess());
        request.setAttribute("pendingPartyContactBean", (Object)new PendingPartyContactBean(hashCode.getIndividualProgramProcess().getPerson()));
        return mapping.findForward("viewCandidacy");
    }

    public ActionForward backToViewCandidacy(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return this.viewCandidacy(mapping, request, this.getCandidacyBean().getCandidacyHashCode());
    }

    public ActionForward prepareEditPersonalInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        PhdIndividualProgramProcess individualProgramProcess = bean.getCandidacyHashCode().getIndividualProgramProcess();
        Person person = individualProgramProcess.getPerson();
        this.canEditPersonalInformation(request, person);
        bean.setPersonBean(new PersonBean(person));
        this.initPersonBean(bean.getPersonBean(), person);
        request.setAttribute("candidacyBean", (Object)bean);
        return mapping.findForward("editPersonalInformation");
    }

    private void initPersonBean(PersonBean personBean, Person person) {
        personBean.setGivenNames(person.getGivenNames());
        personBean.setFamilyNames(person.getFamilyNames());
        personBean.setUsername(person.getUsername());
        personBean.setGender(person.getGender());
        personBean.setMaritalStatus(person.getMaritalStatus());
        personBean.setFatherName(person.getNameOfFather());
        personBean.setMotherName(person.getNameOfMother());
        personBean.setProfession(person.getProfession());
        personBean.setNationality(person.getCountry());
        personBean.setCountryOfBirth(person.getCountryOfBirth());
        personBean.setDateOfBirth(person.getDateOfBirthYearMonthDay());
        personBean.setParishOfBirth(person.getParishOfBirth());
        personBean.setDistrictOfBirth(person.getDistrictOfBirth());
        personBean.setDistrictSubdivisionOfBirth(person.getDistrictSubdivisionOfBirth());
        personBean.setDocumentIdEmissionDate(person.getEmissionDateOfDocumentIdYearMonthDay());
        personBean.setDocumentIdEmissionLocation(person.getEmissionLocationOfDocumentId());
        personBean.setDocumentIdExpirationDate(person.getExpirationDateOfDocumentIdYearMonthDay());
        personBean.setDocumentIdNumber(person.getDocumentIdNumber());
        personBean.setIdDocumentType(person.getIdDocumentType());
        personBean.setSocialSecurityNumber(person.getSocialSecurityNumber());
        PendingPartyContactBean pendingPartyContactBean = new PendingPartyContactBean(person);
        if (pendingPartyContactBean.getDefaultPhysicalAddress() != null) {
            PhysicalAddress physicalAddress = pendingPartyContactBean.getDefaultPhysicalAddress();
            personBean.setAddress(physicalAddress.getAddress());
            personBean.setArea(physicalAddress.getArea());
            personBean.setAreaCode(physicalAddress.getAreaCode());
            personBean.setAreaOfAreaCode(physicalAddress.getAreaOfAreaCode());
            personBean.setParishOfResidence(physicalAddress.getParishOfResidence());
            personBean.setDistrictSubdivisionOfResidence(physicalAddress.getDistrictSubdivisionOfResidence());
            personBean.setDistrictOfResidence(physicalAddress.getDistrictOfResidence());
            personBean.setCountryOfResidence(physicalAddress.getCountryOfResidence());
        }
        personBean.setPhone(pendingPartyContactBean.getDefaultPhone() != null ? pendingPartyContactBean.getDefaultPhone().getNumber() : null);
        personBean.setMobile(pendingPartyContactBean.getDefaultMobilePhone() != null ? pendingPartyContactBean.getDefaultMobilePhone().getNumber() : null);
        personBean.setEmail(pendingPartyContactBean.getDefaultEmailAddress().getValue());
        personBean.setEmailAvailable(person.getAvailableEmail());
        personBean.setHomepageAvailable(person.getAvailableWebSite());
        personBean.setPerson(person);
    }

    public ActionForward editPersonalInformationInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        this.canEditPersonalInformation(request, bean.getPersonBean().getPerson());
        request.setAttribute("candidacyBean", (Object)bean);
        return mapping.findForward("editPersonalInformation");
    }

    public ActionForward editPersonalInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        PhdIndividualProgramProcess individualProgramProcess = bean.getCandidacyHashCode().getIndividualProgramProcess();
        Person person = individualProgramProcess.getPerson();
        this.canEditPersonalInformation(request, person);
        PersonBean personBean = bean.getPersonBean();
        String familyName = personBean.getFamilyNames();
        String composedName = familyName == null || familyName.isEmpty() ? personBean.getGivenNames() : personBean.getGivenNames() + " " + familyName;
        personBean.setName(composedName);
        try {
            ExecuteProcessActivity.run((Process)((Object)individualProgramProcess), EditPersonalInformation.class, (Object)bean.getPersonBean());
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("candidacyBean", (Object)bean);
            return mapping.findForward("editPersonalInformation");
        }
        return this.viewCandidacy(mapping, request, bean.getCandidacyHashCode());
    }

    public ActionForward prepareUploadDocuments(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        RenderUtils.invalidateViewState();
        this.prepareUploadDocumentsAttributes(bean, request);
        return mapping.findForward("uploadCandidacyDocuments");
    }

    private void prepareUploadDocumentsAttributes(PhdProgramCandidacyProcessBean bean, HttpServletRequest request) {
        request.setAttribute("candidacyBean", (Object)bean);
        request.setAttribute("candidacyProcessDocuments", bean.getCandidacyHashCode().getIndividualProgramProcess().getCandidacyProcessDocuments());
        PhdProgramDocumentUploadBean uploadBean = new PhdProgramDocumentUploadBean();
        uploadBean.setIndividualProgramProcess(bean.getCandidacyHashCode().getIndividualProgramProcess());
        request.setAttribute("documentByType", (Object)uploadBean);
        this.validateProcessDocuments(request, bean.getCandidacyHashCode().getIndividualProgramProcess());
    }

    @Override
    public ActionForward uploadDocumentsInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        request.setAttribute("candidacyBean", (Object)bean);
        request.setAttribute("documentByType", this.getRenderedObject("documentByType"));
        request.setAttribute("candidacyProcessDocuments", bean.getCandidacyHashCode().getIndividualProgramProcess().getCandidacyProcessDocuments());
        if (!RenderUtils.getViewState((String)"documentByType").isValid()) {
            this.addErrorMessage(request, "error.documentToUpload.not.valid", new String[0]);
        }
        RenderUtils.invalidateViewState();
        this.validateProcessDocuments(request, bean.getCandidacyHashCode().getIndividualProgramProcess());
        return mapping.findForward("uploadCandidacyDocuments");
    }

    @Override
    public ActionForward uploadDocuments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (!RenderUtils.getViewState((String)"documentByType").isValid()) {
            return this.uploadDocumentsInvalid(mapping, form, request, response);
        }
        PhdProgramDocumentUploadBean uploadBean = (PhdProgramDocumentUploadBean)this.getRenderedObject("documentByType");
        if (!uploadBean.hasAnyInformation()) {
            this.addErrorMessage(request, "message.no.documents.to.upload", new String[0]);
            return this.uploadDocumentsInvalid(mapping, form, request, response);
        }
        try {
            PhdIndividualProgramProcess individualProgramProcess = uploadBean.getIndividualProgramProcess();
            ExecuteProcessActivity.run((Process)((Object)individualProgramProcess), UploadDocuments.class, Collections.singletonList(uploadBean));
            this.addSuccessMessage(request, "message.documents.uploaded.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, "message.no.documents.to.upload", new String[0]);
            return this.uploadDocumentsInvalid(mapping, form, request, response);
        }
        return this.prepareUploadDocuments(mapping, form, request, response);
    }

    public ActionForward removeDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramProcessDocument document = (PhdProgramProcessDocument)((Object)this.getDomainObject(request, "documentId"));
        PhdProgramCandidacyProcess process2 = (PhdProgramCandidacyProcess)((Object)document.getPhdProgramProcess());
        PhdProgramCandidacyProcessBean bean = new PhdProgramCandidacyProcessBean(process2);
        try {
            ExecuteProcessActivity.run((Process)((Object)process2), RemoveCandidacyDocument.class, (Object)document);
            this.addSuccessMessage(request, "message.documents.uploaded.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, "message.no.documents.to.upload", new String[0]);
            return this.uploadDocumentsInvalid(mapping, form, request, response);
        }
        RenderUtils.invalidateViewState();
        request.setAttribute("canEditCandidacy", (Object)true);
        this.prepareUploadDocumentsAttributes(bean, request);
        return mapping.findForward("uploadCandidacyDocuments");
    }

    public ActionForward prepareEditPhdIndividualProgramProcessInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean candidacyBean = this.getCandidacyBean();
        request.setAttribute("candidacyBean", (Object)candidacyBean);
        request.setAttribute("individualProcessBean", (Object)new PhdIndividualProgramProcessBean(candidacyBean.getCandidacyHashCode().getIndividualProgramProcess()));
        return mapping.findForward("editPhdIndividualProgramProcessInformation");
    }

    public ActionForward prepareEditPhdIndividualProgramProcessInformationFocusAreaPostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyBean", (Object)this.getCandidacyBean());
        PhdIndividualProgramProcessBean phdBean = (PhdIndividualProgramProcessBean)this.getRenderedObject("individualProcessBean");
        phdBean.updateThesisSubjectBeans();
        request.setAttribute("individualProcessBean", (Object)phdBean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("editPhdIndividualProgramProcessInformation");
    }

    public ActionForward editPhdIndividualProgramProcessInformationInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyBean", (Object)this.getCandidacyBean());
        request.setAttribute("individualProcessBean", this.getRenderedObject("individualProcessBean"));
        return mapping.findForward("editPhdIndividualProgramProcessInformation");
    }

    public ActionForward editPhdIndividualProgramProcessInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdIndividualProgramProcessBean bean = (PhdIndividualProgramProcessBean)this.getRenderedObject("individualProcessBean");
        try {
            PhdIndividualProgramProcess individualProgramProcess = bean.getIndividualProgramProcess();
            ExecuteProcessActivity.run((Process)((Object)individualProgramProcess), EditIndividualProcessInformation.class, (Object)bean);
            this.addSuccessMessage(request, "message.phdIndividualProgramProcessInformation.edit.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("candidacyBean", (Object)this.getCandidacyBean());
            request.setAttribute("individualProcessBean", (Object)bean);
            return mapping.findForward("editPhdIndividualProgramProcessInformation");
        }
        return this.viewCandidacy(mapping, request, this.getCandidacyBean().getCandidacyHashCode());
    }

    public ActionForward prepareEditCandidacyGuidings(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return this.prepareAddGuidingToExistingCandidacy(mapping, actionForm, request, response);
    }

    public ActionForward editCandidacyGuidingsInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyBean", (Object)this.getCandidacyBean());
        return mapping.findForward("editCandidacyGuidings");
    }

    public ActionForward prepareAddGuidingToExistingCandidacy(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        request.setAttribute("candidacyBean", (Object)bean);
        if (bean.getCandidacyHashCode().getIndividualProgramProcess().getGuidingsSet().isEmpty()) {
            bean.setGuidings(this.createGuidingsMinimumList(bean.getIndividualProgramProcess()));
        } else {
            bean.setGuidings(new ArrayList<PhdParticipantBean>());
            bean.addGuiding(new PhdParticipantBean(bean.getIndividualProgramProcess()));
        }
        RenderUtils.invalidateViewState();
        return mapping.findForward("editCandidacyGuidings");
    }

    public ActionForward removeGuidingFromCreationList(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        if (bean.getGuidings().size() > 1) {
            bean.removeGuiding(this.getIntegerFromRequest(request, "removeIndex"));
        }
        request.setAttribute("candidacyBean", (Object)bean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("editCandidacyGuidings");
    }

    public ActionForward addGuidingToExistingCandidacy(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        try {
            PhdIndividualProgramProcess individualProgramProcess = bean.getCandidacyHashCode().getIndividualProgramProcess();
            ExecuteProcessActivity.run((Process)((Object)individualProgramProcess), AddGuidingsInformation.class, bean.getGuidings());
            this.addSuccessMessage(request, "message.guiding.created.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.editCandidacyGuidingsInvalid(mapping, actionForm, request, response);
        }
        bean.setGuidings(null);
        return this.prepareEditCandidacyGuidings(mapping, actionForm, request, response);
    }

    public ActionForward removeGuidingFromExistingCandidacy(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        String externalId = (String)this.getFromRequest(request, "removeIndex");
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        PhdParticipant guiding = this.getGuiding(bean.getCandidacyHashCode().getIndividualProgramProcess(), externalId);
        try {
            PhdIndividualProgramProcess individualProgramProcess = this.getCandidacyBean().getCandidacyHashCode().getIndividualProgramProcess();
            ExecuteProcessActivity.run((Process)((Object)individualProgramProcess), DeleteGuiding.class, (Object)guiding);
            this.addSuccessMessage(request, "message.guiding.deleted.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.editCandidacyGuidingsInvalid(mapping, actionForm, request, response);
        }
        return this.prepareEditCandidacyGuidings(mapping, actionForm, request, response);
    }

    private PhdParticipant getGuiding(PhdIndividualProgramProcess individualProgramProcess, String externalId) {
        for (PhdParticipant guiding : individualProgramProcess.getGuidingsSet()) {
            if (!guiding.getExternalId().equals(externalId)) continue;
            return guiding;
        }
        return null;
    }

    public ActionForward prepareEditCandidacyReferees(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return this.prepareAddCandidacyRefereeToExistingCandidacy(mapping, actionForm, request, response);
    }

    public ActionForward prepareAddCandidacyRefereeToExistingCandidacy(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyBean", (Object)this.getCandidacyBean());
        request.setAttribute("refereeBean", (Object)new PhdCandidacyRefereeBean());
        return mapping.findForward("editCandidacyReferees");
    }

    public ActionForward editCandidacyRefereesInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyBean", (Object)this.getCandidacyBean());
        request.setAttribute("refereeBean", this.getRenderedObject("refereeBean"));
        return mapping.findForward("editCandidacyReferees");
    }

    public ActionForward addCandidacyRefereeToExistingCandidacy(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            PhdIndividualProgramProcess individualProgramProcess = this.getCandidacyBean().getCandidacyHashCode().getIndividualProgramProcess();
            ExecuteProcessActivity.run((Process)((Object)individualProgramProcess), AddCandidacyReferees.class, Collections.singletonList(this.getRenderedObject("refereeBean")));
            this.addSuccessMessage(request, "message.qualification.information.create.success", new String[0]);
            RenderUtils.invalidateViewState((String)"refereeBean");
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.editCandidacyRefereesInvalid(mapping, actionForm, request, response);
        }
        return this.prepareEditCandidacyReferees(mapping, actionForm, request, response);
    }

    public ActionForward sendCandidacyRefereeEmail(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        PhdCandidacyReferee referee = this.getReferee(bean.getCandidacyHashCode().getIndividualProgramProcess(), request);
        referee.sendEmail();
        this.addSuccessMessage(request, "message.candidacy.referee.email.sent.with.success", referee.getName());
        return this.prepareEditCandidacyReferees(mapping, actionForm, request, response);
    }

    private PhdCandidacyReferee getReferee(PhdIndividualProgramProcess process2, HttpServletRequest request) {
        String externalId = (String)this.getFromRequest(request, "removeIndex");
        for (PhdCandidacyReferee referee : process2.getPhdCandidacyReferees()) {
            if (!referee.getExternalId().equals(externalId)) continue;
            return referee;
        }
        return null;
    }

    public ActionForward prepareEditQualifications(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return this.prepareAddQualificationToExistingCandidacy(mapping, actionForm, request, response);
    }

    public ActionForward editQualificationsInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyBean", (Object)this.getCandidacyBean());
        request.setAttribute("qualificationBean", this.getRenderedObject("qualificationBean"));
        return mapping.findForward("editQualifications");
    }

    public ActionForward prepareAddQualificationToExistingCandidacy(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyBean", (Object)this.getCandidacyBean());
        request.setAttribute("qualificationBean", (Object)new QualificationBean());
        return mapping.findForward("editQualifications");
    }

    public ActionForward addQualificationToExistingCandidacy(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        try {
            PhdIndividualProgramProcess individualProgramProcess = this.getCandidacyBean().getCandidacyHashCode().getIndividualProgramProcess();
            ExecuteProcessActivity.run((Process)((Object)individualProgramProcess), AddQualification.class, this.getRenderedObject("qualificationBean"));
            this.addSuccessMessage(request, "message.qualification.information.create.success", new String[0]);
            RenderUtils.invalidateViewState((String)"qualificationBean");
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.editQualificationsInvalid(mapping, actionForm, request, response);
        }
        return this.prepareEditQualifications(mapping, actionForm, request, response);
    }

    public ActionForward removeQualificationFromExistingCandidacy(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        String externalId = (String)this.getFromRequest(request, "removeIndex");
        PhdIndividualProgramProcess individualProgramProcess = bean.getCandidacyHashCode().getIndividualProgramProcess();
        Qualification qualification = this.getQualification(individualProgramProcess, externalId);
        try {
            ExecuteProcessActivity.run((Process)((Object)individualProgramProcess), DeleteQualification.class, (Object)qualification);
            this.addSuccessMessage(request, "message.qualification.information.delete.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
        }
        RenderUtils.invalidateViewState((String)"qualificationBean");
        return this.prepareEditQualifications(mapping, actionForm, request, response);
    }

    private Qualification getQualification(PhdIndividualProgramProcess individualProgramProcess, String externalId) {
        for (Qualification qualification : individualProgramProcess.getQualifications()) {
            if (!qualification.getExternalId().equals(externalId)) continue;
            return qualification;
        }
        return null;
    }

    public ActionForward prepareCreateRefereeLetter(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdCandidacyReferee hashCode = (PhdCandidacyReferee)((Object)PublicCandidacyHashCode.getPublicCandidacyCodeByHash(request.getParameter("hash")));
        if (hashCode == null) {
            request.setAttribute("no-information", (Object)Boolean.TRUE);
            return mapping.findForward("createRefereeLetterSuccess");
        }
        if (hashCode.getLetter() != null) {
            request.setAttribute("has-letter", (Object)Boolean.TRUE);
            request.setAttribute("letter", (Object)hashCode.getLetter());
            return mapping.findForward("createRefereeLetterSuccess");
        }
        PhdCandidacyRefereeLetterBean bean = new PhdCandidacyRefereeLetterBean();
        bean.setCandidacyReferee(hashCode);
        bean.setRefereeName(hashCode.getName());
        request.setAttribute("createRefereeLetterBean", (Object)bean);
        return mapping.findForward("createRefereeLetter");
    }

    public ActionForward createRefereeLetterInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdCandidacyRefereeLetterBean bean = (PhdCandidacyRefereeLetterBean)this.getRenderedObject("createRefereeLetterBean");
        request.setAttribute("createRefereeLetterBean", (Object)bean);
        RenderUtils.invalidateViewState((String)"createRefereeLetterBean.comments");
        bean.setFile(null);
        return mapping.findForward("createRefereeLetter");
    }

    public ActionForward createRefereeLetter(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdCandidacyRefereeLetterBean bean = (PhdCandidacyRefereeLetterBean)this.getRenderedObject("createRefereeLetterBean");
        if (this.hasAnyRefereeLetterViewStateInvalid()) {
            return this.createRefereeLetterInvalid(mapping, actionForm, request, response);
        }
        try {
            PhdCandidacyRefereeLetter.create(bean);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("createRefereeLetterBean", (Object)bean);
            return mapping.findForward("createRefereeLetter");
        }
        request.setAttribute("created-with-success", (Object)Boolean.TRUE);
        return mapping.findForward("createRefereeLetterSuccess");
    }

    private boolean hasAnyRefereeLetterViewStateInvalid() {
        for (IViewState viewState : this.getViewStatesWithPrefixId("createRefereeLetterBean.")) {
            if (viewState.isValid()) continue;
            return true;
        }
        return false;
    }

    public ActionForward prepareUploadPhoto(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyBean", (Object)this.getCandidacyBean());
        request.setAttribute("uploadPhotoBean", (Object)new PhotographUploadBean());
        return mapping.findForward("uploadPhoto");
    }

    public ActionForward uploadPhotoInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyBean", (Object)this.getCandidacyBean());
        request.setAttribute("uploadPhotoBean", this.getRenderedObject("uploadPhotoBean"));
        RenderUtils.invalidateViewState((String)"uploadPhotoBean");
        return mapping.findForward("uploadPhoto");
    }

    public ActionForward uploadPhoto(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        PhotographUploadBean photo = (PhotographUploadBean)this.getRenderedObject("uploadPhotoBean");
        if (!RenderUtils.getViewState((String)"uploadPhotoBean").isValid()) {
            this.addErrorMessage(request, "error.photo.upload.invalid.information", new String[0]);
            return this.uploadPhotoInvalid(mapping, actionForm, request, response);
        }
        if (ContentType.getContentType(photo.getContentType()) == null) {
            this.addErrorMessage(request, "error.photo.upload.unsupported.file", new String[0]);
            return this.uploadPhotoInvalid(mapping, actionForm, request, response);
        }
        try {
            photo.processImage();
            UploadOwnPhoto.upload(photo, bean.getCandidacyHashCode().getPerson());
        }
        catch (PhotographUploadBean.UnableToProcessTheImage e) {
            this.addErrorMessage(request, "error.photo.upload.unable.to.process.image", new String[0]);
            photo.deleteTemporaryFiles();
            return this.uploadPhotoInvalid(mapping, actionForm, request, response);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            photo.deleteTemporaryFiles();
            return this.uploadPhotoInvalid(mapping, actionForm, request, response);
        }
        return this.viewCandidacy(mapping, request, bean.getCandidacyHashCode());
    }

    private boolean validateProcess(HttpServletRequest request, PhdIndividualProgramProcess process2) {
        boolean result = true;
        if (process2.getPhdProgramFocusArea() == null) {
            this.addValidationMessage(request, "message.validation.missing.focus.area", new String[0]);
            result &= false;
        }
        if (process2.getPhdCandidacyReferees().size() < 3) {
            this.addValidationMessage(request, "message.validation.missing.minimum.candidacy.referees", String.valueOf(3));
            result &= false;
        }
        return this.validateProcessDocuments(request, process2);
    }

    private boolean validateProcessDocuments(HttpServletRequest request, PhdIndividualProgramProcess process2) {
        boolean result = true;
        if (!process2.hasCandidacyProcessDocument(PhdIndividualProgramDocumentType.CV)) {
            this.addValidationMessage(request, "message.validation.missing.cv", new String[0]);
            result &= false;
        }
        if (!process2.hasCandidacyProcessDocument(PhdIndividualProgramDocumentType.ID_DOCUMENT)) {
            this.addValidationMessage(request, "message.validation.missing.id.document", new String[0]);
            result &= false;
        }
        if (!process2.hasCandidacyProcessDocument(PhdIndividualProgramDocumentType.MOTIVATION_LETTER)) {
            this.addValidationMessage(request, "message.validation.missing.motivation.letter", new String[0]);
            result &= false;
        }
        if (process2.getCandidacyProcessDocumentsCount(PhdIndividualProgramDocumentType.HABILITATION_CERTIFICATE_DOCUMENT) < process2.getQualifications().size()) {
            this.addValidationMessage(request, "message.validation.missing.qualification.documents", String.valueOf(process2.getQualifications().size()));
            result &= false;
        }
        return result;
    }

    public ActionForward prepareValidateCandidacy(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        this.validateProcess(request, bean.getCandidacyHashCode().getIndividualProgramProcess());
        request.setAttribute("candidacyBean", (Object)bean);
        return mapping.findForward("validateCandidacy");
    }

    public ActionForward validateCandidacy(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        PhdProgramCandidacyProcessBean bean = this.getCandidacyBean();
        PhdIndividualProgramProcess process2 = bean.getCandidacyHashCode().getIndividualProgramProcess();
        if (!this.validateProcess(request, process2)) {
            request.setAttribute("candidacyBean", (Object)bean);
            return mapping.findForward("validateCandidacy");
        }
        try {
            ExecuteProcessActivity.run((Process)((Object)process2), ValidatedByCandidate.class, null);
            this.addSuccessMessage(request, "message.validation.with.success", new String[0]);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, e.getKey(), e.getArgs());
            return this.prepareValidateCandidacy(mapping, actionForm, request, response);
        }
        return this.viewCandidacy(mapping, request, bean.getCandidacyHashCode());
    }
}

