/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.manager.enrolments;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleLevel;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.AffinityCyclesManagement;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.InfoExecutionPeriod;
import org.fenixedu.academic.dto.commons.student.StudentNumberBean;
import org.fenixedu.academic.dto.student.enrollment.bolonha.BolonhaStudentEnrollmentBean;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.registration.TransitToBolonha;
import org.fenixedu.academic.ui.struts.action.commons.student.enrollment.bolonha.AbstractBolonhaStudentEnrollmentDA;
import org.fenixedu.academic.ui.struts.action.manager.ManagerApplications;
import org.fenixedu.academic.util.DateFormatUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.joda.time.DateTime;
import org.joda.time.YearMonthDay;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=ManagerApplications.ManagerStudentsApp.class, path="manage", titleKey="label.manage")
@Mapping(path="/bolonhaStudentEnrolment", module="manager", formBean="bolonhaStudentEnrolmentForm")
@Forwards(value={@Forward(name="viewStudentCurriculum", path="/manager/bolonha/enrolments/displayStudentCurriculum.jsp"), @Forward(name="chooseStudentInformation", path="/manager/bolonha/enrolments/chooseStudentInformation.jsp"), @Forward(name="showExecutionPeriodToEnrol", path="/manager/bolonha/enrolments/chooseExecutionPeriod.jsp"), @Forward(name="showDegreeModulesToEnrol", path="/manager/bolonha/enrolments/showDegreeModulesToEnrol.jsp"), @Forward(name="chooseOptionalCurricularCourseToEnrol", path="/manager/bolonha/enrolments/chooseOptionalCurricularCourseToEnrol.jsp"), @Forward(name="chooseCycleCourseGroupToEnrol", path="/manager/bolonha/enrolments/chooseCycleCourseGroupToEnrol.jsp"), @Forward(name="transitToBolonha", path="/manager/bolonha/enrolments/transitToBolonha.jsp"), @Forward(name="showRegistrationStatesLog", path="/manager/bolonha/enrolments/showRegistrationStatesLog.jsp")})
public class BolonhaEnrolmentsManagementDA
extends AbstractBolonhaStudentEnrollmentDA {
    @EntryPoint
    public ActionForward prepareSearchStudent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Object renderedObject = this.getRenderedObject("student-number-bean");
        if (renderedObject == null) {
            request.setAttribute("studentNumberBean", (Object)new StudentNumberBean());
        } else {
            StudentNumberBean numberBean = (StudentNumberBean)renderedObject;
            Student student = this.getStudent(numberBean);
            if (student != null) {
                RenderUtils.invalidateViewState();
                request.setAttribute("registrations", this.getAllRegistrations(student));
                request.setAttribute("studentNumberBean", (Object)numberBean);
            }
        }
        return mapping.findForward("chooseStudentInformation");
    }

    public ActionForward showAllStudentCurricularPlans(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        StudentNumberBean studentNumberBean = new StudentNumberBean();
        Student student = this.getStudent(request);
        studentNumberBean.setNumber(student.getNumber());
        request.setAttribute("studentNumberBean", (Object)studentNumberBean);
        request.setAttribute("registrations", this.getAllRegistrations(student));
        return mapping.findForward("chooseStudentInformation");
    }

    private Student getStudent(HttpServletRequest request) {
        return (Student)((Object)this.getDomainObject(request, "studentId"));
    }

    private List<Registration> getAllRegistrations(Student student) {
        ArrayList<Registration> result = new ArrayList<Registration>();
        result.addAll(student.getRegistrationsSet());
        result.addAll(student.getTransitionRegistrations());
        Collections.sort(result, new ReverseComparator(Registration.COMPARATOR_BY_START_DATE));
        return result;
    }

    private Student getStudent(StudentNumberBean numberBean) {
        return numberBean.getNumber() != null ? Student.readStudentByNumber(numberBean.getNumber()) : null;
    }

    private StudentCurricularPlan getStudentCurricularPlan(HttpServletRequest request) {
        return (StudentCurricularPlan)((Object)this.getDomainObject(request, "scpId"));
    }

    public ActionForward prepareChooseExecutionPeriod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ((DynaActionForm)form).set("scpId", (Object)this.getStudentCurricularPlan(request).getExternalId());
        request.setAttribute("infoExecutionPeriod", (Object)new InfoExecutionPeriod(ExecutionSemester.readActualExecutionSemester()));
        return mapping.findForward("showExecutionPeriodToEnrol");
    }

    public ActionForward prepareShowDegreeModulesToEnrol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        InfoExecutionPeriod executionPeriodBean = (InfoExecutionPeriod)this.getRenderedObject("infoExecutionPeriod");
        request.setAttribute("bolonhaStudentEnrollmentBean", (Object)new BolonhaStudentEnrollmentBean(this.getStudentCurricularPlan(request), executionPeriodBean.getExecutionPeriod(), this.getCurricularYearForCurricularCourses(), this.getCurricularRuleLevel(form)));
        return mapping.findForward("showDegreeModulesToEnrol");
    }

    public ActionForward backToAllStudentCurricularPlans(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        BolonhaStudentEnrollmentBean bean = (BolonhaStudentEnrollmentBean)this.getRenderedObject("bolonhaStudentEnrolments");
        request.setAttribute("studentId", (Object)bean.getStudentCurricularPlan().getRegistration().getStudent().getExternalId());
        return this.showAllStudentCurricularPlans(mapping, form, request, response);
    }

    public ActionForward viewStudentCurriculum(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        DynaActionForm form = (DynaActionForm)actionForm;
        if (StringUtils.isEmpty((String)form.getString("detailed"))) {
            form.set("detailed", (Object)Boolean.TRUE.toString());
        }
        request.setAttribute("studentCurricularPlan", (Object)this.getStudentCurricularPlan(request));
        return mapping.findForward("viewStudentCurriculum");
    }

    @Override
    public ActionForward prepareShowDegreeModulesToEnrol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, BolonhaStudentEnrollmentBean bean) {
        request.setAttribute("bolonhaStudentEnrollmentBean", (Object)bean);
        return mapping.findForward("showDegreeModulesToEnrol");
    }

    @Override
    protected int[] getCurricularYearForCurricularCourses() {
        return null;
    }

    @Override
    protected CurricularRuleLevel getCurricularRuleLevel(ActionForm form) {
        return CurricularRuleLevel.ENROLMENT_NO_RULES;
    }

    @Override
    protected String getAction() {
        return null;
    }

    @Override
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    public ActionForward prepareTransit(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("studentCurricularPlan", (Object)this.getStudentCurricularPlan(request));
        return mapping.findForward("transitToBolonha");
    }

    public ActionForward transitToBolonha(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        DateTime date;
        DynaActionForm form = (DynaActionForm)actionForm;
        try {
            date = YearMonthDay.fromDateFields((Date)DateFormatUtil.parse("dd/MM/yyyy", form.getString("date"))).toDateTimeAtMidnight();
        }
        catch (ParseException e) {
            this.addActionMessage(request, "error.invalid.date.format");
            return this.prepareTransit(mapping, actionForm, request, response);
        }
        StudentCurricularPlan studentCurricularPlan = this.getStudentCurricularPlan(request);
        try {
            TransitToBolonha.run(null, studentCurricularPlan.getRegistration().getSourceRegistrationForTransition(), date);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
            return this.prepareTransit(mapping, actionForm, request, response);
        }
        return this.showAllStudentCurricularPlans(mapping, actionForm, request, response);
    }

    public ActionForward separateCycles(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        StudentCurricularPlan scp = (StudentCurricularPlan)((Object)this.getDomainObject(request, "scpOid"));
        try {
            new AffinityCyclesManagement(scp).createCycleOrRepeateSeparate();
            this.addActionMessage("success", request, "message.cycles.separated.with.success");
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
        }
        request.setAttribute("studentId", (Object)scp.getRegistration().getStudent().getExternalId());
        return this.showAllStudentCurricularPlans(mapping, actionForm, request, response);
    }

    public ActionForward showRegistrationStatesLog(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("registration", this.getDomainObject(request, "registrationId"));
        return mapping.findForward("showRegistrationStatesLog");
    }
}

