/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.externalServices.epfl;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExternalUser;
import org.fenixedu.academic.domain.Photograph;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessNumber;
import org.fenixedu.academic.domain.phd.candidacy.PhdCandidacyReferee;
import org.fenixedu.academic.domain.phd.candidacy.PhdProgramPublicCandidacyHashCode;
import org.fenixedu.academic.ui.struts.action.base.FenixAction;
import org.fenixedu.academic.ui.struts.action.externalServices.epfl.ExportEPFLPhdProgramCandidacies;
import org.fenixedu.academic.ui.struts.action.externalServices.epfl.ExportPhdIndividualProgramProcessesInHtml;
import org.fenixedu.academic.ui.struts.action.person.RetrievePersonalPhotoAction;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.commons.i18n.I18N;
import pt.ist.fenixframework.FenixFramework;

@Mapping(module="external", path="/epflCandidateInformation", scope="request", validate=false)
public class ExportPhdIndividualProgramProcessInformation
extends FenixAction {
    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.setLocale(request, Locale.ENGLISH);
        I18N.setLocale((HttpSession)request.getSession(), (Locale)Locale.ENGLISH);
        ActionForward actionForward = this.checkPermissions(request, response);
        if (actionForward == null) {
            String method = request.getParameter("method");
            if (method == null || method.isEmpty() || method.equals("login")) {
                this.displayPresentationPage(request, response);
            } else if (method.equals("displayCandidatePage")) {
                this.displayCandidatePage(request, response);
            } else if (method.equals("displayRefereePage")) {
                this.displayRefereePage(request, response);
            } else if (method.equals("downloadCandidateDocuments")) {
                this.downloadCandidateDocuments(request, response);
            } else if (method.equals("displayPhoto")) {
                this.displayPhoto(request, response);
            } else if (method.equals("exportInformationXml")) {
                this.exportInformationXml(request, response);
            }
        }
        return actionForward;
    }

    private void displayPresentationPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        byte[] presentationPage = ExportPhdIndividualProgramProcessesInHtml.exportPresentationPage();
        this.writeResponse(response, presentationPage, "text/html");
    }

    private void displayCandidatePage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String hashCode = request.getParameter("process");
        PhdProgramPublicCandidacyHashCode code = (PhdProgramPublicCandidacyHashCode)((Object)PhdProgramPublicCandidacyHashCode.getPublicCandidacyCodeByHash((String)hashCode));
        byte[] candidatePage = ExportPhdIndividualProgramProcessesInHtml.drawCandidatePage(code);
        this.writeResponse(response, candidatePage, "text/html");
    }

    private void displayRefereePage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String refereeOid = request.getParameter("refereeOid");
        int count = Integer.parseInt(request.getParameter("count"));
        PhdCandidacyReferee referee = (PhdCandidacyReferee)FenixFramework.getDomainObject((String)refereeOid);
        byte[] refereePage = ExportPhdIndividualProgramProcessesInHtml.drawLetter(referee, count);
        this.writeResponse(response, refereePage, "text/html");
    }

    private void downloadCandidateDocuments(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String candidateOid = request.getParameter("candidateOid");
        PhdProgramPublicCandidacyHashCode code = (PhdProgramPublicCandidacyHashCode)FenixFramework.getDomainObject((String)candidateOid);
        byte[] documents = ExportPhdIndividualProgramProcessesInHtml.createZip(code);
        String email = code.getEmail().substring(0, code.getEmail().indexOf("@"));
        String documentName = email + "-documents.zip";
        response.addHeader("Content-Disposition", "attachment; filename=" + documentName);
        this.writeResponse(response, documents, "application/zip");
    }

    private void displayPhoto(HttpServletRequest request, HttpServletResponse response) {
        String photoOid = request.getParameter("photoOid");
        if (photoOid == null || photoOid.isEmpty()) {
            RetrievePersonalPhotoAction.writeUnavailablePhoto(response, this.getServlet());
        } else {
            Photograph photo = (Photograph)FenixFramework.getDomainObject((String)photoOid);
            RetrievePersonalPhotoAction.writePhoto(response, photo);
        }
    }

    private void exportInformationXml(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.addHeader("Content-Disposition", "attachment; filename=epfl.xml");
        response.setContentType(Charset.defaultCharset().name());
        byte[] content = ExportEPFLPhdProgramCandidacies.run();
        this.writeResponse(response, content, "application/xml");
    }

    private void writeResponse(HttpServletResponse response, byte[] presentationPage, String contentType) throws IOException {
        ServletOutputStream outputStream = response.getOutputStream();
        response.setContentType(contentType);
        outputStream.write(presentationPage);
        outputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionForward checkPermissions(HttpServletRequest request, HttpServletResponse response) throws IOException {
        User userView = Authenticate.getUser();
        if (userView == null) {
            HttpSession session;
            HttpSession httpSession = session = request.getSession();
            synchronized (httpSession) {
                String externalUser = (String)request.getSession().getAttribute(((Object)((Object)this)).getClass().getName());
                if (externalUser != null && !externalUser.isEmpty()) {
                    return null;
                }
                String username = this.get(request, "username");
                if (username == null) {
                    return this.displayLoginPage(request, response);
                }
                String password = this.get(request, "password");
                if (this.isValidExternalUser(username, password)) {
                    request.getSession().setAttribute(((Object)((Object)this)).getClass().getName(), (Object)username);
                    return null;
                }
            }
        } else if (RoleType.MANAGER.isMember(userView.getPerson().getUser())) {
            return null;
        }
        return this.displayUnAuhtorizedPage(request, response);
    }

    private String get(HttpServletRequest request, String attribute) {
        String parameter = request.getParameter(attribute);
        return parameter == null ? (String)request.getAttribute(attribute) : parameter;
    }

    private boolean isValidExternalUser(String username, String password) {
        return !StringUtils.isEmpty((String)username) && !StringUtils.isEmpty((String)password) && this.isValidExternalUserPassword(username, password);
    }

    private boolean isValidExternalUserPassword(String username, String password) {
        for (ExternalUser externalUser : Bennu.getInstance().getExternalUserSet()) {
            if (!externalUser.verify(username, password)) continue;
            return true;
        }
        return false;
    }

    private ActionForward displayLoginPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String url = "http://fenix.ist.utl.pt/phd/epfl/applications/login";
        return new ActionForward("http://fenix.ist.utl.pt/phd/epfl/applications/login", true);
    }

    private ActionForward displayUnAuhtorizedPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String url = "http://fenix.ist.utl.pt/phd/epfl/applications/notAuthorized";
        return new ActionForward("http://fenix.ist.utl.pt/phd/epfl/applications/notAuthorized", true);
    }

    private PhdIndividualProgramProcess readProcessByNumber(int year, String number) {
        Set<PhdIndividualProgramProcessNumber> processList = PhdIndividualProgramProcessNumber.readByYear(year);
        for (PhdIndividualProgramProcessNumber process2 : processList) {
            if (!process2.getNumber().toString().equals(number)) continue;
            return process2.getProcess();
        }
        return null;
    }
}

