/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.candidacy.standalone;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessBean;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.standalone.StandaloneCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.standalone.StandaloneIndividualCandidacyProcess;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.period.StandaloneCandidacyPeriod;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.candidacy.CandidacyProcessDA;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.Spreadsheet;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminCandidaciesApp.class, path="standalone", titleKey="label.candidacy.standalone", accessGroup="(academic(MANAGE_CANDIDACY_PROCESSES) | academic(MANAGE_INDIVIDUAL_CANDIDACIES))", bundle="ApplicationResources")
@Mapping(path="/caseHandlingStandaloneCandidacyProcess", module="academicAdministration", formBeanClass=StandaloneCandidacyProcessForm.class)
@Forwards(value={@Forward(name="intro", path="/candidacy/standalone/mainCandidacyProcess.jsp"), @Forward(name="prepare-create-new-process", path="/candidacy/createCandidacyPeriod.jsp"), @Forward(name="prepare-edit-candidacy-period", path="/candidacy/editCandidacyPeriod.jsp"), @Forward(name="send-to-coordinator", path="/candidacy/sendToCoordinator.jsp"), @Forward(name="view-candidacy-results", path="/candidacy/standalone/viewCandidacyResults.jsp"), @Forward(name="insert-candidacy-results", path="/candidacy/standalone/introduceCandidacyResults.jsp"), @Forward(name="create-registrations", path="/candidacy/createRegistrations.jsp")})
public class StandaloneCandidacyProcessDA
extends CandidacyProcessDA {
    @Override
    protected Class getProcessType() {
        return StandaloneCandidacyProcess.class;
    }

    @Override
    protected Class getChildProcessType() {
        return StandaloneIndividualCandidacyProcess.class;
    }

    @Override
    protected Class getCandidacyPeriodType() {
        return StandaloneCandidacyPeriod.class;
    }

    protected StandaloneCandidacyProcess getProcess(HttpServletRequest request) {
        return (StandaloneCandidacyProcess)((Object)super.getProcess(request));
    }

    @Override
    protected void setStartInformation(ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        if (!this.hasExecutionInterval(request)) {
            ExecutionInterval executionInterval;
            List<StandaloneCandidacyProcess> candidacyProcesses;
            List<ExecutionInterval> executionIntervals = this.getExecutionIntervalsWithCandidacyPeriod();
            if (executionIntervals.size() == 1 && (candidacyProcesses = this.getCandidacyProcesses(executionInterval = executionIntervals.iterator().next())).size() == 1) {
                this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)candidacyProcesses.iterator().next()));
                this.setCandidacyProcessInformation(actionForm, this.getProcess(request));
                request.setAttribute("candidacyProcesses", candidacyProcesses);
                return;
            }
            request.setAttribute("canCreateProcess", this.canCreateProcess(this.getProcessType().getName()));
            request.setAttribute("executionIntervals", executionIntervals);
        } else {
            ExecutionInterval executionInterval = this.getExecutionInterval(request);
            StandaloneCandidacyProcess candidacyProcess = this.getCandidacyProcess(request, executionInterval);
            if (candidacyProcess != null) {
                this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)candidacyProcess));
                this.setCandidacyProcessInformation(actionForm, this.getProcess(request));
            } else {
                List<StandaloneCandidacyProcess> candidacyProcesses = this.getCandidacyProcesses(executionInterval);
                if (candidacyProcesses.size() == 1) {
                    this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)candidacyProcesses.iterator().next()));
                    this.setCandidacyProcessInformation(actionForm, this.getProcess(request));
                    request.setAttribute("candidacyProcesses", candidacyProcesses);
                    return;
                }
                request.setAttribute("canCreateProcess", this.canCreateProcess(this.getProcessType().getName()));
                request.setAttribute("executionIntervals", this.getExecutionIntervalsWithCandidacyPeriod());
            }
            request.setAttribute("candidacyProcesses", this.getCandidacyProcesses(executionInterval));
        }
    }

    private List<ExecutionInterval> getExecutionIntervalsWithCandidacyPeriod() {
        return ExecutionInterval.readExecutionIntervalsWithCandidacyPeriod(this.getCandidacyPeriodType());
    }

    private List<StandaloneCandidacyProcess> getCandidacyProcesses(ExecutionInterval executionInterval) {
        ArrayList<StandaloneCandidacyProcess> result = new ArrayList<StandaloneCandidacyProcess>();
        for (StandaloneCandidacyPeriod period : executionInterval.getStandaloneCandidacyPeriods()) {
            result.add(period.getStandaloneCandidacyProcess());
        }
        return result;
    }

    private void setCandidacyProcessInformation(ActionForm actionForm, StandaloneCandidacyProcess process2) {
        StandaloneCandidacyProcessForm form = (StandaloneCandidacyProcessForm)actionForm;
        form.setSelectedProcessId(process2.getExternalId());
        form.setExecutionIntervalId(process2.getCandidacyExecutionInterval().getExternalId());
    }

    protected StandaloneCandidacyProcess getCandidacyProcess(HttpServletRequest request, ExecutionInterval executionInterval) {
        String selectedProcessId = this.getStringFromRequest(request, "selectedProcessId");
        if (selectedProcessId != null) {
            for (StandaloneCandidacyPeriod candidacyPeriod : executionInterval.getStandaloneCandidacyPeriods()) {
                if (!candidacyPeriod.getStandaloneCandidacyProcess().getExternalId().equals(selectedProcessId)) continue;
                return candidacyPeriod.getStandaloneCandidacyProcess();
            }
        }
        return null;
    }

    @Override
    protected ActionForward introForward(ActionMapping mapping) {
        return mapping.findForward("intro");
    }

    @Override
    public ActionForward listProcessAllowedActivities(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)this.getProcess(request)));
        this.setCandidacyProcessInformation(form, this.getProcess(request));
        request.setAttribute("candidacyProcesses", this.getCandidacyProcesses(this.getProcess(request).getCandidacyExecutionInterval()));
        return this.introForward(mapping);
    }

    @Override
    public ActionForward prepareCreateNewProcess(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("candidacyProcessBean", (Object)new CandidacyProcessBean((ExecutionInterval)((Object)ExecutionSemester.readActualExecutionSemester())));
        return mapping.findForward("prepare-create-new-process");
    }

    public ActionForward prepareExecuteSendToCoordinator(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("send-to-coordinator");
    }

    public ActionForward executeSendToCoordinator(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeActivity((Process)((Object)this.getProcess(request)), "SendToCoordinator");
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            return this.prepareExecuteSendToCoordinator(mapping, actionForm, request, response);
        }
        return this.listProcessAllowedActivities(mapping, actionForm, request, response);
    }

    public ActionForward prepareExecutePrintCandidacies(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment; filename=" + this.getReportFilename());
        ServletOutputStream writer = response.getOutputStream();
        this.writeReport(this.getProcess(request), writer);
        writer.flush();
        response.flushBuffer();
        return null;
    }

    private void writeReport(StandaloneCandidacyProcess process2, ServletOutputStream writer) throws IOException {
        Spreadsheet spreadsheet = this.createSpreadSheet();
        for (StandaloneIndividualCandidacyProcess candidacy : process2.getSortedStandaloneIndividualCandidaciesThatCanBeSendToJury()) {
            if (!candidacy.canExecuteActivity(Authenticate.getUser())) continue;
            this.addRow(spreadsheet, candidacy);
        }
        spreadsheet.exportToXLSSheet((OutputStream)writer);
    }

    private void addRow(Spreadsheet spreadsheet, StandaloneIndividualCandidacyProcess candidacy) {
        Spreadsheet.Row row = spreadsheet.addRow();
        row.setCell(candidacy.getPersonalDetails().getName());
        row.setCell(candidacy.getPersonalDetails().getDocumentIdNumber());
        StringBuilder names = new StringBuilder();
        Iterator<CurricularCourse> elements = candidacy.getCurricularCourses().iterator();
        while (elements.hasNext()) {
            names.append(elements.next().getName(candidacy.getCandidacyExecutionInterval()));
            names.append(elements.hasNext() ? ", " : "");
        }
        row.setCell(names.toString());
    }

    private Spreadsheet createSpreadSheet() {
        Spreadsheet spreadsheet = new Spreadsheet("Candidacies");
        spreadsheet.setHeaders(new String[]{BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.name", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.identificationNumber", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.curricularCourses", (String[])new String[0])});
        return spreadsheet;
    }

    @Override
    protected List<CandidacyProcessDA.CandidacyDegreeBean> createCandidacyDegreeBeans(HttpServletRequest request) {
        StandaloneCandidacyProcess process2 = this.getProcess(request);
        ArrayList<CandidacyProcessDA.CandidacyDegreeBean> result = new ArrayList<CandidacyProcessDA.CandidacyDegreeBean>();
        for (StandaloneIndividualCandidacyProcess element : process2.getAcceptedStandaloneIndividualCandidacies()) {
            result.add(new StandaloneCandidacyDegreeBean(element));
        }
        return result;
    }

    @Override
    protected Spreadsheet buildIndividualCandidacyReport(Spreadsheet spreadsheet, IndividualCandidacyProcess individualCandidacyProcess) {
        return null;
    }

    public static class StandaloneCandidacyDegreeBean
    extends CandidacyProcessDA.CandidacyDegreeBean {
        public StandaloneCandidacyDegreeBean(StandaloneIndividualCandidacyProcess process2) {
            this.setPersonalDetails(process2.getPersonalDetails());
            this.setDegree(process2.getCandidacySelectedDegree());
            this.setState(process2.getCandidacyState());
            this.setRegistrationCreated(process2.hasRegistrationForCandidacy());
        }
    }

    public static class StandaloneCandidacyProcessForm
    extends CandidacyProcessDA.CandidacyProcessForm {
        private String selectedProcessId;

        public String getSelectedProcessId() {
            return this.selectedProcessId;
        }

        public void setSelectedProcessId(String selectedProcessId) {
            this.selectedProcessId = selectedProcessId;
        }
    }
}

