/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.candidacy.over23;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.over23.Over23CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.over23.Over23IndividualCandidacyProcess;
import org.fenixedu.academic.domain.caseHandling.Process;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.period.Over23CandidacyPeriod;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.candidacy.CandidacyProcessDA;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.fenixedu.commons.spreadsheet.SpreadsheetXLSExporter;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminCandidaciesApp.class, path="over-23", titleKey="label.candidacy.over23", accessGroup="(academic(MANAGE_CANDIDACY_PROCESSES) | academic(MANAGE_INDIVIDUAL_CANDIDACIES))", bundle="ApplicationResources")
@Mapping(path="/caseHandlingOver23CandidacyProcess", module="academicAdministration", formBeanClass=Over23CandidacyProcessForm.class)
@Forwards(value={@Forward(name="intro", path="/candidacy/mainCandidacyProcess.jsp"), @Forward(name="prepare-create-new-process", path="/candidacy/createCandidacyPeriod.jsp"), @Forward(name="prepare-edit-candidacy-period", path="/candidacy/editCandidacyPeriod.jsp"), @Forward(name="send-to-jury", path="/candidacy/over23/sendToJury.jsp"), @Forward(name="view-candidacy-results", path="/candidacy/over23/viewCandidacyResults.jsp"), @Forward(name="insert-candidacy-results", path="/candidacy/over23/introduceCandidacyResults.jsp"), @Forward(name="create-registrations", path="/candidacy/createRegistrations.jsp"), @Forward(name="prepare-select-available-degrees", path="/candidacy/selectAvailableDegrees.jsp")})
public class Over23CandidacyProcessDA
extends CandidacyProcessDA {
    @Override
    protected Class getProcessType() {
        return Over23CandidacyProcess.class;
    }

    @Override
    protected Class getChildProcessType() {
        return Over23IndividualCandidacyProcess.class;
    }

    @Override
    protected Class getCandidacyPeriodType() {
        return Over23CandidacyPeriod.class;
    }

    @Override
    protected void setStartInformation(ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        if (!this.hasExecutionInterval(request)) {
            ExecutionInterval executionInterval;
            List<Over23CandidacyProcess> candidacyProcesses;
            List<ExecutionInterval> executionIntervals = this.getExecutionIntervalsWithCandidacyPeriod();
            if (executionIntervals.size() == 1 && (candidacyProcesses = this.getCandidacyProcesses(executionInterval = executionIntervals.iterator().next())).size() == 1) {
                Over23CandidacyProcess process2 = candidacyProcesses.iterator().next();
                this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)process2));
                this.setCandidacyProcessInformation(actionForm, this.getProcess(request));
                request.setAttribute("candidacyProcesses", candidacyProcesses);
                CandidacyProcessDA.ChooseDegreeBean chooseDegreeBean = this.getChooseDegreeBean(request);
                chooseDegreeBean.setCandidacyProcess((CandidacyProcess)((Object)process2));
                return;
            }
            request.setAttribute("canCreateProcess", this.canCreateProcess(this.getProcessType().getName()));
            request.setAttribute("executionIntervals", executionIntervals);
        } else {
            ExecutionInterval executionInterval = this.getExecutionInterval(request);
            Over23CandidacyProcess candidacyProcess = this.getCandidacyProcess(request, executionInterval);
            if (candidacyProcess != null) {
                this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)candidacyProcess));
                this.setCandidacyProcessInformation(actionForm, this.getProcess(request));
            } else {
                List<Over23CandidacyProcess> candidacyProcesses = this.getCandidacyProcesses(executionInterval);
                if (candidacyProcesses.size() == 1) {
                    Over23CandidacyProcess process3 = candidacyProcesses.iterator().next();
                    this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)process3));
                    this.setCandidacyProcessInformation(actionForm, this.getProcess(request));
                    request.setAttribute("candidacyProcesses", candidacyProcesses);
                    CandidacyProcessDA.ChooseDegreeBean chooseDegreeBean = this.getChooseDegreeBean(request);
                    chooseDegreeBean.setCandidacyProcess((CandidacyProcess)((Object)process3));
                    return;
                }
                request.setAttribute("canCreateProcess", this.canCreateProcess(this.getProcessType().getName()));
                request.setAttribute("executionIntervals", this.getExecutionIntervalsWithCandidacyPeriod());
            }
            request.setAttribute("candidacyProcesses", this.getCandidacyProcesses(executionInterval));
        }
    }

    private List<ExecutionInterval> getExecutionIntervalsWithCandidacyPeriod() {
        return ExecutionInterval.readExecutionIntervalsWithCandidacyPeriod(this.getCandidacyPeriodType());
    }

    protected List<Over23CandidacyProcess> getCandidacyProcesses(ExecutionInterval executionInterval) {
        ArrayList<Over23CandidacyProcess> result = new ArrayList<Over23CandidacyProcess>();
        for (Over23CandidacyPeriod period : executionInterval.getOver23CandidacyPeriods()) {
            result.add(period.getOver23CandidacyProcess());
        }
        return result;
    }

    protected void setCandidacyProcessInformation(ActionForm actionForm, Over23CandidacyProcess process2) {
        Over23CandidacyProcessForm form = (Over23CandidacyProcessForm)actionForm;
        form.setSelectedProcessId(process2.getExternalId());
        form.setExecutionIntervalId(process2.getCandidacyExecutionInterval().getExternalId());
    }

    protected CandidacyProcessDA.ChooseDegreeBean getChooseDegreeBean(HttpServletRequest request) {
        return (CandidacyProcessDA.ChooseDegreeBean)request.getAttribute("chooseDegreeBean");
    }

    @Override
    protected ActionForward introForward(ActionMapping mapping) {
        return mapping.findForward("intro");
    }

    protected Over23CandidacyProcess getCandidacyProcess(HttpServletRequest request, ExecutionInterval executionInterval) {
        String selectedProcessId = this.getStringFromRequest(request, "selectedProcessId");
        if (selectedProcessId != null) {
            for (Over23CandidacyPeriod candidacyPeriod : executionInterval.getOver23CandidacyPeriods()) {
                Over23CandidacyProcess process2 = candidacyPeriod.getOver23CandidacyProcess();
                if (!process2.getExternalId().equals(selectedProcessId)) continue;
                return process2;
            }
        }
        return null;
    }

    public ActionForward prepareExecuteSendInformationToJury(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("send-to-jury");
    }

    public ActionForward executeSendInformationToJury(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeActivity((Process)((Object)this.getProcess(request)), "SendInformationToJury", null);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage(), e.getArgs());
            return this.prepareExecuteSendInformationToJury(mapping, actionForm, request, response);
        }
        return this.listProcessAllowedActivities(mapping, actionForm, request, response);
    }

    public ActionForward prepareExecutePrintCandidacies(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment; filename=" + this.getReportFilename());
        ServletOutputStream writer = response.getOutputStream();
        Over23CandidacyProcess process2 = this.getProcess(request);
        Spreadsheet spreadsheet = this.buildReport(process2.getOver23IndividualCandidaciesThatCanBeSendToJury());
        spreadsheet.exportToXLSSheet((OutputStream)writer);
        writer.flush();
        response.flushBuffer();
        return null;
    }

    private Spreadsheet buildReport(List<Over23IndividualCandidacyProcess> over23IndividualCandidacies) {
        CandidacyReport result = new CandidacyReport("candidacies");
        result.setHeaders(new String[]{BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.name", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.identificationNumber", (String[])new String[0]), BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.degrees", (String[])new String[0])});
        for (Over23IndividualCandidacyProcess candidacy : over23IndividualCandidacies) {
            if (!candidacy.canExecuteActivity(Authenticate.getUser())) continue;
            Spreadsheet.Row row = result.addRow();
            row.setCell(candidacy.getPersonalDetails().getName());
            row.setCell(candidacy.getPersonalDetails().getDocumentIdNumber());
            int count = 1;
            String degrees = "";
            for (Degree degree : candidacy.getSelectedDegreesSortedByOrder()) {
                degrees = degrees + count++ + " - " + degree.getNameFor(candidacy.getCandidacyExecutionInterval()) + "\n";
            }
            row.setCell(degrees);
        }
        return result;
    }

    @Override
    public ActionForward listProcessAllowedActivities(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.setCandidacyProcessInformation(request, (CandidacyProcess)((Object)this.getProcess(request)));
        super.listProcessAllowedActivities(mapping, form, request, response);
        return mapping.findForward("intro");
    }

    protected Over23CandidacyProcess getProcess(HttpServletRequest request) {
        return (Over23CandidacyProcess)((Object)super.getProcess(request));
    }

    @Override
    protected List<CandidacyProcessDA.CandidacyDegreeBean> createCandidacyDegreeBeans(HttpServletRequest request) {
        Over23CandidacyProcess process2 = this.getProcess(request);
        ArrayList<CandidacyProcessDA.CandidacyDegreeBean> candidacyDegreeBeans = new ArrayList<CandidacyProcessDA.CandidacyDegreeBean>();
        for (Over23IndividualCandidacyProcess child : process2.getAcceptedOver23IndividualCandidacies()) {
            if (!child.canExecuteActivity(Authenticate.getUser())) continue;
            candidacyDegreeBeans.add(new Over23CandidacyDegreeBean(child));
        }
        Collections.sort(candidacyDegreeBeans);
        return candidacyDegreeBeans;
    }

    @Override
    protected Spreadsheet buildIndividualCandidacyReport(Spreadsheet spreadsheet, IndividualCandidacyProcess individualCandidacyProcess) {
        return null;
    }

    public static class Over23CandidacyDegreeBean
    extends CandidacyProcessDA.CandidacyDegreeBean {
        public Over23CandidacyDegreeBean(Over23IndividualCandidacyProcess process2) {
            this.setPersonalDetails(process2.getPersonalDetails());
            this.setDegree(process2.getAcceptedDegree());
            this.setState(process2.getCandidacyState());
            this.setRegistrationCreated(process2.hasRegistrationForCandidacy());
        }
    }

    private class CandidacyReport
    extends Spreadsheet {
        public CandidacyReport(String name) {
            super(name);
        }

        public void exportToXLSSheet(OutputStream outputStream) throws IOException {
            new CandidacyXLSExporter().exportToXLSSheet(this, outputStream);
        }
    }

    private class CandidacyXLSExporter
    extends SpreadsheetXLSExporter {
        private CandidacyXLSExporter() {
        }

        protected void exportXLSLine(HSSFSheet sheet, HSSFCellStyle cellStyle, List<Object> cells, int offset) {
            HSSFRow row = sheet.createRow(sheet.getLastRowNum() + offset);
            cellStyle.setVerticalAlignment((short)1);
            int count = 0;
            for (Object cellValue : cells) {
                if (++count == 3) {
                    cellStyle.setAlignment((short)1);
                } else {
                    cellStyle.setAlignment((short)2);
                }
                this.addColumn(cellStyle, row, cellValue);
            }
        }
    }

    public static class Over23CandidacyProcessForm
    extends CandidacyProcessDA.CandidacyProcessForm {
        private String selectedProcessId;

        public String getSelectedProcessId() {
            return this.selectedProcessId;
        }

        public void setSelectedProcessId(String selectedProcessId) {
            this.selectedProcessId = selectedProcessId;
        }
    }
}

