/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.administrativeOffice.payments;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.accounting.CreditNote;
import org.fenixedu.academic.domain.accounting.CreditNoteState;
import org.fenixedu.academic.domain.accounting.Receipt;
import org.fenixedu.academic.domain.documents.CreditNoteGeneratedDocument;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.dto.accounting.CreateCreditNoteBean;
import org.fenixedu.academic.report.accounting.CreditNoteDocument;
import org.fenixedu.academic.service.services.accounting.ChangeCreditNoteState;
import org.fenixedu.academic.service.services.accounting.CreateCreditNote;
import org.fenixedu.academic.ui.struts.FenixActionForm;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.payments.PaymentsManagementDispatchAction;
import org.fenixedu.academic.ui.struts.action.administrativeOffice.student.SearchForStudentsDA;
import org.fenixedu.academic.util.report.ReportsUtils;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@Mapping(path="/creditNotes", module="academicAdministration", formBeanClass=CreditNotesActionForm.class, functionality=SearchForStudentsDA.class)
@Forwards(value={@Forward(name="list", path="/academicAdminOffice/payments/creditNotes/listCreditNotes.jsp"), @Forward(name="create", path="/academicAdminOffice/payments/creditNotes/createCreditNote.jsp"), @Forward(name="show", path="/academicAdminOffice/payments/creditNotes/showCreditNote.jsp"), @Forward(name="prepareShowReceipt", path="/academicAdministration/receipts.do?method=prepareShowReceipt")})
public class CreditNotesManagementDA
extends PaymentsManagementDispatchAction {
    public ActionForward showCreditNotes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("receipt", (Object)this.getReceiptFromViewState("receipt"));
        return mapping.findForward("list");
    }

    private Receipt getReceiptFromViewState(String viewStateId) {
        return (Receipt)((Object)this.getObjectFromViewState(viewStateId));
    }

    public ActionForward showCreditNote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("creditNote", (Object)this.getCreditNote(request));
        ((CreditNotesActionForm)form).setCreditNoteState(this.getCreditNote(request).getState().name());
        return mapping.findForward("show");
    }

    private CreditNote getCreditNote(HttpServletRequest request) {
        return (CreditNote)((Object)this.getDomainObject(request, "creditNoteId"));
    }

    public ActionForward prepareCreateCreditNote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("createCreditNoteBean", (Object)new CreateCreditNoteBean(this.getReceiptFromViewState("receipt")));
        return mapping.findForward("create");
    }

    public ActionForward createCreditNote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CreateCreditNoteBean createCreditNoteBean = (CreateCreditNoteBean)RenderUtils.getViewState((String)"create-credit-note").getMetaObject().getObject();
        try {
            CreateCreditNote.run(CreditNotesManagementDA.getUserView(request).getPerson(), createCreditNoteBean);
        }
        catch (DomainExceptionWithLabelFormatter ex) {
            this.addActionMessage(request, ex.getKey(), this.solveLabelFormatterArgs(request, ex.getLabelFormatterArgs()));
            request.setAttribute("createCreditNoteBean", (Object)createCreditNoteBean);
            return mapping.findForward("create");
        }
        catch (DomainException ex) {
            this.addActionMessage(request, ex.getKey());
            request.setAttribute("createCreditNoteBean", (Object)createCreditNoteBean);
            return mapping.findForward("create");
        }
        request.setAttribute("receipt", (Object)createCreditNoteBean.getReceipt());
        return mapping.findForward("list");
    }

    public ActionForward changeCreditNoteState(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CreditNote creditNote = this.getCreditNoteFromViewState();
        CreditNoteState creditNoteState = CreditNoteState.valueOf(((CreditNotesActionForm)form).getCreditNoteState());
        try {
            ChangeCreditNoteState.run(CreditNotesManagementDA.getUserView(request).getPerson(), creditNote, creditNoteState);
        }
        catch (DomainExceptionWithLabelFormatter ex) {
            this.addActionMessage(request, ex.getKey(), this.solveLabelFormatterArgs(request, ex.getLabelFormatterArgs()));
        }
        catch (DomainException ex) {
            this.addActionMessage(request, ex.getKey());
        }
        request.setAttribute("creditNote", (Object)creditNote);
        return mapping.findForward("show");
    }

    private CreditNote getCreditNoteFromViewState() {
        CreditNote creditNote = (CreditNote)((Object)RenderUtils.getViewState((String)"creditNote").getMetaObject().getObject());
        return creditNote;
    }

    public ActionForward printCreditNote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        CreditNote creditNote = this.getCreditNoteFromViewState();
        try {
            CreditNoteDocument original = new CreditNoteDocument(creditNote, true);
            CreditNoteDocument duplicate2 = new CreditNoteDocument(creditNote, false);
            byte[] data = ReportsUtils.generateReport(original, duplicate2).getData();
            CreditNoteGeneratedDocument.store(creditNote, original.getReportFileName() + ".pdf", data);
            response.setContentLength(data.length);
            response.setContentType("application/pdf");
            response.addHeader("Content-Disposition", String.format("attachment; filename=%s.pdf", original.getReportFileName()));
            response.getOutputStream().write(data);
            return null;
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("creditNoteId", (Object)creditNote.getExternalId());
            return this.showCreditNote(mapping, form, request, response);
        }
    }

    public ActionForward prepareShowReceipt(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("prepareShowReceipt");
    }

    public static class CreditNotesActionForm
    extends FenixActionForm {
        private static final long serialVersionUID = 1L;
        private String creditNoteState;

        public String getCreditNoteState() {
            return this.creditNoteState;
        }

        public void setCreditNoteState(String creditNoteState) {
            this.creditNoteState = creditNoteState;
        }
    }
}

