/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.spring.controller.teacher;

import java.util.HashMap;
import java.util.Map;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Grouping;
import org.joda.time.DateTime;
import org.springframework.format.annotation.DateTimeFormat;

public class ProjectGroupBean {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm";
    private String name;
    private String projectDescription;
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm")
    private DateTime enrolmentBeginDay = new DateTime();
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm")
    private DateTime enrolmentEndDay;
    private Boolean automaticEnrolment;
    private Boolean differentiatedCapacity;
    private String shiftType;
    private Boolean atomicEnrolmentPolicy;
    private Integer minimumGroupCapacity;
    private Integer maximumGroupCapacity;
    private Integer idealGroupCapacity;
    private Integer maxGroupNumber;
    private Map<String, Integer> differentiatedCapacityShifts = new HashMap<String, Integer>();
    private String externalId = null;

    public ProjectGroupBean() {
    }

    public ProjectGroupBean(ExecutionCourse executionCourse) {
        this();
        this.enrolmentBeginDay = new DateTime();
        this.externalId = null;
        executionCourse.getShiftsOrderedByLessons().stream().forEach(shift -> {
            if (shift.getShiftGroupingProperties() != null) {
                this.differentiatedCapacityShifts.put(shift.getExternalId(), shift.getShiftGroupingProperties().getCapacity());
            } else {
                this.differentiatedCapacityShifts.put(shift.getExternalId(), null);
            }
        });
    }

    public ProjectGroupBean(Grouping grouping, ExecutionCourse executionCourse) {
        this(executionCourse);
        this.name = grouping.getName();
        this.projectDescription = grouping.getProjectDescription();
        this.enrolmentBeginDay = grouping.getEnrolmentBeginDayDateDateTime();
        this.enrolmentEndDay = grouping.getEnrolmentEndDayDateDateTime();
        this.automaticEnrolment = grouping.getAutomaticEnrolment();
        this.differentiatedCapacity = grouping.getDifferentiatedCapacity();
        this.shiftType = grouping.getShiftType() == null ? "" : grouping.getShiftType().toString();
        this.atomicEnrolmentPolicy = grouping.getEnrolmentPolicy().getType() == 1;
        this.minimumGroupCapacity = grouping.getMinimumCapacity();
        this.maximumGroupCapacity = grouping.getMaximumCapacity();
        this.idealGroupCapacity = grouping.getIdealCapacity();
        this.maxGroupNumber = grouping.getGroupMaximumNumber();
        this.externalId = grouping.getExternalId();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public void setProjectDescription(String projectDescription) {
        this.projectDescription = projectDescription;
    }

    public DateTime getEnrolmentBeginDay() {
        return this.enrolmentBeginDay;
    }

    public void setEnrolmentBeginDay(DateTime enrolmentBeginDay) {
        this.enrolmentBeginDay = enrolmentBeginDay;
    }

    public DateTime getEnrolmentEndDay() {
        return this.enrolmentEndDay;
    }

    public void setEnrolmentEndDay(DateTime enrolmentEndDay) {
        this.enrolmentEndDay = enrolmentEndDay;
    }

    public Boolean getAutomaticEnrolment() {
        return this.automaticEnrolment;
    }

    public void setAutomaticEnrolment(Boolean automaticEnrolment) {
        this.automaticEnrolment = automaticEnrolment;
    }

    public String getShiftType() {
        return this.shiftType;
    }

    public void setShiftType(String shiftType) {
        this.shiftType = shiftType;
    }

    public Boolean getAtomicEnrolmentPolicy() {
        return this.atomicEnrolmentPolicy;
    }

    public void setAtomicEnrolmentPolicy(Boolean atomicEnrolmentPolicy) {
        this.atomicEnrolmentPolicy = atomicEnrolmentPolicy;
    }

    public Boolean getDifferentiatedCapacity() {
        return this.differentiatedCapacity;
    }

    public void setDifferentiatedCapacity(Boolean differentiatedCapacity) {
        this.differentiatedCapacity = differentiatedCapacity;
    }

    public Integer getMinimumGroupCapacity() {
        return this.minimumGroupCapacity;
    }

    public void setMinimumGroupCapacity(Integer minimumGroupCapacity) {
        this.minimumGroupCapacity = minimumGroupCapacity;
    }

    public Integer getMaximumGroupCapacity() {
        return this.maximumGroupCapacity;
    }

    public void setMaximumGroupCapacity(Integer maximumGroupCapacity) {
        this.maximumGroupCapacity = maximumGroupCapacity;
    }

    public Integer getIdealGroupCapacity() {
        return this.idealGroupCapacity;
    }

    public void setIdealGroupCapacity(Integer idealGroupCapacity) {
        this.idealGroupCapacity = idealGroupCapacity;
    }

    public Integer getMaxGroupNumber() {
        return this.maxGroupNumber;
    }

    public void setMaxGroupNumber(Integer maxGroupNumber) {
        this.maxGroupNumber = maxGroupNumber;
    }

    public Map<String, Integer> getDifferentiatedCapacityShifts() {
        return this.differentiatedCapacityShifts;
    }

    public void setDifferentiatedCapacityShifts(Map<String, Integer> differentiatedCapacityShifts) {
        this.differentiatedCapacityShifts = differentiatedCapacityShifts;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }
}

