/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.providers;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.ui.struts.action.academicAdministration.executionCourseManagement.ExecutionCourseBean;
import org.fenixedu.academic.ui.struts.action.academicAdministration.executionCourseManagement.MergeExecutionCourseDA;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.BiDirectionalConverter;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class SourceExecutionCoursesProvider
implements DataProvider {
    public Converter getConverter() {
        return new BiDirectionalConverter(){

            public Object convert(Class type, Object value) {
                ExecutionCourseBean result = new ExecutionCourseBean();
                result.setSourceExecutionCourse((ExecutionCourse)((Object)new DomainObjectKeyConverter().convert(type, value)));
                return result;
            }

            public String deserialize(Object object) {
                ExecutionCourseBean bean;
                String result = "";
                if (object != null && object instanceof ExecutionCourseBean && (bean = (ExecutionCourseBean)object).getSourceExecutionCourse() != null) {
                    result = bean.getSourceExecutionCourse().toString();
                }
                return result;
            }
        };
    }

    public Object provide(Object source, Object currentValue) {
        LinkedList result = Lists.newLinkedList();
        MergeExecutionCourseDA.DegreesMergeBean bean = (MergeExecutionCourseDA.DegreesMergeBean)source;
        Degree degree = bean.getSourceDegree();
        for (ExecutionCourse iter : SourceExecutionCoursesProvider.getExecutionCourses(degree, bean.getAcademicInterval())) {
            ExecutionCourseBean resultBean = new ExecutionCourseBean();
            resultBean.setDegree(degree);
            resultBean.setSourceExecutionCourse(iter);
            result.add(resultBean);
        }
        return result;
    }

    protected static Set<ExecutionCourse> getExecutionCourses(Degree degree, AcademicInterval academicInterval) {
        TreeSet result = Sets.newTreeSet(ExecutionCourse.EXECUTION_COURSE_NAME_COMPARATOR);
        result.addAll(degree.getExecutionCourses(academicInterval));
        return result;
    }
}

