/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.providers;

import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.dto.student.IStudentCurricularPlanBean;
import org.joda.time.LocalDate;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class ExecutionPeriodsForCandidacyRegistrationProvider
implements DataProvider {
    public Object provide(Object source, Object currentValue) {
        StudentCurricularPlan studentCurricularPlan = ((IStudentCurricularPlanBean)source).getStudentCurricularPlan();
        List<ExecutionSemester> executionPeriodsInTimePeriod = ExecutionSemester.readExecutionPeriodsInTimePeriod(studentCurricularPlan.getStartDateYearMonthDay().toLocalDate(), this.getEndDate());
        Collections.sort(executionPeriodsInTimePeriod, new ReverseComparator(ExecutionSemester.COMPARATOR_BY_SEMESTER_AND_YEAR));
        return executionPeriodsInTimePeriod;
    }

    private LocalDate getEndDate() {
        ExecutionYear currentExecutionYear = ExecutionYear.readCurrentExecutionYear();
        if (currentExecutionYear.hasNextExecutionYear() && currentExecutionYear.getNextExecutionYear().isOpen()) {
            return currentExecutionYear.getNextExecutionYear().getLastExecutionPeriod().getEndDateYearMonthDay().toLocalDate();
        }
        return currentExecutionYear.getLastExecutionPeriod().getEndDateYearMonthDay().toLocalDate();
    }

    public Converter getConverter() {
        return new DomainObjectKeyConverter();
    }
}

