/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.components;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.fenixedu.academic.ui.faces.components.util.JsfRenderUtils;

public class UICommandLink
extends HtmlCommandLink {
    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        JsfRenderUtils.addEventHandlingHiddenFieldsIfNotExists(context, (UIComponent)this);
        List<UIParameter> uiParameters = this.getParametersWithNameAttribute();
        JsfRenderUtils.addHiddenFieldsForParametersIfNotExists(context, (UIComponent)this, uiParameters);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", (UIComponent)this);
        writer.writeAttribute("type", (Object)(this.getType() != null ? this.getType() : ""), null);
        writer.writeAttribute("title", (Object)(this.getTitle() != null ? this.getTitle() : ""), null);
        if (this.getTarget() != null) {
            writer.writeAttribute("target", (Object)this.getTarget(), null);
        }
        writer.writeAttribute("onclick", (Object)this.getOnClickEvent(context, uiParameters), null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("id", (Object)this.getClientId(context), null);
        writer.writeAttribute("name", (Object)this.getClientId(context), null);
        writer.writeAttribute("style", (Object)(this.getStyle() != null ? this.getStyle() : ""), null);
        writer.writeAttribute("class", (Object)(this.getStyleClass() != null ? this.getStyleClass() : ""), null);
        writer.writeText(this.getValue(), null);
    }

    private String getOnClickEvent(FacesContext context, List<UIParameter> uiParameters) {
        StringBuilder onClickEvent = new StringBuilder();
        if (this.getOnclick() != null) {
            onClickEvent.append(this.getOnclick()).append(";");
        }
        onClickEvent.append(JsfRenderUtils.getSubmitJavaScriptWithParameters(context, (UIComponent)this, uiParameters));
        return onClickEvent.toString();
    }

    public void encodeEnd(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("a");
    }

    public void decode(FacesContext context) {
        UIForm parentForm;
        String parentFormClientId;
        String eventSenderHiddenFieldId;
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String eventSenderId = (String)paramMap.get(eventSenderHiddenFieldId = JsfRenderUtils.getEventSenderHiddenFieldId(parentFormClientId = (parentForm = JsfRenderUtils.findForm((UIComponent)this)).getClientId(context)));
        if (eventSenderId != null && eventSenderId.equals(this.getClientId(context))) {
            this.queueEvent((FacesEvent)new ActionEvent((UIComponent)this));
        }
    }

    private List<UIParameter> getParametersWithNameAttribute() {
        ArrayList<UIParameter> result = new ArrayList<UIParameter>();
        List children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            UIParameter parameter;
            UIComponent child = (UIComponent)children.get(i);
            if (!(child instanceof UIParameter) || (parameter = (UIParameter)child).getName() == null) continue;
            result.add(parameter);
        }
        return result;
    }
}

