/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.task;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.PhotoState;
import org.fenixedu.academic.domain.PhotoType;
import org.fenixedu.academic.domain.Photograph;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacy;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFile;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFileType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.photograph.Picture;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.util.ContentType;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.scheduler.CronTask;
import org.fenixedu.bennu.scheduler.annotation.Task;

@Task(englishTitle="SetStudentPhotosFromCandidacies", readOnly=false)
public class SetStudentPhotosFromCandidacies
extends CronTask {
    public void runTask() throws Exception {
        int missing = 0;
        int withContent = 0;
        int withContentType = 0;
        int unableToProcessImage = 0;
        int fixed = 0;
        for (IndividualCandidacy candidacy : Bennu.getInstance().getIndividualCandidaciesSet()) {
            for (IndividualCandidacyDocumentFile file : candidacy.getDocumentsSet()) {
                Person person;
                Photograph personalPhotoEvenIfPending;
                Registration registration;
                IndividualCandidacyDocumentFileType type = file.getCandidacyFileType();
                if (type != IndividualCandidacyDocumentFileType.PHOTO || (registration = candidacy.getRegistration()) == null || (personalPhotoEvenIfPending = (person = registration.getPerson()).getPersonalPhotoEvenIfPending()) != null) continue;
                ++missing;
                byte[] content = file.getContent();
                if (content == null || content.length <= 0) continue;
                ++withContent;
                ContentType contentType = ContentType.getContentType(file.getContentType());
                if (contentType == null) continue;
                ++withContentType;
                if (this.chew(content)) {
                    Photograph p = new Photograph(PhotoType.INSTITUTIONAL, contentType, content);
                    p.setState(PhotoState.APPROVED);
                    person.setPersonalPhoto(p);
                    ++fixed;
                    continue;
                }
                ++unableToProcessImage;
            }
        }
        this.taskLog("Missing: %s photos.%n", new Object[]{Integer.toString(missing)});
        this.taskLog("Possible Content Fix: %s.%n", new Object[]{Integer.toString(withContent)});
        this.taskLog("Valid Content Type Fix: %s.%n", new Object[]{Integer.toString(withContentType)});
        this.taskLog("Unable to chew: %s.%n", new Object[]{Integer.toString(unableToProcessImage)});
        this.taskLog("Fixed: %s photos.%n", new Object[]{Integer.toString(fixed)});
    }

    private boolean chew(byte[] content) {
        try {
            Picture.readImage(content);
            return true;
        }
        catch (DomainException ex) {
            return false;
        }
    }
}

