/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.alumni.publicAccess;

import java.io.Serializable;
import org.fenixedu.academic.domain.Alumni;
import org.fenixedu.academic.domain.Job;
import org.fenixedu.academic.domain.contacts.EmailAddress;
import org.fenixedu.academic.domain.contacts.PartyContact;
import org.fenixedu.academic.domain.contacts.Phone;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.dto.alumni.AlumniAddressBean;
import org.fenixedu.academic.dto.alumni.AlumniJobBean;

public class AlumniPublicAccessBean
implements Serializable {
    private Alumni alumni;
    private String phone;
    private Phone currentPhone;
    private String email;
    private EmailAddress currentEmail;
    private AlumniAddressBean addressBean;
    private PhysicalAddress currentAddress;
    private AlumniJobBean jobBean;
    private Job currentJob;

    public AlumniPublicAccessBean(Alumni alumni) {
        this.setAlumni(alumni);
        this.initEmail(alumni);
        this.initPhone(alumni);
        this.initAddress(alumni);
        this.initJob(alumni);
    }

    private void initPhone(Alumni alumni) {
        PartyContact phone = alumni.getUpdatablePartyContact(Phone.class);
        if (phone != null) {
            this.setCurrentPhone((Phone)((Object)phone));
            this.setPhone(((Phone)((Object)phone)).getNumber());
        }
    }

    private void initEmail(Alumni alumni) {
        PartyContact email = alumni.getUpdatablePartyContact(EmailAddress.class);
        if (email != null) {
            this.setCurrentEmail((EmailAddress)((Object)email));
            this.setEmail(((EmailAddress)((Object)email)).getValue());
        }
    }

    private void initAddress(Alumni alumni) {
        PartyContact address = alumni.getUpdatablePartyContact(PhysicalAddress.class);
        if (address != null) {
            this.setCurrentPhysicalAddress((PhysicalAddress)((Object)address));
            this.setAddressBean(new AlumniAddressBean(alumni, (PhysicalAddress)((Object)address)));
        } else {
            this.setAddressBean(new AlumniAddressBean(alumni));
        }
    }

    private void initJob(Alumni alumni) {
        if (alumni.hasAnyJobs().booleanValue()) {
            Job job = alumni.getLastJob();
            this.setCurrentJob(job);
            this.setJobBean(new AlumniJobBean(alumni, job));
        } else {
            this.setJobBean(new AlumniJobBean(alumni));
        }
    }

    public Alumni getAlumni() {
        return this.alumni;
    }

    public void setAlumni(Alumni alumni) {
        this.alumni = alumni;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public AlumniAddressBean getAddressBean() {
        return this.addressBean;
    }

    public void setAddressBean(AlumniAddressBean alumniAddressBean) {
        this.addressBean = alumniAddressBean;
    }

    public AlumniJobBean getJobBean() {
        return this.jobBean;
    }

    public void setJobBean(AlumniJobBean alumniJobBean) {
        this.jobBean = alumniJobBean;
    }

    public Phone getCurrentPhone() {
        return this.currentPhone;
    }

    private void setCurrentPhone(Phone phone) {
        this.currentPhone = phone;
    }

    public EmailAddress getCurrentEmail() {
        return this.currentEmail;
    }

    private void setCurrentEmail(EmailAddress email) {
        this.currentEmail = email;
    }

    public PhysicalAddress getCurrentPhysicalAddress() {
        return this.currentAddress;
    }

    private void setCurrentPhysicalAddress(PhysicalAddress address) {
        this.currentAddress = address;
    }

    public Job getCurrentJob() {
        return this.currentJob;
    }

    private void setCurrentJob(Job job) {
        this.currentJob = job;
    }
}

