/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import java.util.Date;
import java.util.List;
import org.fenixedu.academic.domain.GratuitySituation;
import org.fenixedu.academic.domain.gratuity.ExemptionGratuityType;
import org.fenixedu.academic.domain.gratuity.GratuitySituationType;
import org.fenixedu.academic.dto.InfoGratuityValues;
import org.fenixedu.academic.dto.InfoObject;
import org.fenixedu.academic.dto.InfoStudentCurricularPlan;
import pt.ist.fenixframework.DomainObject;

public class InfoGratuitySituation
extends InfoObject {
    private Integer exemptionPercentage;
    private Double exemptionValue;
    private ExemptionGratuityType exemptionType;
    private String exemptionDescription;
    private InfoGratuityValues infoGratuityValues;
    private InfoStudentCurricularPlan infoStudentCurricularPlan;
    private Date when;
    private List transactionList;
    private Double payedValue;
    private Double remainingValue;
    private Double totalValue;
    private GratuitySituationType situationType;
    private String insurancePayed = "label.notPayed";

    public String getInsurancePayed() {
        return this.insurancePayed;
    }

    public void setInsurancePayed(String insurancePayed) {
        this.insurancePayed = insurancePayed;
    }

    public GratuitySituationType getSituationType() {
        return this.situationType;
    }

    public void setSituationType(GratuitySituationType situationType) {
        this.situationType = situationType;
    }

    public Date getWhen() {
        return this.when;
    }

    public void setWhen(Date when) {
        this.when = when;
    }

    public String getExemptionDescription() {
        return this.exemptionDescription;
    }

    public void setExemptionDescription(String exemptionDescription) {
        this.exemptionDescription = exemptionDescription;
    }

    public Integer getExemptionPercentage() {
        return this.exemptionPercentage;
    }

    public void setExemptionPercentage(Integer exemptionPercentage) {
        this.exemptionPercentage = exemptionPercentage;
    }

    public ExemptionGratuityType getExemptionType() {
        return this.exemptionType;
    }

    public void setExemptionType(ExemptionGratuityType exemptionType) {
        this.exemptionType = exemptionType;
    }

    public InfoGratuityValues getInfoGratuityValues() {
        return this.infoGratuityValues;
    }

    public void setInfoGratuityValues(InfoGratuityValues gratuity) {
        this.infoGratuityValues = gratuity;
    }

    public Double getPayedValue() {
        return this.payedValue;
    }

    public void setPayedValue(Double payedValue) {
        this.payedValue = payedValue;
    }

    public Double getRemainingValue() {
        return this.remainingValue;
    }

    public void setRemainingValue(Double remainingValue) {
        this.remainingValue = remainingValue;
    }

    public InfoStudentCurricularPlan getInfoStudentCurricularPlan() {
        return this.infoStudentCurricularPlan;
    }

    public void setInfoStudentCurricularPlan(InfoStudentCurricularPlan studentCurricularPlan) {
        this.infoStudentCurricularPlan = studentCurricularPlan;
    }

    public List getTransactionList() {
        return this.transactionList;
    }

    public void setTransactionList(List transactionList) {
        this.transactionList = transactionList;
    }

    public Double getExemptionValue() {
        return this.exemptionValue;
    }

    public void setExemptionValue(Double exemptionValue) {
        this.exemptionValue = exemptionValue;
    }

    public String toString() {
        String result = new String();
        result = result + "[InfoGratuitySituation: exemptionPercentage" + this.exemptionPercentage;
        result = result + "\nexemptionType: " + (Object)((Object)this.exemptionType);
        result = result + "\nexemptionDescription: " + this.exemptionDescription;
        result = result + "\npayedValue: " + this.payedValue;
        result = result + "\nremainingValue: " + this.remainingValue;
        result = result + "\ninfoGratuityValues: " + this.infoGratuityValues;
        result = result + "\ninfoStudentCurricularPlan: " + this.infoStudentCurricularPlan;
        return result;
    }

    public void copyFromDomain(GratuitySituation gratuitySituation) {
        super.copyFromDomain((DomainObject)gratuitySituation);
        if (gratuitySituation != null) {
            this.setExemptionPercentage(gratuitySituation.getExemptionPercentage());
            this.setExemptionValue(gratuitySituation.getExemptionValue());
            this.setExemptionDescription(gratuitySituation.getExemptionDescription());
            this.setExemptionType(gratuitySituation.getExemptionType());
            if (gratuitySituation.getRemainingValue() == null) {
                this.setRemainingValue(new Double(0.0));
            } else {
                this.setRemainingValue(gratuitySituation.getRemainingValue());
            }
            this.setWhen(gratuitySituation.getWhen());
        }
    }

    public static InfoGratuitySituation newInfoFromDomain(GratuitySituation gratuitySituation) {
        InfoGratuitySituation infoGratuitySituation = null;
        if (gratuitySituation != null) {
            infoGratuitySituation = new InfoGratuitySituation();
            infoGratuitySituation.copyFromDomain(gratuitySituation);
        }
        return infoGratuitySituation;
    }
}

