/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.util.email;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.DomainObjectUtil;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.contacts.EmailAddress;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Recipient$callable$delete;
import org.fenixedu.academic.domain.util.email.Recipient$callable$initToName;
import org.fenixedu.academic.domain.util.email.Recipient$callable$newInstance;
import org.fenixedu.academic.domain.util.email.Recipient$callable$newInstance$1;
import org.fenixedu.academic.domain.util.email.Recipient$callable$newInstance$2;
import org.fenixedu.academic.domain.util.email.Recipient_Base;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.groups.UserGroup;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class Recipient
extends Recipient_Base {
    public static final Comparator<Recipient> COMPARATOR_BY_NAME;
    public static final Advice advice$delete;
    public static final Advice advice$initToName;
    public static final Advice advice$newInstance;
    public static final Advice advice$newInstance$1;
    public static final Advice advice$newInstance$2;

    public Recipient() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    public Recipient(Group group) {
        this(group.getPresentationName(), group);
    }

    public Recipient(Collection<Person> persons) {
        this(UserGroup.of(Person.convertToUsers(persons)));
    }

    public Recipient(String toName, Group members) {
        this();
        this.setToName(toName);
        this.setMembers(members);
    }

    public Group getMembers() {
        return this.getMembersGroup().toGroup();
    }

    public void setMembers(Group members) {
        this.setMembersGroup(members.toPersistentGroup());
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new Recipient$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(Recipient this_) {
        for (Sender sender : this_.getSendersSet()) {
            this_.removeSenders(sender);
        }
        for (Message message : this_.getMessagesSet()) {
            if (message.getRootDomainObjectFromPendingRelation() != null) continue;
            message.delete();
        }
        for (Message message : this_.getMessagesCcsSet()) {
            if (message.getRootDomainObjectFromPendingRelation() != null) continue;
            message.delete();
        }
        for (Message message : this_.getMessagesTosSet()) {
            if (message.getRootDomainObjectFromPendingRelation() != null) continue;
            message.delete();
        }
        this_.setRootDomainObject(null);
        this_.deleteDomainObject();
    }

    public void addDestinationEmailAddresses(Set<String> emailAddresses) {
        for (User user : this.getMembers().getMembers()) {
            String value;
            EmailAddress emailAddress = user.getPerson().getEmailAddressForSendingEmails();
            if (emailAddress == null || (value = emailAddress.getValue()) == null || value.isEmpty()) continue;
            emailAddresses.add(value);
        }
    }

    public String getToName() {
        if (super.getToName() == null) {
            this.initToName();
        }
        return super.getToName();
    }

    private void initToName() {
        Object object = advice$initToName.perform((Callable)new Recipient$callable$initToName(this));
    }

    static /* synthetic */ void advised$initToName(Recipient this_) {
        this_.setToName(this_.getMembers().getPresentationName());
    }

    public void setToName(String toName) {
        super.setToName(toName);
    }

    public static Recipient newInstance(String string, Group group) {
        return (Recipient)((Object)advice$newInstance.perform((Callable)new Recipient$callable$newInstance(string, group)));
    }

    static /* synthetic */ Recipient advised$newInstance(String toName, Group members) {
        return new Recipient(toName, members);
    }

    public static Recipient newInstance(Group group) {
        return (Recipient)((Object)advice$newInstance$1.perform((Callable)new Recipient$callable$newInstance$1(group)));
    }

    static /* synthetic */ Recipient advised$newInstance(Group group) {
        return new Recipient(group);
    }

    public static List<Recipient> newInstance(List<? extends Group> list) {
        return (List)advice$newInstance$2.perform((Callable)new Recipient$callable$newInstance$2(list));
    }

    static /* synthetic */ List<Recipient> advised$newInstance(List<? extends Group> groups) {
        ArrayList<Recipient> recipients = new ArrayList<Recipient>();
        for (Group group : groups) {
            recipients.add(new Recipient(group));
        }
        return recipients;
    }

    public static Set<Recipient> newInstance(Set<? extends Group> groups) {
        HashSet<Recipient> recipients = new HashSet<Recipient>();
        for (Group group : groups) {
            recipients.add(new Recipient(group));
        }
        return recipients;
    }

    public static Recipient getRecipientFromGroup(Group group) {
        return group.toPersistentGroup().getRecipientAsMembersSet().stream().findAny().orElseGet(() -> Recipient.newInstance(group));
    }

    public Collection<Recipient> asCollection() {
        return Collections.singletonList(this);
    }

    public String getMembersEmailInText() {
        if (this.getMembers() == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        Group membersGroup = this.getMembers();
        Set elements = membersGroup.getMembers();
        for (User user : elements) {
            builder.append(user.getPerson().getName()).append(" (").append(user.getPerson().getEmailForSendingEmails()).append(")").append("\n");
        }
        return builder.toString();
    }

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        advice$initToName = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$newInstance = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$newInstance$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$newInstance$2 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_NAME = new Comparator<Recipient>(){

            @Override
            public int compare(Recipient r1, Recipient r2) {
                int c = r1.getToName().compareTo(r2.getToName());
                return c == 0 ? DomainObjectUtil.COMPARATOR_BY_ID.compare((DomainObject)r1, (DomainObject)r2) : c;
            }
        };
    }
}

