/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import java.util.Collection;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.Exam;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.ExamDateCertificateRequest_Base;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;
import org.fenixedu.academic.util.Season;

public class ExamDateCertificateRequest
extends ExamDateCertificateRequest_Base {
    protected ExamDateCertificateRequest() {
    }

    public ExamDateCertificateRequest(DocumentRequestCreateBean bean) {
        this();
        super.init(bean);
        this.checkParameters(bean);
        this.checkRulesToCreate(bean);
        super.getEnrolmentsSet().addAll(bean.getEnrolments());
        super.getExamsSet().addAll(bean.getExams());
        super.setExecutionPeriod(bean.getExecutionPeriod());
    }

    private void checkRulesToCreate(DocumentRequestCreateBean bean) {
        for (Exam exam : bean.getExams()) {
            if (!exam.isForSeason(Season.SPECIAL_SEASON_OBJ) || this.getEnrolmentFor(bean.getEnrolments(), exam).hasSpecialSeasonInExecutionYear(bean.getExecutionPeriod().getExecutionYear())) continue;
            throw new DomainExceptionWithLabelFormatter("error.serviceRequests.documentRequests.ExamDateCertificateRequest.special.season.exam.requires.student.to.be.enroled", exam.getSeason().getDescription());
        }
    }

    private Enrolment getEnrolmentFor(Collection<Enrolment> enrolments, Exam exam) {
        for (Enrolment enrolment : enrolments) {
            if (!exam.contains(enrolment.getCurricularCourse())) continue;
            return enrolment;
        }
        throw new DomainException("error.serviceRequests.documentRequests.ExamDateCertificateRequest.each.exam.must.belong.to.at.least.one.enrolment", new String[0]);
    }

    protected void checkParameters(DocumentRequestCreateBean bean) {
        if (bean.getExecutionYear() == null) {
            throw new DomainException("error.serviceRequests.documentRequests.ExamDateCertificateRequest.executionYear.cannot.be.null", new String[0]);
        }
        if (bean.getEnrolments() == null || bean.getEnrolments().isEmpty()) {
            throw new DomainException("error.serviceRequests.documentRequests.ExamDateCertificateRequest.enrolments.cannot.be.null.and.must.have.size.greater.than.zero", new String[0]);
        }
        if (bean.getExecutionPeriod() == null) {
            throw new DomainException("error.org.fenixedu.academic.domain.serviceRequests.documentRequests.ExamDateCertificateRequest.executionPeriod.cannot.be.null", new String[0]);
        }
    }

    public Integer getNumberOfUnits() {
        return 0;
    }

    public DocumentRequestType getDocumentRequestType() {
        return DocumentRequestType.EXAM_DATE_CERTIFICATE;
    }

    public String getDocumentTemplateKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public EventType getEventType() {
        return EventType.EXAM_DATE_CERTIFICATE_REQUEST;
    }

    public Exam getExamFor(Enrolment enrolment, Season season) {
        for (Exam exam : this.getExamsSet()) {
            if (!exam.contains(enrolment.getCurricularCourse()) || !exam.isForSeason(season)) continue;
            return exam;
        }
        return null;
    }

    public boolean isFree() {
        return this.getRegistration().getRegistrationProtocol().isMilitaryAgreement() || super.isFree();
    }
}

