/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests;

import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.EquivalencePlanRequest_Base;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.AcademicServiceRequestType;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.dto.serviceRequests.RegistrationAcademicServiceRequestCreateBean;

public class EquivalencePlanRequest
extends EquivalencePlanRequest_Base {
    private static final String COURSE_LABEL = "Nome da disciplina do curr\u00edculo de Bolonha";
    private static final String COURSE_ECTS = "ECTS";
    private static final String EQUIVALENT_COURSE_LABEL = "Nome da(s) disciplina(s) considerada(s) equivalente(s)";
    private static final String GRADE_LABEL = "Classifica\u00e7\u00e3o";
    private static final String GRADE_SCALE = "Escala";
    private static final String MEC2006 = "MEC 2006";

    protected EquivalencePlanRequest() {
    }

    public EquivalencePlanRequest(RegistrationAcademicServiceRequestCreateBean bean) {
        this();
        super.init(bean);
        this.checkParameters(bean);
        this.setNumberOfEquivalences(bean.getNumberOfEquivalences());
        this.setNumberOfUnits(bean.getNumberOfEquivalences());
    }

    private void checkParameters(RegistrationAcademicServiceRequestCreateBean bean) {
        if (bean.getExecutionYear() == null) {
            throw new DomainException("error.EquivalencePlanRequest.executionYear.cannot.be.null", new String[0]);
        }
    }

    protected void checkRegistrationStartDate(RegistrationAcademicServiceRequestCreateBean bean) {
    }

    public AcademicServiceRequestType getAcademicServiceRequestType() {
        return AcademicServiceRequestType.EQUIVALENCE_PLAN;
    }

    public EventType getEventType() {
        return EventType.EQUIVALENCE_PLAN_REQUEST;
    }

    protected void createAcademicServiceRequestSituations(AcademicServiceRequestBean academicServiceRequestBean) {
        super.createAcademicServiceRequestSituations(academicServiceRequestBean);
    }

    protected void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        if (academicServiceRequestBean.isToProcess()) {
            academicServiceRequestBean.setSituationDate(this.getActiveSituation().getSituationDate().toYearMonthDay());
        }
    }

    protected void checkRulesToDelete() {
        if (!this.getEquivalencePlanRevisionRequestsSet().isEmpty()) {
            throw new DomainException("error.AcademicServiceRequest.cannot.be.deleted", new String[0]);
        }
    }

    public boolean isToPrint() {
        return false;
    }

    public boolean isPossibleToSendToOtherEntity() {
        return true;
    }

    public boolean isManagedWithRectorateSubmissionBatch() {
        return false;
    }

    public boolean isAvailableForTransitedRegistrations() {
        return true;
    }

    public boolean isPayedUponCreation() {
        return false;
    }

    public boolean hasPersonalInfo() {
        return false;
    }
}

