/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.individualProcess.activities;

import org.fenixedu.academic.domain.caseHandling.PreConditionNotValidException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessBean;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcessState;
import org.fenixedu.academic.domain.phd.PhdProgramProcessState;
import org.fenixedu.academic.domain.phd.individualProcess.activities.PhdIndividualProgramProcessActivity;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationState;
import org.fenixedu.academic.domain.student.registrationStates.RegistrationStateType;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;

public class SuspendPhdProgramProcess
extends PhdIndividualProgramProcessActivity {
    @Override
    protected void processPreConditions(PhdIndividualProgramProcess process2, User userView) {
    }

    @Override
    public void activityPreConditions(PhdIndividualProgramProcess process2, User userView) {
        if (!process2.isAllowedToManageProcessState(userView)) {
            throw new PreConditionNotValidException();
        }
    }

    @Override
    protected PhdIndividualProgramProcess executeActivity(PhdIndividualProgramProcess process2, User userView, Object object) {
        PhdIndividualProgramProcessBean bean = (PhdIndividualProgramProcessBean)object;
        DateTime stateDate = bean.getStateDate().toDateTimeAtStartOfDay();
        PhdProgramProcessState.createWithGivenStateDate(process2, PhdIndividualProgramProcessState.SUSPENDED, userView.getPerson(), "", stateDate);
        process2.cancelDebts(userView.getPerson());
        if (process2.getRegistration() != null && process2.getRegistration().isActive()) {
            RegistrationState.createRegistrationState(process2.getRegistration(), userView.getPerson(), stateDate, RegistrationStateType.INTERRUPTED);
        }
        return process2;
    }
}

