/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.function.Supplier;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.I18N;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CurricularRuleExecutor {
    private static final Logger logger = LoggerFactory.getLogger(CurricularRuleExecutor.class);
    private CurricularRuleExecutorLogic logic;
    private static Supplier<CurricularRuleApprovalExecutor> CURRICULAR_RULE_APPROVAL_EXECUTOR = () -> new CurricularRuleApprovalExecutor(){

        @Override
        public boolean isApproved(EnrolmentContext enrolmentContext, CurricularCourse curricularCourse) {
            return enrolmentContext.getStudentCurricularPlan().isApproved(curricularCourse);
        }

        @Override
        public boolean isApproved(EnrolmentContext enrolmentContext, CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
            return enrolmentContext.getStudentCurricularPlan().isApproved(curricularCourse, executionSemester);
        }
    };

    protected CurricularRuleExecutorLogic getLogic() {
        if (this.logic == null) {
            throw new DomainException("curricularRules.ruleExecutors.logic.unavailable", BundleUtil.getString((String)"resources.BolonhaManagerResources", (Locale)I18N.getLocale(), (String)"label.enrolmentPeriodRestrictions", (String[])new String[0]));
        }
        return this.logic;
    }

    protected void setLogic(CurricularRuleExecutorLogic input) {
        if (input == null) {
            throw new DomainException("curricularRules.ruleExecutors.logic.unavailable", BundleUtil.getString((String)"resources.BolonhaManagerResources", (Locale)I18N.getLocale(), (String)"label.enrolmentPeriodRestrictions", (String[])new String[0]));
        }
        this.logic = input;
    }

    public RuleResult execute(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        if (!this.canBeEvaluated(curricularRule, sourceDegreeModuleToEvaluate, enrolmentContext)) {
            return RuleResult.createNA(sourceDegreeModuleToEvaluate.getDegreeModule());
        }
        switch (enrolmentContext.getCurricularRuleLevel()) {
            case ENROLMENT_WITH_RULES: {
                return this.executeEnrolmentWithRules(curricularRule, sourceDegreeModuleToEvaluate, enrolmentContext);
            }
            case ENROLMENT_VERIFICATION_WITH_RULES: {
                return this.executeEnrolmentVerificationWithRules(curricularRule, sourceDegreeModuleToEvaluate, enrolmentContext);
            }
            case ENROLMENT_WITH_RULES_AND_TEMPORARY_ENROLMENT: {
                return this.executeEnrolmentWithRulesAndTemporaryEnrolment(curricularRule, sourceDegreeModuleToEvaluate, enrolmentContext);
            }
            case ENROLMENT_NO_RULES: {
                return this.executeEnrolmentWithNoRules(curricularRule, sourceDegreeModuleToEvaluate, enrolmentContext);
            }
            case IMPROVEMENT_ENROLMENT: 
            case SPECIAL_SEASON_ENROLMENT: {
                return this.executeEnrolmentInEnrolmentEvaluation(curricularRule, sourceDegreeModuleToEvaluate, enrolmentContext);
            }
        }
        throw new DomainException("error.curricularRules.RuleExecutor.unimplemented.rule.level", new String[0]);
    }

    private RuleResult executeEnrolmentWithRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        RuleResult result = this.executeEnrolmentVerificationWithRules(curricularRule, sourceDegreeModuleToEvaluate, enrolmentContext);
        if (result.hasAnyImpossibleEnrolment()) {
            return RuleResult.createFalse(sourceDegreeModuleToEvaluate.getDegreeModule()).and(result);
        }
        return result;
    }

    protected IDegreeModuleToEvaluate searchDegreeModuleToEvaluate(EnrolmentContext enrolmentContext, DegreeModule degreeModule) {
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : enrolmentContext.getDegreeModulesToEvaluate()) {
            if (!degreeModuleToEvaluate.isFor(degreeModule)) continue;
            return degreeModuleToEvaluate;
        }
        return null;
    }

    protected IDegreeModuleToEvaluate searchDegreeModuleToEvaluate(EnrolmentContext enrolmentContext, ICurricularRule curricularRule) {
        return this.searchDegreeModuleToEvaluate(enrolmentContext, curricularRule.getDegreeModuleToApplyRule());
    }

    protected Collection<IDegreeModuleToEvaluate> collectDegreeModuleToEnrolFromCourseGroup(EnrolmentContext enrolmentContext, CourseGroup courseGroup) {
        ArrayList<IDegreeModuleToEvaluate> result = new ArrayList<IDegreeModuleToEvaluate>();
        for (IDegreeModuleToEvaluate degreeModuleToEvaluate : enrolmentContext.getDegreeModulesToEvaluate()) {
            if (degreeModuleToEvaluate.isEnroled() || degreeModuleToEvaluate.getContext().getParentCourseGroup() != courseGroup) continue;
            result.add(degreeModuleToEvaluate);
        }
        return result;
    }

    protected boolean canApplyRule(EnrolmentContext enrolmentContext, ICurricularRule curricularRule) {
        if (curricularRule.getDegreeModuleToApplyRule().isRoot()) {
            return true;
        }
        return curricularRule.appliesToContext(this.searchDegreeModuleToEvaluate(enrolmentContext, curricularRule).getContext());
    }

    protected CurriculumModule searchCurriculumModule(EnrolmentContext enrolmentContext, DegreeModule degreeModule) {
        if (degreeModule.isLeaf()) {
            return enrolmentContext.getStudentCurricularPlan().findEnrolmentFor((CurricularCourse)((Object)degreeModule), enrolmentContext.getExecutionPeriod());
        }
        return enrolmentContext.getStudentCurricularPlan().findCurriculumGroupFor((CourseGroup)((Object)degreeModule));
    }

    protected CurriculumModule searchCurriculumModule(EnrolmentContext enrolmentContext, ICurricularRule curricularRule) {
        return this.searchCurriculumModule(enrolmentContext, curricularRule.getDegreeModuleToApplyRule());
    }

    public static CurricularRuleApprovalExecutor getCurricularRuleApprovalExecutor() {
        return CURRICULAR_RULE_APPROVAL_EXECUTOR.get();
    }

    public static void setCurricularRuleApprovalExecutor(Supplier<CurricularRuleApprovalExecutor> input) {
        if (input != null && input.get() != null) {
            CURRICULAR_RULE_APPROVAL_EXECUTOR = input;
        } else {
            logger.error("Could not set CURRICULAR_RULE_APPROVAL_EXECUTOR to null");
        }
    }

    protected boolean isApproved(EnrolmentContext enrolmentContext, CurricularCourse curricularCourse) {
        return CurricularRuleExecutor.getCurricularRuleApprovalExecutor().isApproved(enrolmentContext, curricularCourse);
    }

    protected boolean isApproved(EnrolmentContext enrolmentContext, CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        return CurricularRuleExecutor.getCurricularRuleApprovalExecutor().isApproved(enrolmentContext, curricularCourse, executionSemester);
    }

    protected boolean isEnroled(EnrolmentContext enrolmentContext, DegreeModule degreeModule) {
        return degreeModule.isLeaf() ? this.isEnroled(enrolmentContext, (CurricularCourse)((Object)degreeModule)) : this.isEnroled(enrolmentContext, (CourseGroup)((Object)degreeModule));
    }

    private boolean isEnroled(EnrolmentContext enrolmentContext, CurricularCourse curricularCourse) {
        for (ExecutionSemester executionSemester : enrolmentContext.getExecutionSemestersToEvaluate()) {
            if (!enrolmentContext.getStudentCurricularPlan().isEnroledInExecutionPeriod(curricularCourse, executionSemester)) continue;
            return true;
        }
        return false;
    }

    private boolean isEnroled(EnrolmentContext enrolmentContext, CourseGroup courseGroup) {
        return enrolmentContext.getStudentCurricularPlan().hasDegreeModule((DegreeModule)((Object)courseGroup));
    }

    protected boolean isEnroled(EnrolmentContext enrolmentContext, CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        return enrolmentContext.getStudentCurricularPlan().isEnroledInExecutionPeriod(curricularCourse, executionSemester);
    }

    protected boolean isEnroled(EnrolmentContext enrolmentContext, CurricularCourse curricularCourse, ExecutionYear executionYear) {
        for (ExecutionSemester executionSemester : executionYear.getExecutionPeriodsSet()) {
            if (!enrolmentContext.getStudentCurricularPlan().isEnroledInExecutionPeriod(curricularCourse, executionSemester)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasEnrolmentWithEnroledState(EnrolmentContext enrolmentContext, CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        return enrolmentContext.getStudentCurricularPlan().getRoot().hasEnrolmentWithEnroledState(curricularCourse, executionSemester);
    }

    protected boolean hasEnrolmentWithEnroledState(EnrolmentContext enrolmentContext, CurricularCourse curricularCourse, ExecutionYear executionYear) {
        for (ExecutionSemester executionSemester : executionYear.getExecutionPeriodsSet()) {
            if (!enrolmentContext.getStudentCurricularPlan().getRoot().hasEnrolmentWithEnroledState(curricularCourse, executionSemester)) continue;
            return true;
        }
        return false;
    }

    protected boolean isEnrolling(EnrolmentContext enrolmentContext, DegreeModule degreeModule) {
        IDegreeModuleToEvaluate degreeModuleToEvaluate = this.searchDegreeModuleToEvaluate(enrolmentContext, degreeModule);
        return degreeModuleToEvaluate != null && !degreeModuleToEvaluate.isEnroled();
    }

    protected boolean isEnrolling(EnrolmentContext enrolmentContext, DegreeModule degreeModule, ExecutionSemester executionPeriod) {
        IDegreeModuleToEvaluate degreeModuleToEvaluate = this.searchDegreeModuleToEvaluate(enrolmentContext, degreeModule);
        return degreeModuleToEvaluate != null && !degreeModuleToEvaluate.isEnroled() && degreeModuleToEvaluate.getExecutionPeriod() == executionPeriod;
    }

    protected RuleResult executeEnrolmentWithNoRules(ICurricularRule curricularRule, IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        RuleResult ruleResult = this.executeEnrolmentWithRulesAndTemporaryEnrolment(curricularRule, sourceDegreeModuleToEvaluate, enrolmentContext);
        if (ruleResult.isFalse() || ruleResult.isTrue() && this.isTemporaryOrImpossible(sourceDegreeModuleToEvaluate, ruleResult)) {
            return RuleResult.createWarning(sourceDegreeModuleToEvaluate.getDegreeModule(), ruleResult.getMessages());
        }
        return ruleResult;
    }

    private boolean isTemporaryOrImpossible(IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, RuleResult ruleResult) {
        return ruleResult.isTemporaryEnrolmentResultType(sourceDegreeModuleToEvaluate.getDegreeModule()) || ruleResult.isImpossibleEnrolmentResultType(sourceDegreeModuleToEvaluate.getDegreeModule());
    }

    protected abstract RuleResult executeEnrolmentWithRulesAndTemporaryEnrolment(ICurricularRule var1, IDegreeModuleToEvaluate var2, EnrolmentContext var3);

    protected abstract RuleResult executeEnrolmentInEnrolmentEvaluation(ICurricularRule var1, IDegreeModuleToEvaluate var2, EnrolmentContext var3);

    protected abstract RuleResult executeEnrolmentVerificationWithRules(ICurricularRule var1, IDegreeModuleToEvaluate var2, EnrolmentContext var3);

    protected abstract boolean canBeEvaluated(ICurricularRule var1, IDegreeModuleToEvaluate var2, EnrolmentContext var3);

    public static interface CurricularRuleApprovalExecutor {
        public boolean isApproved(EnrolmentContext var1, CurricularCourse var2);

        public boolean isApproved(EnrolmentContext var1, CurricularCourse var2, ExecutionSemester var3);
    }

    public static interface CurricularRuleExecutorLogic {
        public RuleResult executeEnrolmentVerificationWithRules(ICurricularRule var1, IDegreeModuleToEvaluate var2, EnrolmentContext var3);
    }
}

