/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.curricularRules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.curricularRules.CompositeRule_Base;
import org.fenixedu.academic.domain.curricularRules.CurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleExecutor;
import org.fenixedu.academic.domain.curricularRules.executors.verifyExecutors.VerifyRuleLevel;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.GenericPair;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public abstract class CompositeRule
extends CompositeRule_Base {
    protected CompositeRule() {
    }

    protected void initCompositeRule(CurricularRule ... curricularRules) {
        if (curricularRules.length < 2) {
            throw new DomainException("curricular.rule.invalid.parameters", new String[0]);
        }
        if (!this.haveAllSameDegreeModule(curricularRules)) {
            throw new DomainException("curricular.rule.invalid.parameters", new String[0]);
        }
        this.setDegreeModuleToApplyRule(curricularRules[0].getDegreeModuleToApplyRule());
        this.setBegin(this.getBeginExecutionPeriod(curricularRules));
        this.setEnd(this.getEndExecutionPeriod(curricularRules));
        for (CurricularRule rule : curricularRules) {
            rule.setDegreeModuleToApplyRule(null);
            rule.setParentCompositeRule(this);
        }
    }

    private ExecutionSemester getEndExecutionPeriod(CurricularRule[] curricularRules) {
        ExecutionSemester executionSemester = null;
        for (CurricularRule rule : curricularRules) {
            if (rule.getEnd() == null) {
                return null;
            }
            if (executionSemester != null && !rule.getEnd().isAfter(executionSemester)) continue;
            executionSemester = rule.getEnd();
        }
        return executionSemester;
    }

    private ExecutionSemester getBeginExecutionPeriod(CurricularRule ... curricularRules) {
        ExecutionSemester executionSemester = null;
        for (CurricularRule rule : curricularRules) {
            if (executionSemester != null && !rule.getBegin().isBefore(executionSemester)) continue;
            executionSemester = rule.getBegin();
        }
        return executionSemester;
    }

    private boolean haveAllSameDegreeModule(CurricularRule ... curricularRules) {
        DegreeModule degreeModule = curricularRules[0].getDegreeModuleToApplyRule();
        for (CurricularRule rule : curricularRules) {
            if (rule.getDegreeModuleToApplyRule().equals((Object)degreeModule)) continue;
            return false;
        }
        return true;
    }

    public abstract List<GenericPair<Object, Boolean>> getLabel();

    public List<GenericPair<Object, Boolean>> getLabel(String operator) {
        ArrayList<GenericPair<Object, Boolean>> labelList = new ArrayList<GenericPair<Object, Boolean>>();
        labelList.add(new GenericPair<String, Boolean>("( ", false));
        Iterator curricularRulesIterator = this.getCurricularRulesSet().iterator();
        while (curricularRulesIterator.hasNext()) {
            labelList.addAll(((CurricularRule)curricularRulesIterator.next()).getLabel());
            if (!curricularRulesIterator.hasNext()) continue;
            labelList.add(new GenericPair<String, Boolean>(" ", false));
            labelList.add(new GenericPair<String, Boolean>(operator, true));
            labelList.add(new GenericPair<String, Boolean>(" ", false));
        }
        labelList.add(new GenericPair<String, Boolean>(" )", false));
        return labelList;
    }

    public RuleResult evaluate(IDegreeModuleToEvaluate sourceDegreeModuleToEvaluate, EnrolmentContext enrolmentContext) {
        throw new DomainException("unsupported.composite.rule", new String[0]);
    }

    public RuleResult verify(VerifyRuleLevel verifyRuleLevel, EnrolmentContext enrolmentContext, DegreeModule degreeModuleToVerify, CourseGroup parentCourseGroup) {
        throw new DomainException("unsupported.composite.rule", new String[0]);
    }

    public VerifyRuleExecutor createVerifyRuleExecutor() {
        throw new DomainException("error.org.fenixedu.academic.domain.curricularRules.CompositeRule.does.not.support.createVerifyRuleExecutor", new String[0]);
    }

    public boolean appliesToContext(Context context) {
        for (CurricularRule curricularRule : this.getCurricularRulesSet()) {
            if (curricularRule.appliesToContext(context)) continue;
            return false;
        }
        return true;
    }

    protected void removeOwnParameters() {
        while (!this.getCurricularRulesSet().isEmpty()) {
            ((CurricularRule)this.getCurricularRulesSet().iterator().next()).delete();
        }
    }

    public boolean isLeaf() {
        return false;
    }

    public boolean isRulePreventingAutomaticEnrolment() {
        for (CurricularRule iter : this.getCurricularRulesSet()) {
            if (!iter.isRulePreventingAutomaticEnrolment()) continue;
            return true;
        }
        return false;
    }

    static {
        CompositeRule.getRelationCurricularRuleCompositeRule().addListener((RelationListener)new RelationAdapter<CompositeRule, CurricularRule>(){

            public void beforeAdd(CompositeRule compositeRule, CurricularRule curricularRule) {
                if (curricularRule.getNotRule() != null) {
                    throw new DomainException("error.curricular.rule.invalid.state", new String[0]);
                }
            }
        });
    }
}

