/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.erasmus.reports;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.QueueJobResult;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFile;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFileType;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyPersonalDetails;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.reports.ErasmusCandidacyProcessReport$callable$create;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.reports.ErasmusCandidacyProcessReport_Base;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityApplicationProcess;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcess;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ErasmusCandidacyProcessReport
extends ErasmusCandidacyProcessReport_Base {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected ErasmusCandidacyProcessReport(MobilityApplicationProcess applicationProcess) {
        String[] args = new String[]{};
        if (applicationProcess == null) {
            throw new DomainException("error.ErasmusCandidacyProcessReport.erasmusCandidacyProcess.null", args);
        }
        this.setMobilityApplicationProcess(applicationProcess);
    }

    public QueueJobResult execute() throws Exception {
        Spreadsheet spreasheet = this.retrieveIndividualProcessesData();
        ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
        spreasheet.exportToXLSSheet((OutputStream)byteArrayOS);
        byteArrayOS.close();
        QueueJobResult queueJobResult = new QueueJobResult();
        queueJobResult.setContentType("application/excel");
        queueJobResult.setContent(byteArrayOS.toByteArray());
        return queueJobResult;
    }

    public IndividualCandidacyDocumentFile getUploadedDocumentByType(Collection<IndividualCandidacyDocumentFile> documentsList, IndividualCandidacyDocumentFileType type) {
        for (IndividualCandidacyDocumentFile document : documentsList) {
            if (!document.getCandidacyFileType().equals((Object)type)) continue;
            return document;
        }
        return null;
    }

    private Spreadsheet retrieveIndividualProcessesData() {
        Spreadsheet spreadsheet = new Spreadsheet("Sheet");
        spreadsheet.setHeaders(new String[]{"N.\u00ba Processo", "IST ID", "Nome", "Data Nascimento", "Nacionalidade", "Universidade", "Programa", "Email", "Curso", "Data de chegada", "Data de partida", "Estado", "Documenta\u00e7\u00e3o Entregue Completa", "Foto", "Fotoc\u00f3pia do Passaporte ou do Cart\u00e3o de Identifica\u00e7\u00e3o", "Acordo", "CV", "Registo Acad\u00e9mico", "N\u00edvel Ingl\u00eas"});
        for (IndividualCandidacyProcess individualCandidacyProcess : this.getMobilityApplicationProcess().getChildProcessesSet()) {
            Boolean photo = false;
            Boolean photocopy = false;
            Boolean agree = false;
            Boolean cv = false;
            Boolean transcript = false;
            Boolean englishLevel = false;
            MobilityIndividualApplicationProcess erasmusIndividualCandidacyProcess = (MobilityIndividualApplicationProcess)((Object)individualCandidacyProcess);
            if (individualCandidacyProcess.isCandidacyCancelled() || individualCandidacyProcess.isCandidacyRejected()) continue;
            IndividualCandidacyPersonalDetails personalDetails = erasmusIndividualCandidacyProcess.getPersonalDetails();
            Spreadsheet.Row row = spreadsheet.addRow();
            row.setCell(0, erasmusIndividualCandidacyProcess.getProcessCode());
            if (personalDetails.getPerson() != null && personalDetails.getPerson().getUsername() != null) {
                row.setCell(1, personalDetails.getPerson().getUsername());
            } else {
                row.setCell(1, "");
            }
            row.setCell(2, erasmusIndividualCandidacyProcess.getPersonalDetails().getName());
            row.setCell(3, personalDetails.getDateOfBirthYearMonthDay() != null ? personalDetails.getDateOfBirthYearMonthDay().toString("dd/MM/yyyy") : "N/A");
            row.setCell(4, erasmusIndividualCandidacyProcess.getPersonalDetails().getCountry().getCountryNationality().getContent());
            row.setCell(5, erasmusIndividualCandidacyProcess.getCandidacy().getMobilityStudentData().getSelectedOpening().getMobilityAgreement().getUniversityUnit().getName());
            row.setCell(6, erasmusIndividualCandidacyProcess.getMobilityProgram().getRegistrationProtocol().getDescription().getContent());
            row.setCell(7, erasmusIndividualCandidacyProcess.getCandidacyHashCode().getEmail());
            row.setCell(8, erasmusIndividualCandidacyProcess.getCandidacy().getSelectedDegree().getNameI18N().getContent());
            row.setCell(9, erasmusIndividualCandidacyProcess.getCandidacy().getMobilityStudentData().getDateOfArrival().toString("dd/MM/yyyy"));
            row.setCell(10, erasmusIndividualCandidacyProcess.getCandidacy().getMobilityStudentData().getDateOfDeparture().toString("dd/MM/yyyy"));
            row.setCell(11, erasmusIndividualCandidacyProcess.getErasmusCandidacyStateDescription());
            if (erasmusIndividualCandidacyProcess.getPhoto() != null) {
                row.setCell(13, "Sim");
                photo = true;
            } else {
                row.setCell(13, "N\u00e3o");
            }
            if (this.getUploadedDocumentByType(erasmusIndividualCandidacyProcess.getCandidacy().getDocumentsSet(), IndividualCandidacyDocumentFileType.DOCUMENT_IDENTIFICATION) != null) {
                row.setCell(14, "Sim");
                photocopy = true;
            } else {
                row.setCell(14, "N\u00e3o");
            }
            if (this.getUploadedDocumentByType(erasmusIndividualCandidacyProcess.getCandidacy().getDocumentsSet(), IndividualCandidacyDocumentFileType.LEARNING_AGREEMENT) != null) {
                row.setCell(15, "Sim");
                agree = true;
            } else {
                row.setCell(15, "N\u00e3o");
            }
            if (this.getUploadedDocumentByType(erasmusIndividualCandidacyProcess.getCandidacy().getDocumentsSet(), IndividualCandidacyDocumentFileType.CV_DOCUMENT) != null) {
                row.setCell(16, "Sim");
                cv = true;
            } else {
                row.setCell(16, "N\u00e3o");
            }
            if (this.getUploadedDocumentByType(erasmusIndividualCandidacyProcess.getCandidacy().getDocumentsSet(), IndividualCandidacyDocumentFileType.TRANSCRIPT_OF_RECORDS) != null) {
                row.setCell(17, "Sim");
                transcript = true;
            } else {
                row.setCell(17, "N\u00e3o");
            }
            if (this.getUploadedDocumentByType(erasmusIndividualCandidacyProcess.getCandidacy().getDocumentsSet(), IndividualCandidacyDocumentFileType.ENGLISH_LEVEL_DECLARATION) != null) {
                row.setCell(18, "Sim");
                englishLevel = true;
            } else {
                row.setCell(18, "N\u00e3o");
            }
            if (photo.booleanValue() && photocopy.booleanValue() && agree.booleanValue() && cv.booleanValue() && transcript.booleanValue() && englishLevel.booleanValue()) {
                row.setCell(12, "Sim");
                continue;
            }
            row.setCell(12, "N\u00e3o");
        }
        return spreadsheet;
    }

    public static ErasmusCandidacyProcessReport create(MobilityApplicationProcess mobilityApplicationProcess) {
        return (ErasmusCandidacyProcessReport)((Object)advice$create.perform((Callable)new ErasmusCandidacyProcessReport$callable$create(mobilityApplicationProcess)));
    }

    static /* synthetic */ ErasmusCandidacyProcessReport advised$create(MobilityApplicationProcess applicationProcess) {
        return new ErasmusCandidacyProcessReport(applicationProcess);
    }

    public String getFilename() {
        return String.format("%s_%s.xls", this.getMobilityApplicationProcess().getDisplayName(), this.getRequestDate().toString("dd_MM_yyyy_hh_mm_ss"));
    }
}

