/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacy.workflow;

import java.util.Set;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.SchoolLevelType;
import org.fenixedu.academic.domain.candidacy.Candidacy;
import org.fenixedu.academic.domain.candidacy.CandidacyOperationType;
import org.fenixedu.academic.domain.candidacy.StudentCandidacy;
import org.fenixedu.academic.domain.candidacy.workflow.CandidacyOperation;
import org.fenixedu.academic.domain.candidacy.workflow.form.ContactsForm;
import org.fenixedu.academic.domain.candidacy.workflow.form.FiliationForm;
import org.fenixedu.academic.domain.candidacy.workflow.form.FillPersonalDataWelcomeForm;
import org.fenixedu.academic.domain.candidacy.workflow.form.HouseholdInformationForm;
import org.fenixedu.academic.domain.candidacy.workflow.form.InquiryAboutYieldingPersonalDataForm;
import org.fenixedu.academic.domain.candidacy.workflow.form.OriginInformationForm;
import org.fenixedu.academic.domain.candidacy.workflow.form.PersonalInformationForm;
import org.fenixedu.academic.domain.candidacy.workflow.form.ResidenceApplianceInquiryForm;
import org.fenixedu.academic.domain.candidacy.workflow.form.ResidenceInformationForm;
import org.fenixedu.academic.domain.contacts.PartyContactType;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.contacts.PhysicalAddressData;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitUtils;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.student.PersonalIngressionData;
import org.fenixedu.academic.domain.student.PrecedentDegreeInformation;

public class FillPersonalDataOperation
extends CandidacyOperation {
    private static final long serialVersionUID = 1L;
    private PersonalInformationForm personalInformationForm;
    private FiliationForm filiationForm;
    private HouseholdInformationForm householdInformationForm;
    private ResidenceInformationForm residenceInformationForm;
    private ContactsForm contactsForm;
    private InquiryAboutYieldingPersonalDataForm inquiryAboutYieldingPersonalDataForm;
    private OriginInformationForm originInformationForm;
    private ResidenceApplianceInquiryForm residenceApplianceInquiryForm;

    public FillPersonalDataOperation(Set<RoleType> roleTypes, StudentCandidacy studentCandidacy) {
        super(roleTypes, (Candidacy)((Object)studentCandidacy));
        this.addForm(new FillPersonalDataWelcomeForm());
        if (this.getPerson().getUser() != null) {
            this.setPersonalInformationForm(PersonalInformationForm.createFromPerson(this.getPerson()));
            this.addForm(this.getPersonalInformationForm());
        }
        this.setFiliationForm(FiliationForm.createFromPerson(this.getPerson()));
        this.addForm(this.getFiliationForm());
        this.setHouseholdInformationForm(new HouseholdInformationForm());
        this.addForm(this.getHouseholdInformationForm());
        this.setResidenceInformationForm(ResidenceInformationForm.createFromPerson(this.getPerson()));
        this.addForm(this.getResidenceInformationForm());
        this.setContactsForm(ContactsForm.createFromPerson(this.getPerson()));
        this.addForm(this.getContactsForm());
        this.setInquiryAboutYieldingPersonalDataForm(new InquiryAboutYieldingPersonalDataForm());
        this.addForm(this.getInquiryAboutYieldingPersonalDataForm());
        this.setOriginInformationForm(OriginInformationForm.createFrom(studentCandidacy));
        this.addForm(this.getOriginInformationForm());
        this.setResidenceApplianceInquiryForm(new ResidenceApplianceInquiryForm());
        this.addForm(this.getResidenceApplianceInquiryForm());
    }

    public StudentCandidacy getStudentCandidacy() {
        return (StudentCandidacy)((Object)this.getCandidacy());
    }

    private Person getPerson() {
        return this.getStudentCandidacy().getPerson();
    }

    public FiliationForm getFiliationForm() {
        return this.filiationForm;
    }

    public void setFiliationForm(FiliationForm filiationForm) {
        this.filiationForm = filiationForm;
    }

    public ContactsForm getContactsForm() {
        return this.contactsForm;
    }

    public void setContactsForm(ContactsForm fillContactsForm) {
        this.contactsForm = fillContactsForm;
    }

    public InquiryAboutYieldingPersonalDataForm getInquiryAboutYieldingPersonalDataForm() {
        return this.inquiryAboutYieldingPersonalDataForm;
    }

    public void setInquiryAboutYieldingPersonalDataForm(InquiryAboutYieldingPersonalDataForm fillInquiryAboutYieldingPersonalDataForm) {
        this.inquiryAboutYieldingPersonalDataForm = fillInquiryAboutYieldingPersonalDataForm;
    }

    public OriginInformationForm getOriginInformationForm() {
        return this.originInformationForm;
    }

    public void setOriginInformationForm(OriginInformationForm fillOriginInformationForm) {
        this.originInformationForm = fillOriginInformationForm;
    }

    public ResidenceInformationForm getResidenceInformationForm() {
        return this.residenceInformationForm;
    }

    public void setResidenceInformationForm(ResidenceInformationForm fillResidenceInformationForm) {
        this.residenceInformationForm = fillResidenceInformationForm;
    }

    public PersonalInformationForm getPersonalInformationForm() {
        return this.personalInformationForm;
    }

    public void setPersonalInformationForm(PersonalInformationForm personalInformationForm) {
        this.personalInformationForm = personalInformationForm;
    }

    public ResidenceApplianceInquiryForm getResidenceApplianceInquiryForm() {
        return this.residenceApplianceInquiryForm;
    }

    public void setResidenceApplianceInquiryForm(ResidenceApplianceInquiryForm fillResidenceApplianceInquiryForm) {
        this.residenceApplianceInquiryForm = fillResidenceApplianceInquiryForm;
    }

    public HouseholdInformationForm getHouseholdInformationForm() {
        return this.householdInformationForm;
    }

    public void setHouseholdInformationForm(HouseholdInformationForm householdInformationForm) {
        this.householdInformationForm = householdInformationForm;
    }

    @Override
    public final CandidacyOperationType getType() {
        return CandidacyOperationType.FILL_PERSONAL_DATA;
    }

    @Override
    public final boolean isInput() {
        return true;
    }

    @Override
    public boolean isAuthorized(Person person) {
        return super.isAuthorized(person) && this.getCandidacy().getPerson() == person;
    }

    @Override
    protected void internalExecute() {
        this.fillPersonalInformation();
        this.fillFiliation();
        this.fillHouseholdInformation();
        this.fillResidenceInformation();
        this.fillContacts();
        this.fillPersonalDataAuthorizationChoice();
        this.fillOriginInformation();
        this.fillResidenceAppliance();
    }

    private void fillHouseholdInformation() {
        PersonalIngressionData personalData = this.getOrCreatePersonalIngressionData(this.getStudentCandidacy());
        personalData.setFatherProfessionalCondition(this.getHouseholdInformationForm().getFatherProfessionalCondition());
        personalData.setFatherProfessionType(this.getHouseholdInformationForm().getFatherProfessionType());
        personalData.setFatherSchoolLevel(this.getHouseholdInformationForm().getFatherSchoolLevel());
        personalData.setMotherProfessionalCondition(this.getHouseholdInformationForm().getMotherProfessionalCondition());
        personalData.setMotherProfessionType(this.getHouseholdInformationForm().getMotherProfessionType());
        personalData.setMotherSchoolLevel(this.getHouseholdInformationForm().getMotherSchoolLevel());
    }

    private void fillResidenceAppliance() {
        this.getStudentCandidacy().setApplyForResidence(this.getResidenceApplianceInquiryForm().isToApplyForResidence());
        this.getStudentCandidacy().setNotesAboutResidenceAppliance(this.getResidenceApplianceInquiryForm().getNotesAboutApplianceForResidence());
    }

    protected void fillOriginInformation() {
        Unit institution;
        PrecedentDegreeInformation precedentDegreeInformation = this.getStudentCandidacy().getPrecedentDegreeInformation();
        PersonalIngressionData personalData = this.getOrCreatePersonalIngressionData(precedentDegreeInformation);
        precedentDegreeInformation.setConclusionGrade(this.getOriginInformationForm().getConclusionGrade());
        precedentDegreeInformation.setDegreeDesignation(this.getOriginInformationForm().getDegreeDesignation());
        precedentDegreeInformation.setSchoolLevel(this.getOriginInformationForm().getSchoolLevel());
        if (this.getOriginInformationForm().getSchoolLevel() == SchoolLevelType.OTHER) {
            precedentDegreeInformation.setOtherSchoolLevel(this.getOriginInformationForm().getOtherSchoolLevel());
        }
        if ((institution = this.getOriginInformationForm().getInstitution()) == null && (institution = UnitUtils.readExternalInstitutionUnitByName(this.getOriginInformationForm().getInstitutionName())) == null) {
            institution = Unit.createNewNoOfficialExternalInstitution(this.getOriginInformationForm().getInstitutionName());
        }
        precedentDegreeInformation.setInstitution(institution);
        precedentDegreeInformation.setConclusionYear(this.getOriginInformationForm().getConclusionYear());
        precedentDegreeInformation.setCountry(this.getOriginInformationForm().getCountryWhereFinishedPreviousCompleteDegree());
        if (this.getOriginInformationForm().getSchoolLevel() != null && this.getOriginInformationForm().getSchoolLevel().isHighSchoolOrEquivalent()) {
            precedentDegreeInformation.setCountryHighSchool(this.getOriginInformationForm().getCountryWhereFinishedPreviousCompleteDegree());
        }
        personalData.setHighSchoolType(this.getOriginInformationForm().getHighSchoolType());
    }

    protected void fillPersonalDataAuthorizationChoice() {
        this.getStudentCandidacy().setStudentPersonalDataAuthorizationChoice(this.getInquiryAboutYieldingPersonalDataForm().getPersonalDataAuthorizationChoice());
        this.getStudentCandidacy().setStudentPersonalDataStudentsAssociationAuthorization(this.getInquiryAboutYieldingPersonalDataForm().getPersonalDataAuthorizationForStudentsAssociation());
    }

    protected void fillContacts() {
        Person person = this.getStudentCandidacy().getPerson();
        person.setDefaultEmailAddressValue(this.getContactsForm().getEmail(), false, this.getContactsForm().isEmailAvailable());
        person.setDefaultPhoneNumber(this.getContactsForm().getPhoneNumber());
        person.setDefaultWebAddressUrl(this.getContactsForm().getWebAddress());
        if (person.hasDefaultWebAddress()) {
            person.getDefaultWebAddress().setVisibleToPublic(this.getContactsForm().isHomepageAvailable());
        }
        person.setDefaultMobilePhoneNumber(this.getContactsForm().getMobileNumber());
    }

    protected void fillResidenceInformation() {
        PersonalIngressionData personalData = this.getOrCreatePersonalIngressionData(this.getStudentCandidacy());
        personalData.setCountryOfResidence(this.getResidenceInformationForm().getCountryOfResidence());
        personalData.setDistrictSubdivisionOfResidence(this.getResidenceInformationForm().getDistrictSubdivisionOfResidence());
        personalData.setDislocatedFromPermanentResidence(this.getResidenceInformationForm().getDislocatedFromPermanentResidence());
        if (this.getResidenceInformationForm().getDislocatedFromPermanentResidence().booleanValue()) {
            personalData.setSchoolTimeDistrictSubDivisionOfResidence(this.getResidenceInformationForm().getSchoolTimeDistrictSubdivisionOfResidence());
        }
        Person person = this.getStudentCandidacy().getPerson();
        this.setDefaultAddress(person);
        this.setSchoolTimeAddress(person);
    }

    private void setSchoolTimeAddress(Person person) {
        if (this.getResidenceInformationForm().getDislocatedFromPermanentResidence().booleanValue() && this.getResidenceInformationForm().isSchoolTimeAddressComplete()) {
            PhysicalAddressData physicalAddressData = new PhysicalAddressData(this.getResidenceInformationForm().getSchoolTimeAddress(), this.getResidenceInformationForm().getSchoolTimeAreaCode(), this.getResidenceInformationForm().getSchoolTimeAreaOfAreaCode(), this.getResidenceInformationForm().getSchoolTimeArea(), this.getResidenceInformationForm().getSchoolTimeParishOfResidence(), this.getResidenceInformationForm().getSchoolTimeDistrictSubdivisionOfResidence().getName(), this.getResidenceInformationForm().getSchoolTimeDistrictSubdivisionOfResidence().getDistrict().getName(), Country.readDefault());
            PhysicalAddress address = PhysicalAddress.createPhysicalAddress((Party)((Object)person), physicalAddressData, PartyContactType.PERSONAL, false);
            address.setValid();
        }
    }

    private void setDefaultAddress(Person person) {
        String districtSubdivisionOfResidence = this.getResidenceInformationForm().getDistrictSubdivisionOfResidence() != null ? this.getResidenceInformationForm().getDistrictSubdivisionOfResidence().getName() : null;
        String districtOfResidence = this.getResidenceInformationForm().getDistrictSubdivisionOfResidence().getDistrict() != null ? this.getResidenceInformationForm().getDistrictSubdivisionOfResidence().getDistrict().getName() : null;
        PhysicalAddressData physicalAddressData = new PhysicalAddressData(this.getResidenceInformationForm().getAddress(), this.getResidenceInformationForm().getAreaCode(), this.getResidenceInformationForm().getAreaOfAreaCode(), this.getResidenceInformationForm().getArea(), this.getResidenceInformationForm().getParishOfResidence(), districtSubdivisionOfResidence, districtOfResidence, this.getResidenceInformationForm().getCountryOfResidence());
        person.setDefaultPhysicalAddressData(physicalAddressData, true);
    }

    protected void fillFiliation() {
        Person person = this.getStudentCandidacy().getPerson();
        person.setNameOfFather(this.getFiliationForm().getFatherName());
        person.setNameOfMother(this.getFiliationForm().getMotherName());
        person.setDistrictOfBirth(this.getFiliationForm().getDistrictOfBirth());
        person.setDistrictSubdivisionOfBirth(this.getFiliationForm().getDistrictSubdivisionOfBirth());
        person.setParishOfBirth(this.getFiliationForm().getParishOfBirth());
        person.setDateOfBirthYearMonthDay(this.getFiliationForm().getDateOfBirth());
        person.setCountry(this.getFiliationForm().getNationality());
        person.setCountryOfBirth(this.getFiliationForm().getCountryOfBirth());
    }

    protected void fillPersonalInformation() {
        PersonalIngressionData personalData = this.getOrCreatePersonalIngressionData(this.getStudentCandidacy());
        personalData.setGrantOwnerType(this.getPersonalInformationForm().getGrantOwnerType());
        personalData.setGrantOwnerProvider(this.getPersonalInformationForm().getGrantOwnerProvider());
        personalData.setProfessionalCondition(this.getPersonalInformationForm().getProfessionalCondition());
        personalData.setProfessionType(this.getPersonalInformationForm().getProfessionType());
        personalData.setMaritalStatus(this.getPersonalInformationForm().getMaritalStatus());
        Person person = this.getStudentCandidacy().getPerson();
        person.setEmissionDateOfDocumentIdYearMonthDay(this.getPersonalInformationForm().getDocumentIdEmissionDate());
        person.setExpirationDateOfDocumentIdYearMonthDay(this.getPersonalInformationForm().getDocumentIdExpirationDate());
        person.setEmissionLocationOfDocumentId(this.getPersonalInformationForm().getDocumentIdEmissionLocation());
        person.setProfession(this.getPersonalInformationForm().getProfession());
        person.editSocialSecurityNumber(this.getPersonalInformationForm().getFiscalCountry(), this.getPersonalInformationForm().getSocialSecurityNumber());
        person.setIdDocumentType(this.getPersonalInformationForm().getIdDocumentType());
        person.setMaritalStatus(this.getPersonalInformationForm().getMaritalStatus());
        person.setIdentificationDocumentSeriesNumber(this.getPersonalInformationForm().getIdentificationDocumentSeriesNumber());
        person.setIdentificationDocumentExtraDigit(this.getPersonalInformationForm().getIdentificationDocumentExtraDigit());
    }

    private PersonalIngressionData getOrCreatePersonalIngressionData(StudentCandidacy studentCandidacy) {
        return this.getOrCreatePersonalIngressionData(studentCandidacy.getPrecedentDegreeInformation());
    }

    private PersonalIngressionData getOrCreatePersonalIngressionData(PrecedentDegreeInformation precedentInformation) {
        PersonalIngressionData personalData = null;
        personalData = precedentInformation.getPersonalIngressionData();
        if (personalData == null) {
            personalData = this.getPerson().getStudent().getPersonalIngressionDataByExecutionYear(ExecutionYear.readCurrentExecutionYear());
            if (personalData != null) {
                personalData.addPrecedentDegreesInformations(precedentInformation);
            } else {
                personalData = new PersonalIngressionData(ExecutionYear.readCurrentExecutionYear(), precedentInformation);
            }
        }
        return personalData;
    }
}

