/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.report;

import com.google.common.base.Strings;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.QueueJob;
import org.fenixedu.academic.domain.QueueJobResult;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.Receipt;
import org.fenixedu.academic.domain.accounting.events.AnnualEvent;
import org.fenixedu.academic.domain.accounting.events.gratuity.GratuityEvent;
import org.fenixedu.academic.domain.accounting.events.gratuity.PercentageGratuityExemption;
import org.fenixedu.academic.domain.accounting.events.gratuity.StandaloneEnrolmentGratuityEvent;
import org.fenixedu.academic.domain.accounting.events.gratuity.ValueGratuityExemption;
import org.fenixedu.academic.domain.accounting.report.GratuityReportQueueJobType;
import org.fenixedu.academic.domain.accounting.report.GratuityReportQueueJob_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.spreadsheet.Spreadsheet;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GratuityReportQueueJob
extends GratuityReportQueueJob_Base {
    private static final Logger logger = LoggerFactory.getLogger(GratuityReportQueueJob.class);

    private GratuityReportQueueJob() {
    }

    public GratuityReportQueueJob(GratuityReportQueueJobType type, ExecutionYear executionYear, DateTime beginDate, DateTime endDate) {
        this();
        this.checkParameters(type, executionYear, beginDate, endDate);
        this.setExecutionYear(executionYear);
        this.setType(type);
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
    }

    protected void checkParameters(GratuityReportQueueJobType type, ExecutionYear executionYear, DateTime beginDate, DateTime endDate) {
        if (executionYear == null) {
            throw new DomainException("error.gratuity.report.execution.year.cannot.be.null", new String[0]);
        }
        if (type == null) {
            throw new DomainException("error.gratuity.report.job.type.cannot.be.null", new String[0]);
        }
        if (type == GratuityReportQueueJobType.DATE_INTERVAL) {
            if (beginDate == null) {
                throw new DomainException("error.gratuity.report.job.beginDate.cannot.be.null", new String[0]);
            }
            if (endDate == null) {
                throw new DomainException("error.gratuity.report.job.endDate.cannot.be.null", new String[0]);
            }
            if (!beginDate.isBefore((ReadableInstant)endDate)) {
                throw new DomainException("error.gratuity.report.job.beginDate.must.be.before.endDate", new String[0]);
            }
        }
    }

    public QueueJobResult execute() throws Exception {
        ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
        this.buildReport().exportToCSV((OutputStream)byteArrayOS, ";");
        byteArrayOS.close();
        QueueJobResult queueJobResult = new QueueJobResult();
        queueJobResult.setContentType("text/csv");
        queueJobResult.setContent(byteArrayOS.toByteArray());
        logger.info("Job " + this.getFilename() + " completed");
        return queueJobResult;
    }

    private Spreadsheet buildReport() {
        Spreadsheet spreadsheet = new Spreadsheet(this.getFilename());
        spreadsheet.setHeaders(new String[]{"Aluno", "Nome", "N\u00ba Contribuinte", "Ano", "Curso", "Tipo de Curso", "Valor Em D\u00edvida", "Valor Total", "Valor Pago", "Valor Reembols\u00e1vel", "Tipo de Isen\u00e7\u00e3o", "Valor de Isen\u00e7\u00e3o", "Percentagem de Isen\u00e7\u00e3o", "Motivo", "Data de cria\u00e7\u00e3o", "Data de entrada do pagamento", "Montante inicial", "Montante ajustado", "Modo de pagamento", "Data de entrada do ajuste", "Montante do ajuste", "Justifica\u00e7\u00e3o"});
        int i = 0;
        for (GratuityEvent gratuityEvent : this.getGratuityEvents()) {
            GratuityEventEntry entry = new GratuityEventEntry(gratuityEvent);
            for (TransactionEntryDetail transaction : entry.getNonAdjustingTransactions()) {
                if (GratuityReportQueueJobType.DATE_INTERVAL.equals((Object)this.getType()) && (transaction.getWhenRegisteredDateTime().isBefore((ReadableInstant)this.getBeginDate()) || transaction.getWhenRegisteredDateTime().isAfter((ReadableInstant)this.getEndDate()))) continue;
                Spreadsheet.Row row = spreadsheet.addRow();
                this.fillWithGratuityEventInformation(row, entry);
                this.fillWithTransactionsInformation(row, transaction);
            }
            if (++i % 100 != 0) continue;
            logger.info(String.format("Lido %d propinas", i));
        }
        return spreadsheet;
    }

    private void fillWithTransactionsInformation(Spreadsheet.Row row, TransactionEntryDetail transaction) {
        row.setCell(transaction.getWhenRegistered());
        row.setCell(transaction.getOriginalAmount().toPlainString());
        row.setCell(transaction.getAmountWithAdjustment().toPlainString());
        row.setCell(transaction.getPaymentModeName());
        for (TransactionEntryDetail adjustment : transaction.getBoundAdjustingTransactions()) {
            row.setCell(adjustment.getWhenRegistered());
            row.setCell(adjustment.getAmountWithAdjustment().toPlainString());
            row.setCell(adjustment.getJustification());
        }
        if (transaction.getBoundAdjustingTransactions().isEmpty()) {
            row.setCell("");
            row.setCell("");
            row.setCell("");
        }
        for (String name : transaction.getReceiptContributorsNameForOtherParties()) {
            row.setCell(name);
        }
    }

    private void fillWithGratuityEventInformation(Spreadsheet.Row row, GratuityEventEntry entry) {
        row.setCell(entry.getStudentNumber());
        row.setCell(entry.getStudentName());
        row.setCell(entry.getSocialSecurityNumber());
        row.setCell(entry.getGratuityExecutionYearName());
        row.setCell(entry.getDegreeName());
        row.setCell(entry.getDegreeTypeName());
        row.setCell(entry.getDebtAmount().toPlainString());
        row.setCell(entry.getTotalAmount().toPlainString());
        row.setCell(entry.getPaidAmount().toPlainString());
        row.setCell(entry.getReimbuisedAmount().toPlainString());
        if (entry.hasExemption()) {
            row.setCell(entry.getExemptionJustificationName());
            row.setCell(entry.getExemptionValue().toPlainString());
            row.setCell(entry.getExemptionPercentage());
            row.setCell(entry.getExemptionReason());
        } else {
            row.setCell("");
            row.setCell("");
            row.setCell("");
            row.setCell("");
        }
        row.setCell(entry.getWhenOccured());
    }

    public String getFilename() {
        return String.format("PROPINAS_%s.csv", this.getRequestDate().toString("dd_MM_yyyy_hh_mm"));
    }

    protected Set<GratuityEvent> getGratuityEvents() {
        HashSet<GratuityEvent> result = new HashSet<GratuityEvent>();
        int i = 0;
        List<Object> executionYearList = null;
        if (GratuityReportQueueJobType.DATE_INTERVAL.equals((Object)this.getType())) {
            executionYearList = new ArrayList();
            executionYearList.addAll(Bennu.getInstance().getExecutionYearsSet());
        } else if (GratuityReportQueueJobType.EXECUTION_YEAR.equals((Object)this.getType())) {
            executionYearList = Collections.singletonList(this.getExecutionYear());
        }
        for (ExecutionYear executionYear : executionYearList) {
            for (AnnualEvent event : executionYear.getAnnualEventsSet()) {
                if (++i % 1000 == 0) {
                    logger.info(String.format("Read %s events", i));
                }
                if (event.isCancelled() || !event.isGratuity() || this.isToDiscard((GratuityEvent)((Object)event))) continue;
                result.add((GratuityEvent)((Object)event));
            }
        }
        return result;
    }

    private boolean isToDiscard(GratuityEvent gratuityEvent) {
        if (!(gratuityEvent instanceof StandaloneEnrolmentGratuityEvent)) {
            return false;
        }
        Collection<Enrolment> enrolmentsToCalculateGratuity = this.getEnrolmentsToCalculateGratuity(gratuityEvent);
        if (enrolmentsToCalculateGratuity.isEmpty()) {
            return true;
        }
        for (Enrolment enrolment : enrolmentsToCalculateGratuity) {
            if (!enrolment.getDegreeCurricularPlanOfDegreeModule().getDegree().isDEA()) continue;
            return true;
        }
        return false;
    }

    private Collection<Enrolment> getEnrolmentsToCalculateGratuity(GratuityEvent gratuityEvent) {
        if (!gratuityEvent.getDegree().isEmpty()) {
            if (!gratuityEvent.getStudentCurricularPlan().hasStandaloneCurriculumGroup()) {
                return Collections.emptySet();
            }
            return gratuityEvent.getStudentCurricularPlan().getStandaloneCurriculumGroup().getEnrolmentsBy(gratuityEvent.getExecutionYear());
        }
        return gratuityEvent.getStudentCurricularPlan().getRoot().getEnrolmentsBy(gratuityEvent.getExecutionYear());
    }

    public static List<GratuityReportQueueJob> retrieveAllGeneratedReports(ExecutionYear executionYear) {
        ArrayList<GratuityReportQueueJob> reports = new ArrayList<GratuityReportQueueJob>();
        CollectionUtils.select((Collection)executionYear.getGratuityReportQueueJobsSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                GratuityReportQueueJob gratuityQueueJob = (GratuityReportQueueJob)((Object)arg0);
                return gratuityQueueJob.getDone();
            }
        }, reports);
        return reports;
    }

    public static List<GratuityReportQueueJob> retrieveNotGeneratedReports(ExecutionYear executionYear) {
        ArrayList<GratuityReportQueueJob> reports = new ArrayList<GratuityReportQueueJob>();
        CollectionUtils.select((Collection)executionYear.getGratuityReportQueueJobsSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                GratuityReportQueueJob gratuityQueueJob = (GratuityReportQueueJob)((Object)arg0);
                return gratuityQueueJob.getDone() == false;
            }
        }, reports);
        return reports;
    }

    public static boolean canRequestReportGeneration() {
        return QueueJob.getUndoneJobsForClass(GratuityReportQueueJob.class).isEmpty();
    }

    private static class TransactionEntryDetail {
        AccountingTransaction transaction;

        public TransactionEntryDetail(AccountingTransaction transaction) {
            this.transaction = transaction;
        }

        public String getWhenRegistered() {
            return this.transaction.getWhenRegistered().toString("dd-MM-yyyy");
        }

        public DateTime getWhenRegisteredDateTime() {
            return this.transaction.getWhenRegistered();
        }

        public String getPaymentModeName() {
            return this.transaction.getPaymentMode().getLocalizedName();
        }

        public Money getOriginalAmount() {
            return this.transaction.getOriginalAmount();
        }

        public Money getAmountWithAdjustment() {
            return this.transaction.getAmountWithAdjustment();
        }

        public List<TransactionEntryDetail> getBoundAdjustingTransactions() {
            ArrayList<TransactionEntryDetail> adjustmentTransactions = new ArrayList<TransactionEntryDetail>();
            for (AccountingTransaction adjustment : this.transaction.getAdjustmentTransactionsSet()) {
                adjustmentTransactions.add(new TransactionEntryDetail(adjustment));
            }
            return adjustmentTransactions;
        }

        public String getJustification() {
            return this.transaction.getComments();
        }

        public boolean hasReceipts() {
            return this.transaction.getToAccountEntry().getReceiptsSet().size() > 0;
        }

        public String[] getReceiptContributorsNameForOtherParties() {
            if (!this.hasReceipts()) {
                return new ArrayList().toArray(new String[0]);
            }
            ArrayList<String> contributorsNames = new ArrayList<String>();
            for (Receipt receipt : this.transaction.getEntryFor(this.transaction.getFromAccount()).getReceiptsSet()) {
                if (!Strings.isNullOrEmpty((String)receipt.getContributorName())) {
                    contributorsNames.add(receipt.getContributorName());
                    continue;
                }
                if (Strings.isNullOrEmpty((String)receipt.getContributorNumber())) continue;
                contributorsNames.add(receipt.getContributorNumber());
            }
            return contributorsNames.toArray(new String[0]);
        }
    }

    private static class GratuityEventEntry {
        GratuityEvent event;

        public GratuityEventEntry(GratuityEvent event) {
            this.event = event;
        }

        public String getStudentNumber() {
            return this.event.getPerson().getStudent().getNumber().toString();
        }

        public String getStudentName() {
            return this.event.getPerson().getName();
        }

        public String getSocialSecurityNumber() {
            return this.event.getPerson().getSocialSecurityNumber();
        }

        public String getGratuityExecutionYearName() {
            return this.event.getExecutionYear().getName();
        }

        public String getDegreeName() {
            return this.event.getDegree().getNameI18N().getContent();
        }

        public String getDegreeTypeName() {
            return this.event.getDegree().getDegreeType().getName().getContent();
        }

        public String getWhenOccured() {
            return this.event.getWhenOccured().toString("dd/MM/yyyy");
        }

        public Money getOriginalTotalAmount() {
            return Money.ZERO;
        }

        public Money getTotalAmount() {
            return this.event.getTotalAmountToPay();
        }

        public Money getDebtAmount() {
            return this.event.getAmountToPay();
        }

        public Money getPaidAmount() {
            return this.event.getPayedAmount();
        }

        public Money getReimbuisedAmount() {
            return this.event.getReimbursableAmount();
        }

        public boolean hasExemption() {
            return this.event.hasGratuityExemption();
        }

        public String getExemptionJustificationName() {
            return this.hasExemption() ? this.event.getGratuityExemption().getJustificationType().getLocalizedName() : "";
        }

        public Money getExemptionValue() {
            if (!this.hasExemption()) {
                return Money.ZERO;
            }
            if (!this.event.getGratuityExemption().isValueExemption()) {
                return Money.ZERO;
            }
            return ((ValueGratuityExemption)((Object)this.event.getGratuityExemption())).getValue();
        }

        public BigDecimal getExemptionPercentage() {
            if (!this.hasExemption()) {
                return new BigDecimal(0.0);
            }
            if (!this.event.getGratuityExemption().isPercentageExemption()) {
                return new BigDecimal(0.0);
            }
            return ((PercentageGratuityExemption)((Object)this.event.getGratuityExemption())).getPercentage();
        }

        public String getExemptionReason() {
            if (!this.hasExemption()) {
                return "";
            }
            return this.event.getGratuityExemption().getReason();
        }

        public List<TransactionEntryDetail> getNonAdjustingTransactions() {
            ArrayList<TransactionEntryDetail> transactionList = new ArrayList<TransactionEntryDetail>();
            for (AccountingTransaction transaction : this.event.getNonAdjustingTransactions()) {
                transactionList.add(new TransactionEntryDetail(transaction));
            }
            return transactionList;
        }
    }
}

