/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.report;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.fenixedu.academic.util.Money;
import org.joda.time.LocalDate;

public class GratuityReport {
    private Map<LocalDate, GratuityReportEntry> entries = new HashMap<LocalDate, GratuityReportEntry>();

    public void addGratuityAmount(LocalDate date, Money amount) {
        if (!this.entries.containsKey(date)) {
            this.entries.put(date, new GratuityReportEntry(date));
        }
        this.entries.get(date).addGratuityAmount(amount);
    }

    public Collection<GratuityReportEntry> getEntries() {
        return this.entries.values();
    }

    public Money getTotalGratuityAmount() {
        Money result = Money.ZERO;
        for (GratuityReportEntry each : this.entries.values()) {
            result = result.add(each.getGratuityAmount());
        }
        return result;
    }

    public static class GratuityReportEntry {
        private LocalDate date;
        private Money gratuityAmount;

        public Money getGratuityAmount() {
            return this.gratuityAmount;
        }

        public void addGratuityAmount(Money amount) {
            this.gratuityAmount = this.gratuityAmount.add(amount);
        }

        public LocalDate getDate() {
            return this.date;
        }

        public void setDate(LocalDate date) {
            this.date = date;
        }

        public GratuityReportEntry(LocalDate date) {
            this.date = date;
            this.gratuityAmount = Money.ZERO;
        }
    }
}

