/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.serviceRequests;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.fenixedu.academic.domain.accounting.Account;
import org.fenixedu.academic.domain.accounting.AccountingTransaction;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.EquivalencePlanRequestEvent;
import org.fenixedu.academic.domain.accounting.postingRules.serviceRequests.EquivalencePlanRequestPR_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.DomainExceptionWithLabelFormatter;
import org.fenixedu.academic.dto.accounting.AccountingTransactionDetailDTO;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;

public class EquivalencePlanRequestPR
extends EquivalencePlanRequestPR_Base {
    private EquivalencePlanRequestPR() {
    }

    public EquivalencePlanRequestPR(DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money amountPerUnit, Money maximumAmount) {
        this();
        super.init(EntryType.EQUIVALENCE_PLAN_REQUEST_FEE, EventType.EQUIVALENCE_PLAN_REQUEST, startDate, endDate, serviceAgreementTemplate);
        this.checkParameters(amountPerUnit, maximumAmount);
        this.setAmountPerUnit(amountPerUnit);
        super.setMaximumAmount(maximumAmount);
    }

    private void checkParameters(Money amountPerUnit, Money maximumAmount) {
        if (amountPerUnit == null) {
            throw new DomainException("error.accounting.postingRules.EquivalencePlanRequestPR.amountPerUnit.cannot.be.null", new String[0]);
        }
        if (maximumAmount == null) {
            throw new DomainException("error.accounting.postingRules.EquivalencePlanRequestPR.maximumAmount.cannot.be.null", new String[0]);
        }
    }

    public void setMaximumAmount(Money maximumAmount) {
        throw new DomainException("error.accounting.postingRules.EquivalencePlanRequestPR.maximumAmount.cannot.be.modified", new String[0]);
    }

    public List<EntryDTO> calculateEntries(Event event, DateTime when) {
        Money calculateAmountToPay = event.calculateAmountToPay(when);
        return Collections.singletonList(new EntryDTO(this.getEntryType(), event, this.calculateTotalAmountToPay(event, when), event.getPayedAmount(), calculateAmountToPay, event.getDescriptionForEntryType(this.getEntryType()), calculateAmountToPay));
    }

    protected Money doCalculationForAmountToPay(Event event, DateTime when, boolean applyDiscount) {
        EquivalencePlanRequestEvent planRequest = (EquivalencePlanRequestEvent)((Object)event);
        Money amountToPay = this.getAmountPerUnit();
        if (planRequest.getNumberOfEquivalences() != null && planRequest.getNumberOfEquivalences() != 0) {
            amountToPay = amountToPay.multiply(planRequest.getNumberOfEquivalences());
        }
        if (this.getMaximumAmount().greaterThan(Money.ZERO) && amountToPay.greaterThan(this.getMaximumAmount())) {
            amountToPay = this.getMaximumAmount();
        }
        return amountToPay;
    }

    protected Money subtractFromExemptions(Event event, DateTime when, boolean applyDiscount, Money amountToPay) {
        EquivalencePlanRequestEvent planRequest = (EquivalencePlanRequestEvent)((Object)event);
        if (planRequest.hasAcademicEventExemption()) {
            amountToPay = amountToPay.subtract(planRequest.getAcademicEventExemption().getValue());
        }
        return amountToPay.isPositive() ? amountToPay : Money.ZERO;
    }

    protected Set<AccountingTransaction> internalProcess(User user, Collection<EntryDTO> entryDTOs, Event event, Account fromAccount, Account toAccount, AccountingTransactionDetailDTO transactionDetail) {
        if (entryDTOs.size() != 1) {
            throw new DomainException("error.accounting.postingRules.gratuity.EquivalencePlanRequestPR.invalid.number.of.entryDTOs", new String[0]);
        }
        this.checkIfCanAddAmount(entryDTOs.iterator().next().getAmountToPay(), event, transactionDetail.getWhenRegistered());
        return Collections.singleton(this.makeAccountingTransaction(user, event, fromAccount, toAccount, this.getEntryType(), entryDTOs.iterator().next().getAmountToPay(), transactionDetail));
    }

    private void checkIfCanAddAmount(Money amountToPay, Event event, DateTime whenRegistered) {
        Money totalFinalAmount = event.getPayedAmount().add(amountToPay);
        if (totalFinalAmount.lessThan(this.calculateTotalAmountToPay(event, whenRegistered))) {
            throw new DomainExceptionWithLabelFormatter("error.accounting.postingRules.gratuity.EquivalencePlanRequestPR.amount.being.payed.must.be.equal.to.amount.in.debt", event.getDescriptionForEntryType(this.getEntryType()));
        }
    }

    public EquivalencePlanRequestPR edit(Money amountPerUnit, Money maximumAmount) {
        this.deactivate();
        return new EquivalencePlanRequestPR(new DateTime().minus(1000L), null, this.getServiceAgreementTemplate(), amountPerUnit, maximumAmount);
    }

    public String getMaximumAmountDescription() {
        if (Money.ZERO.equals(this.getMaximumAmount())) {
            return BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.base.amount.plus.units.with.no.maximum.value", (String[])new String[0]);
        }
        return this.getMaximumAmount().getAmountAsString();
    }
}

