/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.postingRules.serviceRequests;

import java.math.BigDecimal;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.CertificateRequestEvent;
import org.fenixedu.academic.domain.accounting.postingRules.serviceRequests.CertificateRequestPR_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;

public class CertificateRequestPR
extends CertificateRequestPR_Base {
    protected CertificateRequestPR() {
    }

    public CertificateRequestPR(EntryType entryType, EventType eventType, DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money baseAmount, Money amountPerUnit, Money amountPerPage, Money maximumAmount) {
        this.init(entryType, eventType, startDate, endDate, serviceAgreementTemplate, baseAmount, amountPerUnit, amountPerPage, maximumAmount);
    }

    protected void init(EntryType entryType, EventType eventType, DateTime startDate, DateTime endDate, ServiceAgreementTemplate serviceAgreementTemplate, Money baseAmount, Money amountPerUnit, Money amountPerPage, Money maximumAmount) {
        super.init(entryType, eventType, startDate, endDate, serviceAgreementTemplate, baseAmount, amountPerUnit, maximumAmount);
        this.checkParameters(amountPerPage);
        super.setAmountPerPage(amountPerPage);
    }

    private void checkParameters(Money amountPerPage) {
        if (amountPerPage == null) {
            throw new DomainException("error.accounting.postingRules.serviceRequests.CertificateRequestPR.amountPerPage.cannot.be.null", new String[0]);
        }
    }

    public void setAmountPerPage(Money amountPerPage) {
        throw new DomainException("error.accounting.postingRules.serviceRequests.CertificateRequestPR.cannot.modify.amountPerPage", new String[0]);
    }

    protected Integer getNumberOfUnits(Event event) {
        return ((CertificateRequestEvent)((Object)event)).getNumberOfUnits();
    }

    protected boolean isUrgent(CertificateRequestEvent certificateRequestEvent) {
        return certificateRequestEvent.isUrgentRequest();
    }

    protected Money doCalculationForAmountToPay(Event event, DateTime when, boolean applyDiscount) {
        CertificateRequestEvent certificateRequestEvent = (CertificateRequestEvent)((Object)event);
        Money totalAmountToPay = this.isUrgent(certificateRequestEvent) ? this.getBaseAmount().multiply(BigDecimal.valueOf(2L)).add(this.getAmountForUnits(event)) : super.doCalculationForAmountToPay(event, when, applyDiscount);
        totalAmountToPay = totalAmountToPay.add(this.calculateAmountToPayForPages(certificateRequestEvent));
        return totalAmountToPay;
    }

    protected Money calculateAmountToPayForPages(CertificateRequestEvent event) {
        return this.getAmountPerPage().multiply(BigDecimal.valueOf(event.getNumberOfPages().intValue()));
    }

    public CertificateRequestPR edit(Money baseAmount, Money amountPerUnit, Money amountPerPage, Money maximumAmount) {
        this.deactivate();
        return new CertificateRequestPR(this.getEntryType(), this.getEventType(), new DateTime().minus(1000L), null, this.getServiceAgreementTemplate(), baseAmount, amountPerUnit, amountPerPage, maximumAmount);
    }
}

