/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.AcademicEvent;
import org.fenixedu.academic.domain.accounting.Event;
import org.fenixedu.academic.domain.accounting.Exemption;
import org.fenixedu.academic.domain.accounting.events.AcademicEventExemption$callable$create;
import org.fenixedu.academic.domain.accounting.events.AcademicEventExemption_Base;
import org.fenixedu.academic.domain.accounting.events.ExemptionJustification;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.AcademicEventExemptionJustification;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.AcademicEventJustificationType;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class AcademicEventExemption
extends AcademicEventExemption_Base {
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    private AcademicEventExemption() {
    }

    public AcademicEventExemption(Person responsible, AcademicEvent event, Money value, AcademicEventJustificationType justificationType, LocalDate dispatchDate, String reason) {
        this();
        super.init(responsible, (Event)((Object)event), this.createJustification(justificationType, dispatchDate, reason));
        String[] args = new String[]{};
        if (value == null) {
            throw new DomainException("error.AcademicEventExemption.invalid.amount", args);
        }
        this.setValue(value);
        event.recalculateState(new DateTime());
    }

    private ExemptionJustification createJustification(AcademicEventJustificationType justificationType, LocalDate dispatchDate, String reason) {
        return new AcademicEventExemptionJustification(this, justificationType, dispatchDate, reason);
    }

    public void delete() {
        this.checkRulesToDelete();
        super.delete();
    }

    private void checkRulesToDelete() {
        if (this.getEvent().hasAnyPayments()) {
            throw new DomainException("error.accounting.events.candidacy.AcademicEventExemption.cannot.delete.event.has.payments", new String[0]);
        }
    }

    public LocalDate getDispatchDate() {
        return ((AcademicEventExemptionJustification)((Object)this.getExemptionJustification())).getDispatchDate();
    }

    public static AcademicEventExemption create(Person person, AcademicEvent academicEvent, Money money, AcademicEventJustificationType academicEventJustificationType, LocalDate localDate, String string) {
        return (AcademicEventExemption)((Object)advice$create.perform((Callable)new AcademicEventExemption$callable$create(person, academicEvent, money, academicEventJustificationType, localDate, string)));
    }

    static /* synthetic */ AcademicEventExemption advised$create(Person responsible, AcademicEvent event, Money value, AcademicEventJustificationType justificationType, LocalDate dispatchDate, String reason) {
        return new AcademicEventExemption(responsible, event, value, justificationType, dispatchDate, reason);
    }

    public boolean isAcademicEventExemption() {
        return true;
    }

    static {
        AcademicEventExemption.getRelationExemptionEvent().addListener((RelationListener)new RelationAdapter<Exemption, Event>(){

            public void beforeAdd(Exemption exemption, Event event) {
                AcademicEvent academicEvent;
                if (exemption != null && event != null && exemption instanceof AcademicEventExemption && (academicEvent = (AcademicEvent)((Object)event)).hasAcademicEventExemption()) {
                    throw new DomainException("error.accounting.events.AcademicEventExemption.event.already.has.exemption", new String[0]);
                }
            }
        });
    }
}

